/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.SchemaComponent;
import ch.agent.crnickl.impl.Containable;
import ch.agent.crnickl.impl.SchemaComponentContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class SchemaComponents<T extends SchemaComponent>
implements SchemaComponentContainer,
Containable {
    private Map<Integer, T> components = new TreeMap<Integer, T>();
    private Map<Integer, T> editedComponents;
    private Map<String, T> byName = new HashMap<String, T>();
    private SchemaComponentContainer container;

    public SchemaComponents(Collection<T> components) throws T2DBException {
        if (components != null) {
            for (SchemaComponent component : components) {
                if (this.components.put(component.getNumber(), component) == null) continue;
                throw T2DBMsg.exception("D30135", component.getNumber());
            }
            this.makeIndex();
        }
    }

    @Override
    public void setContainer(SchemaComponentContainer container) {
        this.container = container;
    }

    @Override
    public void nameChanged(boolean attribute, String oldName, String newName) throws T2DBException {
        if (attribute) {
            this.makeIndex();
        } else if (this.container != null) {
            this.container.nameChanged(false, oldName, newName);
        } else {
            this.makeIndex();
        }
    }

    public boolean isComplete() {
        boolean complete = true;
        for (SchemaComponent compo : this.getMap().values()) {
            if (compo.isComplete()) continue;
            complete = false;
            break;
        }
        assert (!complete || this.getMap().size() == this.byName.size());
        return complete;
    }

    public Collection<T> getComponents() {
        return this.getMap().values();
    }

    protected Map<Integer, T> getMap() {
        return this.editedComponents == null ? this.components : this.editedComponents;
    }

    public T getComponent(int number) {
        return (T)((SchemaComponent)this.getMap().get(number));
    }

    public T getComponent(String name) {
        return (T)(name == null ? null : (SchemaComponent)this.byName.get(name));
    }

    public T editComponent(int number) {
        this.edit();
        SchemaComponent component = (SchemaComponent)this.editedComponents.get(number);
        if (component != null) {
            component.edit();
        }
        return (T)component;
    }

    public boolean addComponent(T component) throws T2DBException {
        boolean added = false;
        this.edit();
        Integer number = component.getNumber();
        if (this.editedComponents.get(number) == null) {
            String name = component.getName();
            if (this.getComponent(name) != null) {
                throw T2DBMsg.exception("D30130", name);
            }
            this.byName.put(name, component);
            component.edit();
            this.editedComponents.put(number, component);
            if (component instanceof Containable) {
                ((Containable)component).setContainer(this);
            }
            added = true;
        }
        return added;
    }

    public boolean deleteComponent(int number) {
        this.edit();
        SchemaComponent component = (SchemaComponent)this.editedComponents.remove(number);
        if (component != null) {
            String name = component.getName();
            if (name != null) {
                this.byName.remove(name);
            }
            if (component instanceof Containable) {
                ((Containable)((Object)component)).setContainer(null);
            }
        }
        return component != null;
    }

    protected void edit() {
        if (this.editedComponents == null) {
            this.editedComponents = new HashMap<Integer, T>();
            for (Integer key : this.components.keySet()) {
                SchemaComponent component = ((SchemaComponent)this.components.get(key)).copy();
                if (component instanceof Containable) {
                    ((Containable)((Object)component)).setContainer(this);
                }
                this.editedComponents.put(key, component);
            }
        }
    }

    public void consolidate() {
        if (this.editedComponents != null) {
            this.components = this.editedComponents;
            for (SchemaComponent component : this.components.values()) {
                if (!(component instanceof Containable)) continue;
                ((Containable)((Object)component)).setContainer(null);
            }
            this.editedComponents = null;
        }
    }

    private void makeIndex() throws T2DBException {
        this.byName.clear();
        for (SchemaComponent component : this.getMap().values()) {
            String name = component.getName();
            if (name == null || this.byName.put(name, component) == null) continue;
            throw T2DBMsg.exception("D30130", name);
        }
    }

    public String toString() {
        return this.components.values().toString();
    }
}

