/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.impl.ChronicleUpdatePolicy;
import ch.agent.crnickl.impl.ChronicleUpdatePolicyExtension;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.t2.T2Exception;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeIndex;

public class ChronicleUpdatePolicyImpl
implements ChronicleUpdatePolicy {
    private ChronicleUpdatePolicyExtension extension;

    public ChronicleUpdatePolicyImpl(DatabaseBackend database, ChronicleUpdatePolicyExtension extension) {
        this.extension = extension;
    }

    @Override
    public void willDelete(UpdatableChronicle entity) throws T2DBException {
        int entityCount = entity.getMembers().size();
        int seriesCount = entity.getSeries().size();
        if (entityCount > 0 || seriesCount > 0) {
            throw T2DBMsg.exception("D40130", entity.getName(true), entityCount, seriesCount);
        }
        if (this.extension != null) {
            this.extension.willDelete(entity);
        }
    }

    @Override
    public void willDelete(UpdatableSeries<?> series) throws T2DBException {
        try {
            Range range = series.getRange();
            if (!range.isEmpty()) {
                throw T2DBMsg.exception("D50130", series.getName(true), range.toString());
            }
        }
        catch (T2Exception e) {
            throw T2DBMsg.exception(e, "D50102", series.getName(true));
        }
        if (this.extension != null) {
            this.extension.willDelete(series);
        }
    }

    @Override
    public void willUpdate(UpdatableChronicle entity) throws T2DBException {
        if (this.extension != null) {
            this.extension.willUpdate(entity);
        }
    }

    @Override
    public void willUpdate(UpdatableSeries<?> series, Range range) throws T2DBException {
        if (this.extension != null) {
            this.extension.willUpdate(series, range);
        }
    }

    @Override
    public void willDelete(UpdatableSeries<?> series, TimeIndex index) throws T2DBException {
        if (this.extension != null) {
            this.extension.willDelete(series, index);
        }
    }

    @Override
    public boolean deleteChronicle(UpdatableChronicle entity) throws T2DBException {
        if (this.extension != null) {
            return this.extension.deleteChronicle(entity);
        }
        return false;
    }

    @Override
    public boolean deleteSeries(UpdatableSeries<?> series) throws T2DBException {
        if (this.extension != null) {
            return this.extension.deleteSeries(series);
        }
        return false;
    }

    @Override
    public boolean deleteValue(UpdatableSeries<?> series, TimeIndex index) throws T2DBException {
        if (this.extension != null) {
            return this.extension.deleteValue(series, index);
        }
        return false;
    }

    @Override
    public boolean update(UpdatableSeries<?> series, Range range) throws T2DBException {
        if (this.extension != null) {
            return this.extension.update(series, range);
        }
        return false;
    }
}

