/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.SchemaComponent;
import ch.agent.crnickl.impl.AttributeImpl;
import ch.agent.crnickl.impl.SchemaComponentImpl;

public class AttributeDefinitionImpl<T>
extends SchemaComponentImpl
implements AttributeDefinition<T> {
    private int seriesNr;
    private int number;
    private Property<T> property;
    private Object value;
    private boolean erasing;
    private boolean valueNullChecked;

    public AttributeDefinitionImpl(int seriesNr, int number, Property<T> property, T value) throws T2DBException {
        if (number < 1) {
            throw T2DBMsg.exception("D30117", new Object[0]);
        }
        this.number = number;
        this.property = property;
        if (value != null) {
            this.getProperty().getValueType().check(value);
        }
        this.value = value;
        this.seriesNr = seriesNr;
    }

    @Override
    public boolean isComplete() {
        boolean complete = false;
        if (!this.isErasing() && this.property != null) {
            if (this.value == null && !this.valueNullChecked) {
                try {
                    this.checkType(true);
                    complete = true;
                }
                catch (T2DBException t2DBException) {}
            } else {
                complete = true;
            }
        }
        return complete;
    }

    @Override
    public boolean isErasing() {
        return this.erasing;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public Property<T> getProperty() {
        return this.property;
    }

    @Override
    public String getName() {
        return this.property == null ? null : this.property.getName();
    }

    @Override
    public T getValue() {
        return (T)this.value;
    }

    @Override
    public Attribute<T> getAttribute() {
        if (!this.isComplete()) {
            throw new IllegalStateException();
        }
        return new AttributeImpl(this);
    }

    public String toString() {
        return this.property == null ? "" + this.number : this.property.getName() + " " + this.value;
    }

    @Override
    public int compareTo(AttributeDefinition<T> o) {
        if (this.getNumber() > o.getNumber()) {
            return 1;
        }
        if (this.getNumber() < o.getNumber()) {
            return -1;
        }
        return 0;
    }

    public void setErasing(boolean erasing) {
        this.checkEdit();
        this.doSetErasing(erasing);
    }

    private void doSetErasing(boolean erasing) {
        this.erasing = erasing;
        if (erasing) {
            this.property = null;
            this.value = null;
        }
    }

    public void setProperty(Property<T> property) throws T2DBException {
        String oldName = this.property == null ? null : this.property.getName();
        this.checkEdit();
        this.property = property;
        try {
            this.checkType(this.valueNullChecked);
        }
        catch (T2DBException e) {
            throw T2DBMsg.exception((Throwable)((Object)e), "D30133", this.getValue(), this.getNumber(), property);
        }
        String newName = this.property == null ? null : this.property.getName();
        try {
            if (!this.same(oldName, newName)) {
                this.nameChanged(true, oldName, newName);
            }
        }
        catch (T2DBException e) {
            if (this.seriesNr == 0) {
                throw T2DBMsg.exception((Throwable)((Object)e), "D30151", this.getNumber());
            }
            throw T2DBMsg.exception((Throwable)((Object)e), "D30152", this.getNumber(), this.seriesNr);
        }
        if (property != null) {
            this.doSetErasing(false);
        }
        this.valueNullChecked = false;
    }

    public void setValue(Object value) throws T2DBException {
        Object old = this.value;
        if (!this.same(old, value)) {
            this.checkEdit();
            this.value = value;
            this.checkType(true);
            if (this.seriesNr > 0 && this.number == 1) {
                try {
                    this.nameChanged(false, (String)old, (String)value);
                }
                catch (T2DBException e) {
                    throw T2DBMsg.exception((Throwable)((Object)e), "D30153", this.seriesNr);
                }
            }
        }
        if (value != null) {
            this.doSetErasing(false);
        }
    }

    @Override
    public void edit(SchemaComponent component) {
        if (!(component instanceof AttributeDefinition)) {
            throw new IllegalArgumentException(component == null ? null : component.getClass().getName());
        }
        AttributeDefinition arg = (AttributeDefinition)component;
        if (arg.isErasing()) {
            this.doSetErasing(true);
        } else {
            if (arg.getProperty() != null) {
                this.property = arg.getProperty();
            }
            if (arg.getValue() != null) {
                this.value = arg.getValue();
            }
        }
    }

    private void checkType(boolean alsoIfValueNull) throws T2DBException {
        if (this.property != null && (alsoIfValueNull || this.value != null)) {
            if (!this.property.getValueType().isCompatible(this.value)) {
                if (this.value instanceof String) {
                    this.value = this.property.getValueType().scan((String)this.value);
                } else {
                    throw T2DBMsg.exception("D30132", this.value, this.property, this.property.getValueType());
                }
            }
            this.property.getValueType().check(this.value);
            if (this.value == null) {
                this.valueNullChecked = true;
            }
        }
    }

    @Override
    public SchemaComponent copy() {
        try {
            AttributeDefinitionImpl<Object> ad = new AttributeDefinitionImpl<Object>(this.seriesNr, this.number, this.property, this.value);
            super.doSetErasing(this.isErasing());
            return ad;
        }
        catch (T2DBException e) {
            throw new RuntimeException("bug", (Throwable)((Object)e));
        }
    }

    @Override
    public <S> AttributeDefinition<S> typeCheck(Class<S> type) throws T2DBException {
        this.getProperty().typeCheck(type);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isErasing() ? 1231 : 1237);
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeDefinitionImpl other = (AttributeDefinitionImpl)obj;
        if (this.isErasing() != other.isErasing()) {
            return false;
        }
        if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    private boolean same(Object x, Object y) {
        return x == null ? y == null : x.equals(y);
    }
}

