/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.api;

import ch.agent.core.KeyedException;
import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.DatabaseConfiguration;
import ch.agent.crnickl.api.DatabaseFactory;
import ch.agent.t2.applied.DefaultTimeDomainCatalog;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class SimpleDatabaseManager {
    private Database database;
    private String dbName;
    private String dbClass;
    private String timeDomainCatalogClass;
    private Map<String, String> parameters;
    private Set<String> duplicateFileDetector;
    private Pattern listSep;
    private Pattern kvSep;
    private String fileKey;
    private String dbNameKey;
    private String dbClassKey;
    private String timeDomainCatalogClassKey;

    public SimpleDatabaseManager(String dbName, String dbClass, String tdcClass, Map<String, String> parameters) {
        this.dbName = dbName;
        this.dbClass = dbClass;
        this.timeDomainCatalogClass = tdcClass;
        this.parameters = parameters;
    }

    public SimpleDatabaseManager(String listSeparator, String kvSeparator, String dbNameKey, String dbClassKey, String tdcClassKey, String fileKey, String parameterString) throws T2DBException {
        try {
            if (listSeparator == null || kvSeparator == null || fileKey == null || dbNameKey == null || dbClassKey == null || tdcClassKey == null || parameterString == null) {
                throw new IllegalArgumentException("no null argument allowed");
            }
            this.listSep = Pattern.compile(listSeparator);
            this.kvSep = Pattern.compile(kvSeparator);
            this.fileKey = fileKey;
            this.dbNameKey = dbNameKey;
            this.dbClassKey = dbClassKey;
            this.timeDomainCatalogClassKey = tdcClassKey;
            this.parameters = new LinkedHashMap<String, String>();
            this.initialize(parameterString);
            if (this.dbName == null) {
                throw T2DBMsg.exception("D00113", new Object[0]);
            }
            if (this.dbClass == null) {
                throw T2DBMsg.exception("D00114", new Object[0]);
            }
            if (this.timeDomainCatalogClass == null || this.timeDomainCatalogClass.length() == 0) {
                this.timeDomainCatalogClass = DefaultTimeDomainCatalog.class.getName();
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception(e, "D00112", parameterString, listSeparator, kvSeparator);
        }
    }

    public SimpleDatabaseManager(String parameterString) throws T2DBException {
        this("\\s*,\\s*", "\\s*=\\s*", "db.name", "db.class", "timedomaincatalog.class", "file", parameterString);
    }

    public Database getDatabase() throws KeyedException {
        if (this.database == null) {
            this.setUp();
        }
        return this.database;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    private void initialize(String parameterString) throws Exception {
        this.duplicateFileDetector = new HashSet<String>();
        List<String> pairs = Arrays.asList(this.listSep.split(parameterString, -1));
        this.parseKeyValuePairs(false, pairs, null);
    }

    private void parseKeyValuePairs(boolean loose, List<String> pairs, Map<String, String> keyMap) throws Exception {
        for (String pair : pairs) {
            try {
                this.parseKeyValuePair(loose, pair, keyMap);
            }
            catch (Exception e) {
                if (e instanceof T2DBException && ((T2DBException)((Object)e)).getMsg().getKey().equals("D00111")) {
                    throw e;
                }
                throw T2DBMsg.exception(e, "D00111", pair);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseKeyValuePair(boolean loose, String pair, Map<String, String> keyMap) throws Exception {
        String[] kv = this.kvSep.split(pair.trim(), 2);
        if (kv.length != 2 || kv[0].length() == 0) {
            if (!loose) throw T2DBMsg.exception("D00111", pair);
            kv[0] = null;
        } else if (keyMap != null) {
            String mapped = keyMap.get(kv[0]);
            kv[0] = mapped != null ? mapped : null;
        }
        if (kv[0] == null) return;
        if (kv[0].equals(this.fileKey)) {
            String[] fileNameAndKeyMappings = this.listSep.split(kv[1], -1);
            if (fileNameAndKeyMappings.length <= 0) return;
            this.parseKeyValuePairs(true, this.extract(fileNameAndKeyMappings[0]), this.makeMap(fileNameAndKeyMappings));
            return;
        } else {
            this.setParameter(kv[0], kv[1]);
        }
    }

    private Map<String, String> makeMap(String[] fileNameAndKeyMappings) throws Exception {
        HashMap<String, String> map = null;
        if (fileNameAndKeyMappings.length > 1) {
            map = new HashMap<String, String>(fileNameAndKeyMappings.length - 1);
            for (int i = 1; i < fileNameAndKeyMappings.length; ++i) {
                String[] kv = this.kvSep.split(fileNameAndKeyMappings[i].trim(), 2);
                if (kv.length != 2 || kv[0].length() == 0 || kv[1].length() == 0) {
                    throw T2DBMsg.exception("D00111", fileNameAndKeyMappings[i]);
                }
                map.put(kv[0], kv[1]);
            }
        }
        return map;
    }

    private List<String> extract(String fileName) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        List<String> lines = this.readLines(fileName);
        StringBuffer accumulator = new StringBuffer();
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            if (line.endsWith(" \\")) {
                accumulator.append(line);
                int l = accumulator.length();
                accumulator.delete(l - 1, l);
                continue;
            }
            accumulator.append(line);
            line = accumulator.toString();
            accumulator.delete(0, accumulator.length());
            if (line.length() == 0) continue;
            result.add(line);
        }
        if (accumulator.length() > 0) {
            throw T2DBMsg.exception("D00115", fileName);
        }
        return result;
    }

    private List<String> readLines(String fileName) throws Exception {
        if (!this.duplicateFileDetector.add(fileName)) {
            throw T2DBMsg.exception("D00116", fileName);
        }
        InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(fileName);
        if (inputStream == null) {
            inputStream = new FileInputStream(fileName);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        return lines;
    }

    private void setParameter(String key, String value) {
        if (key.equals(this.dbNameKey)) {
            this.dbName = value;
        } else if (key.equals(this.dbClassKey)) {
            this.dbClass = value;
        } else if (key.equals(this.timeDomainCatalogClassKey)) {
            this.timeDomainCatalogClass = value;
        } else {
            this.parameters.put(key, value);
        }
    }

    private void setUp() throws KeyedException {
        DatabaseFactory dbf = DatabaseFactory.getInstance();
        DatabaseConfiguration config = new DatabaseConfiguration(this.dbName, this.dbClass, this.timeDomainCatalogClass);
        for (Map.Entry<String, String> e : this.parameters.entrySet()) {
            config.setParameter(e.getKey(), e.getValue());
        }
        dbf.addDatabase(config);
        this.database = dbf.getDatabase(this.dbName);
    }
}

