/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.api;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamingPolicy {
    private static final String VALUE_DESCRIPTION_FORMAT = "%s - %s";
    private static final String VALUE_DESCRIPTION_SPLITTER = " - ";
    private static final int NAME_MAX_LENGTH = 25;
    public static final String NAME_SEPARATOR = ".";
    private static final String NAME_SPLITTER = "\\.";
    public static final String DESCRIPTION_SEPARATOR = "; ";
    public static final String LIST_SEPARATOR = ", ";
    private static final Pattern invalidCharPattern = Pattern.compile("[^A-Za-z0-9_\\-]");

    public String[] split(String name) throws T2DBException {
        if (name == null || name.length() == 0) {
            throw T2DBMsg.exception("D01102", new Object[0]);
        }
        int i = name.lastIndexOf(NAME_SEPARATOR);
        if (i < 0) {
            return new String[]{null, name};
        }
        return new String[]{name.substring(0, i), name.substring(i + 1)};
    }

    public String[] asStringArray(String name) throws T2DBException {
        return name.split(NAME_SPLITTER, -1);
    }

    public String checkSimpleName(String name, boolean canModify) throws T2DBException {
        if (name == null || name.length() == 0 || name.length() > 25) {
            throw T2DBMsg.exception("D01103", name, 25);
        }
        Matcher invalidCharMatcher = invalidCharPattern.matcher(name);
        if (invalidCharMatcher.find()) {
            if (canModify) {
                name = invalidCharMatcher.replaceAll("_");
            } else {
                throw T2DBMsg.exception("D01104", name);
            }
        }
        return name.toLowerCase();
    }

    public String fullName(String ... names) {
        return this.join(NAME_SEPARATOR, names);
    }

    public String fullName(List<String> names) {
        return this.join(NAME_SEPARATOR, names.toArray(new String[names.size()]));
    }

    public String fullDescription(String ... descriptions) {
        return this.join(DESCRIPTION_SEPARATOR, descriptions);
    }

    public String fullDescription(List<String> descriptions) {
        return this.join(DESCRIPTION_SEPARATOR, descriptions.toArray(new String[descriptions.size()]));
    }

    public String joinValueAndDescription(String value, String description) {
        if (description == null || description.length() == 0) {
            return value;
        }
        return String.format(VALUE_DESCRIPTION_FORMAT, value, description);
    }

    public String[] splitValueAndDescription(String valueAndDescription) {
        String[] stringArray;
        if (valueAndDescription == null) {
            return new String[]{null, null};
        }
        String[] result = valueAndDescription.split(VALUE_DESCRIPTION_SPLITTER, 2);
        if (result.length == 1) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = result[0];
            stringArray = stringArray2;
            stringArray2[1] = "";
        } else {
            stringArray = result;
        }
        return stringArray;
    }

    protected String join(String separator, String ... strings) {
        StringBuilder b = new StringBuilder();
        int size = strings.length;
        int i = 0;
        for (String string : strings) {
            if (string != null) {
                b.append(string);
            }
            if (++i >= size) continue;
            b.append(separator);
        }
        return b.toString();
    }
}

