/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.api;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.DatabaseConfiguration;
import ch.agent.t2.time.TimeDomainCatalog;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DatabaseFactory {
    private Map<String, DatabaseConfiguration> databases = new HashMap<String, DatabaseConfiguration>();

    public static DatabaseFactory getInstance() {
        return Singleton.factory;
    }

    private DatabaseFactory() {
    }

    public void addDatabase(DatabaseConfiguration configuration) throws T2DBException {
        String name = configuration.getName();
        if (this.databases.put(name, configuration) != null) {
            throw T2DBMsg.exception("D00103", name);
        }
    }

    public Database getDefaultDatabase() throws T2DBException {
        if (this.databases.size() == 1) {
            return this.getDatabase(this.databases.keySet().iterator().next());
        }
        throw T2DBMsg.exception("D00102", new Object[0]);
    }

    public Collection<String> getDatabaseNames() {
        return this.databases.keySet();
    }

    public Database getDatabase(String name) throws T2DBException {
        if (name == null) {
            return this.getDefaultDatabase();
        }
        DatabaseConfiguration configuration = this.databases.get(name);
        if (configuration == null) {
            throw T2DBMsg.exception("D00101", name);
        }
        try {
            Class<? extends Database> dbClass = configuration.getDatabaseClass();
            Constructor<? extends Database> constructor = dbClass.getConstructor(String.class, TimeDomainCatalog.class);
            Database d = constructor.newInstance(name, configuration.getTimeDomainCatalog());
            d.configure(configuration);
            return d;
        }
        catch (Exception e) {
            throw T2DBMsg.exception(e, "D00105", name);
        }
    }

    private static class Singleton {
        private static DatabaseFactory factory = new DatabaseFactory();

        private Singleton() {
        }
    }
}

