/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.api;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Database;
import ch.agent.t2.applied.DefaultTimeDomainCatalog;
import ch.agent.t2.time.TimeDomainCatalog;
import java.util.LinkedHashMap;
import java.util.Map;

public class DatabaseConfiguration {
    private String databaseName;
    private Class<? extends Database> databaseClass;
    private TimeDomainCatalog timeDomainCatalog;
    private Map<String, String> parameters;

    public DatabaseConfiguration(String databaseName, String databaseClassName, String timeDomainCatalogClassName) throws T2DBException {
        this.databaseName = databaseName;
        try {
            this.databaseClass = Class.forName(databaseClassName);
        }
        catch (Exception e) {
            throw T2DBMsg.exception(e, "D00104", databaseName);
        }
        if (timeDomainCatalogClassName == null || timeDomainCatalogClassName.length() == 0) {
            this.timeDomainCatalog = new DefaultTimeDomainCatalog();
        } else {
            try {
                this.timeDomainCatalog = (TimeDomainCatalog)Class.forName(timeDomainCatalogClassName).newInstance();
            }
            catch (Exception e) {
                throw T2DBMsg.exception(e, "D00106", timeDomainCatalogClassName);
            }
        }
        this.parameters = new LinkedHashMap<String, String>();
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getName() {
        return this.databaseName;
    }

    public Class<? extends Database> getDatabaseClass() {
        return this.databaseClass;
    }

    public TimeDomainCatalog getTimeDomainCatalog() {
        return this.timeDomainCatalog;
    }

    public String getParameter(String key, boolean mustExist) throws T2DBException {
        String value = this.parameters.get(key);
        if (value == null && mustExist) {
            throw T2DBMsg.exception("D00109", key);
        }
        return value;
    }
}

