/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.NamingPolicy;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.ValueScanner;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.DBObjectImpl;
import ch.agent.crnickl.impl.UpdatableValueTypeImpl;
import ch.agent.crnickl.impl.ValueAccessMethods;
import ch.agent.t2.time.DateTime;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeDomainFactory;
import ch.agent.t2.time.TimeDomainManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValueTypeImpl<T>
extends DBObjectImpl
implements ValueType<T> {
    private static final int MAX_NAME_LENGTH = 25;
    private static final String NAME_PATTERN = "[A-Za-z0-9_][A-Za-z0-9_,\\-]*";
    private ValueScanner<T> scanner;
    private ValueAccessMethods<T> am;
    private String name;
    private boolean restricted;
    private Map<T, String> values;
    private ValueType.StandardValueType keyword;

    protected ValueTypeImpl(ValueTypeImpl<T> valueType) throws T2DBException {
        super(valueType.getSurrogate());
        this.scanner = valueType.scanner;
        this.am = valueType.am;
        this.name = valueType.name;
        this.restricted = valueType.restricted;
        this.values = valueType.values;
        this.keyword = valueType.keyword;
    }

    public ValueTypeImpl(String name, boolean restricted, String scannerClassOrKeyword, Map<String, String> valuesAndDescriptions, Surrogate surrogate) throws T2DBException {
        super(surrogate);
        this.name = name;
        this.restricted = restricted;
        this.scanner = this.findStandardScanner(scannerClassOrKeyword);
        this.setValues(valuesAndDescriptions);
        this.am = this.getDatabase().getAccessMethods(this);
    }

    protected void update() throws T2DBException {
        this.name = this.getName();
        ValueType vt = this.getDatabase().getValueType(this.getSurrogate());
        this.values = vt.getValueDescriptions();
    }

    private void setValues(Map<String, String> valuesAndDescriptions) throws T2DBException {
        if (valuesAndDescriptions == null || valuesAndDescriptions.size() == 0) {
            this.values = new HashMap<T, String>();
        } else {
            if (!this.isRestricted()) {
                throw T2DBMsg.exception("D10108", this.getName());
            }
            if (this.getType().equals(String.class)) {
                this.values = new LinkedHashMap<String, String>(valuesAndDescriptions);
            } else {
                this.values = new LinkedHashMap<T, String>();
                for (Map.Entry<String, String> e : valuesAndDescriptions.entrySet()) {
                    T value = this.scanner.scan(e.getKey());
                    this.values.put(value, e.getValue());
                }
            }
        }
    }

    private ValueScanner<T> findStandardScanner(ValueType.StandardValueType type) throws T2DBException {
        ValueScanner<Boolean> sc = null;
        switch (type) {
            case BOOLEAN: {
                sc = this.scanner = new BooleanScanner();
                break;
            }
            case DATE: {
                this.scanner = new DateScanner();
                sc = this.scanner;
                break;
            }
            case DATETIME: {
                this.scanner = new DateTimeScanner();
                sc = this.scanner;
                break;
            }
            case NAME: {
                this.scanner = new NameScanner();
                sc = this.scanner;
                break;
            }
            case NUMBER: {
                this.scanner = new NumberScanner();
                sc = this.scanner;
                break;
            }
            case TEXT: {
                this.scanner = new TextScanner();
                sc = this.scanner;
                break;
            }
            case TIMEDOMAIN: {
                this.scanner = new TimeDomainScanner();
                sc = this.scanner;
                break;
            }
            case TYPE: {
                this.scanner = new TypeScanner(this.getSurrogate().getDatabase());
                sc = this.scanner;
                break;
            }
            default: {
                throw new RuntimeException(type.name());
            }
        }
        this.keyword = type;
        return sc;
    }

    private ValueScanner<T> findStandardScanner(String scannerClassOrKeyword) throws T2DBException {
        ValueType.StandardValueType type = null;
        ValueScanner scanner = null;
        try {
            type = ValueType.StandardValueType.valueOf(scannerClassOrKeyword);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (type == null) {
            this.keyword = null;
            try {
                Class<?> scannerClass = Class.forName(scannerClassOrKeyword);
                try {
                    Constructor<?> constructor = scannerClass.getConstructor(ValueType.class);
                    scanner = (ValueScanner)constructor.newInstance(this);
                }
                catch (NoSuchMethodException e) {
                    scanner = (ValueScanner)scannerClass.newInstance();
                }
            }
            catch (Exception e) {
                throw T2DBMsg.exception(e, "D10110", this.name, scannerClassOrKeyword);
            }
        } else {
            scanner = this.findStandardScanner(type);
        }
        return scanner;
    }

    @Override
    public UpdatableValueType<T> edit() {
        try {
            return new UpdatableValueTypeImpl(this);
        }
        catch (T2DBException e) {
            throw new RuntimeException("bug", (Throwable)((Object)e));
        }
    }

    public <S> ValueAccessMethods<T> getAccessMethods() throws T2DBException {
        if (this.am == null) {
            throw T2DBMsg.exception("D10102", this.toString());
        }
        return this.am;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    @Override
    @Deprecated
    public boolean isBuiltIn() {
        return false;
    }

    @Override
    public Class<T> getType() {
        return this.scanner.getType();
    }

    @Override
    public ValueScanner<T> getScanner() {
        return this.scanner;
    }

    @Override
    public Set<T> getValues() {
        return this.values.keySet();
    }

    @Override
    public Map<T, String> getValueDescriptions() {
        return this.values;
    }

    @Override
    public boolean isCompatible(Object obj) {
        return obj == null || this.getType().isInstance(obj);
    }

    @Override
    public T scan(String value) throws T2DBException {
        T result = null;
        if (value != null && value.length() == 0 && !this.isRestricted()) {
            value = null;
        }
        if (value != null) {
            result = this.scanner.scan(value);
            if (result == null) {
                if (value.length() != 0) {
                    throw T2DBMsg.exception("D10114", value, this.getName());
                }
            } else {
                this.check(result);
            }
        }
        return result;
    }

    @Override
    public void check(T value) throws T2DBException {
        if (this.isRestricted() && !this.values.containsKey(value)) {
            throw T2DBMsg.exception("D10115", value, this.getName());
        }
    }

    @Override
    public String toString(Object value) throws T2DBException {
        String result = null;
        try {
            if (!this.isRestricted() || this.values.containsKey(value)) {
                result = this.scanner.toString(value);
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception(e, "D10114", value, this.getName());
        }
        return result;
    }

    @Override
    public Collection<String> getValues(String format) {
        NamingPolicy namingPolicy = this.getDatabase().getNamingPolicy();
        try {
            Map<T, String> map = this.getValueDescriptions();
            ArrayList<String> list = new ArrayList<String>(map.size());
            for (Map.Entry<T, String> e : map.entrySet()) {
                String value = this.toString(e.getKey());
                String descr = e.getValue();
                if (descr != null && descr.length() > 0) {
                    value = format == null ? namingPolicy.joinValueAndDescription(value, descr) : String.format(format, value, descr);
                }
                list.add(value);
            }
            Collections.sort(list);
            return list;
        }
        catch (T2DBException e) {
            throw new RuntimeException("bug", (Throwable)((Object)e));
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getExternalRepresentation() {
        if (this.keyword == null) {
            return this.scanner.getClass().getName();
        }
        return this.keyword.name();
    }

    @Override
    public ValueType.StandardValueType getStandardValueType() {
        return this.keyword;
    }

    @Override
    public <S> ValueType<S> typeCheck(Class<S> type) throws T2DBException {
        try {
            if (type.isAssignableFrom(this.getScanner().getType())) {
                return this;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw T2DBMsg.exception("D10101", this.getName(), type.getName(), this.getScanner().getType().getName());
    }

    public static class TypeScanner
    implements ValueScanner<ValueType> {
        private Database database;

        public TypeScanner(Database database) {
            this.database = database;
        }

        @Override
        public Class<ValueType> getType() {
            return ValueType.class;
        }

        @Override
        public void check(ValueType value) {
        }

        @Override
        public ValueType<?> scan(String value) throws T2DBException {
            try {
                return this.database.getValueType(value);
            }
            catch (Exception e) {
                throw T2DBMsg.exception(e, "D10107", value, ValueType.class.getName());
            }
        }

        @Override
        public String toString(ValueType value) {
            return value == null ? null : value.getName();
        }
    }

    public static class DateTimeScanner
    implements ValueScanner<DateTime> {
        @Override
        public Class<DateTime> getType() {
            return DateTime.class;
        }

        @Override
        public void check(DateTime value) {
        }

        @Override
        public DateTime scan(String value) throws T2DBException {
            try {
                return new DateTime(value);
            }
            catch (Exception e) {
                throw T2DBMsg.exception(e, "D10107", value, ValueType.class.getName());
            }
        }

        @Override
        public String toString(DateTime value) {
            return value == null ? null : value.toString();
        }
    }

    public static class DateScanner
    implements ValueScanner<Day> {
        @Override
        public Class<Day> getType() {
            return Day.class;
        }

        @Override
        public void check(Day value) {
        }

        @Override
        public Day scan(String value) throws T2DBException {
            try {
                return new Day(value);
            }
            catch (Exception e) {
                throw T2DBMsg.exception(e, "D10107", value, ValueType.class.getName());
            }
        }

        @Override
        public String toString(Day value) {
            return value == null ? null : value.toString();
        }
    }

    public static class TimeDomainScanner
    implements ValueScanner<TimeDomain> {
        private TimeDomainFactory factory = TimeDomainManager.getFactory();

        @Override
        public Class<TimeDomain> getType() {
            return TimeDomain.class;
        }

        @Override
        public void check(TimeDomain value) {
        }

        @Override
        public TimeDomain scan(String value) throws T2DBException {
            try {
                return this.factory.get(value);
            }
            catch (Exception e) {
                throw T2DBMsg.exception(e, "D10107", value, ValueType.class.getName());
            }
        }

        @Override
        public String toString(TimeDomain value) {
            return value == null ? null : value.getLabel();
        }
    }

    public static class NameScanner
    implements ValueScanner<String> {
        private Matcher validNameMatcher = Pattern.compile("[A-Za-z0-9_][A-Za-z0-9_,\\-]*").matcher("");

        @Override
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public void check(String value) throws T2DBException {
            if (value == null || value.length() == 0 || value.length() > 25) {
                throw T2DBMsg.exception("D10105", value, 0, 25);
            }
            this.validNameMatcher.reset(value);
            if (!this.validNameMatcher.matches()) {
                throw T2DBMsg.exception("D10104", value, ValueTypeImpl.NAME_PATTERN);
            }
        }

        @Override
        public String scan(String value) throws T2DBException {
            this.check(value);
            return value;
        }

        @Override
        public String toString(String value) throws T2DBException {
            this.check(value);
            return value;
        }
    }

    public static class TextScanner
    implements ValueScanner<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public void check(String value) {
        }

        @Override
        public String scan(String value) {
            return value;
        }

        @Override
        public String toString(String value) {
            return value;
        }
    }

    public static class NumberScanner
    implements ValueScanner<Double> {
        @Override
        public Class<Double> getType() {
            return Double.class;
        }

        @Override
        public void check(Double value) {
        }

        @Override
        public Double scan(String value) throws T2DBException {
            try {
                return new Double(value);
            }
            catch (NumberFormatException e) {
                if (value != null && value.equals("-")) {
                    return Double.NaN;
                }
                throw T2DBMsg.exception("D10103", value);
            }
        }

        @Override
        public String toString(Double value) {
            return value == null ? null : value.toString();
        }
    }

    public static class BooleanScanner
    implements ValueScanner<Boolean> {
        @Override
        public Class<Boolean> getType() {
            return Boolean.class;
        }

        @Override
        public void check(Boolean value) {
        }

        @Override
        public Boolean scan(String value) throws T2DBException {
            return new Boolean(value);
        }

        @Override
        public String toString(Boolean value) {
            return value == null ? null : value.toString();
        }
    }
}

