/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.SeriesImpl;
import ch.agent.t2.T2Exception;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.timeseries.Observation;
import ch.agent.t2.timeseries.TimeAddressable;
import ch.agent.t2.timeseries.TimeSeriesFactory;
import java.util.HashSet;
import java.util.Set;

public class UpdatableSeriesImpl<T>
extends SeriesImpl<T>
implements UpdatableSeries<T> {
    private boolean delete;
    private Range range;
    private TimeAddressable<T> updates;
    private Set<TimeIndex> deletes;

    public UpdatableSeriesImpl(Chronicle chronicle, String name, int number, Surrogate surrogate) {
        super(chronicle, name, number, surrogate);
    }

    @Override
    public UpdatableSeries<T> edit() {
        return this;
    }

    @Override
    public <S> UpdatableSeries<S> typeCheck(Class<S> type) throws T2DBException {
        try {
            if (type.isAssignableFrom(this.getValueType().getType())) {
                return this;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw T2DBMsg.exception("D50101", this.getName(true), type.getName(), this.getValueType().getType().getName());
    }

    @Override
    public TimeAddressable<T> getValues(Range reqRange) throws T2Exception, T2DBException {
        if (reqRange != null) {
            reqRange.getTimeDomain().requireEquality(this.getTimeDomain());
        }
        TimeAddressable result = TimeSeriesFactory.make((TimeDomain)this.getTimeDomain(), this.getValueType().getType(), (boolean)true);
        if (!this.getSurrogate().inConstruction()) {
            this.getDatabase().getValues(this, reqRange, result);
        }
        if (this.range != null) {
            result.setRange(this.range);
        } else {
            if (this.updates != null) {
                for (Observation obs : this.updates) {
                    long t = obs.getIndex();
                    if (!this.isInRange(t, reqRange)) continue;
                    result.put(t, obs.getValue());
                }
            }
            if (this.deletes != null) {
                for (TimeIndex t : this.deletes) {
                    if (!this.isInRange(t.asLong(), reqRange)) continue;
                    result.remove(t);
                }
            }
        }
        return result;
    }

    private boolean isInRange(long t, Range r) {
        return r == null || r.isInRange(t);
    }

    @Override
    public Range getRange() throws T2Exception, T2DBException {
        Range result = super.getRange();
        if (this.range != null) {
            result = result.intersection(this.range);
        } else {
            if (this.updates != null) {
                result = result.union(this.updates.getRange());
            }
            if (this.deletes != null) {
                boolean tryHarder = false;
                for (TimeIndex t : this.deletes) {
                    if (t.asLong() != result.getFirstIndex() && t.asLong() != result.getLastIndex()) continue;
                    tryHarder = true;
                    break;
                }
                if (tryHarder) {
                    result = this.getValues(null).getRange();
                }
            }
        }
        return result;
    }

    @Override
    public Observation<T> getLastObservation(TimeIndex time) throws T2Exception, T2DBException {
        Observation result = super.getLastObservation(time);
        if (this.range != null) {
            if (result != null && this.range.getLastIndex() < result.getIndex()) {
                result = super.getLastObservation(this.range.getLast());
            }
        } else {
            if (this.updates != null) {
                Observation obs = this.updates.getLast(time);
                if (result == null || obs.getIndex() > result.getIndex()) {
                    result = obs;
                }
            }
            if (result != null && this.deletes != null) {
                boolean tryHarder = false;
                for (TimeIndex t : this.deletes) {
                    if (t.asLong() != result.getIndex()) continue;
                    tryHarder = true;
                    break;
                }
                if (tryHarder) {
                    result = this.getValues(null).getLast(time);
                }
            }
        }
        return result;
    }

    @Override
    public Observation<T> getFirstObservation(TimeIndex time) throws T2Exception, T2DBException {
        Observation result = super.getFirstObservation(time);
        if (this.range != null) {
            if (result != null && this.range.getFirstIndex() > result.getIndex()) {
                result = super.getFirstObservation(this.range.getFirst());
            }
        } else {
            if (this.updates != null) {
                Observation obs = this.updates.getFirst(time);
                if (result == null || obs.getIndex() < result.getIndex()) {
                    result = obs;
                }
            }
            if (result != null && this.deletes != null) {
                boolean tryHarder = false;
                for (TimeIndex t : this.deletes) {
                    if (t.asLong() != result.getIndex()) continue;
                    tryHarder = true;
                    break;
                }
                if (tryHarder) {
                    result = this.getValues(null).getFirst(time);
                }
            }
        }
        return result;
    }

    @Override
    public void scanValue(TimeIndex t, Object value) throws T2Exception, T2DBException {
        ValueType vt = this.getValueType();
        if (vt.isCompatible(value)) {
            this.setValue(t, value);
        } else if (value instanceof String) {
            this.setValue(t, vt.scan((String)value));
        } else {
            throw T2DBMsg.exception("D10114", value, vt.getType().getName());
        }
    }

    @Override
    public void setValue(TimeIndex t, T value) throws T2Exception, T2DBException {
        if (this.delete || this.range != null) {
            throw T2DBMsg.exception("D50109", this.getName(true));
        }
        if (value == null) {
            t.getTimeDomain().requireEquality(this.getTimeDomain());
            if (this.deletes == null) {
                this.deletes = new HashSet<TimeIndex>();
            }
            this.deletes.add(t);
            if (this.updates != null) {
                this.updates.remove(t);
            }
        } else {
            if (this.updates == null) {
                this.updates = TimeSeriesFactory.make((TimeDomain)this.getTimeDomain(), this.getValueType().getType(), (boolean)true);
                this.updates.put(t, value);
            } else {
                this.updates.put(t, value);
            }
            if (this.deletes != null) {
                this.deletes.remove(t);
            }
        }
    }

    @Override
    public void setValues(TimeAddressable<T> values) throws T2Exception, T2DBException {
        if (this.delete || this.range != null) {
            throw T2DBMsg.exception("D50109", this.getName(true));
        }
        for (Observation obs : values) {
            Object v = obs.getValue();
            if (values.isMissing(v)) {
                this.setValue(obs.getTime(), null);
                continue;
            }
            this.setValue(obs.getTime(), v);
        }
    }

    @Override
    public boolean setRange(Range range) throws T2Exception, T2DBException {
        boolean inRange;
        if (this.getSurrogate().inConstruction()) {
            throw T2DBMsg.exception("D50111", this.getName(true));
        }
        if (this.delete || this.updates != null || this.deletes != null) {
            throw T2DBMsg.exception("D50110", this.getName(true));
        }
        if (range == null) {
            range = new Range(this.getTimeDomain());
        }
        boolean bl = inRange = range.isEmpty() || this.getRange().isInRange(range);
        if (inRange) {
            this.range = range;
        }
        return inRange;
    }

    @Override
    public void destroy() throws T2DBException {
        if (this.getSurrogate().inConstruction()) {
            throw T2DBMsg.exception("D50111", this.getName(true));
        }
        if (this.updates != null || this.deletes != null || this.range != null) {
            throw T2DBMsg.exception("D50107", this.getName(true));
        }
        this.delete = true;
    }

    @Override
    public void applyUpdates() throws T2DBException {
        if (this.delete) {
            this.getDatabase().deleteSeries(this);
            this.delete = false;
        } else {
            if (this.getSurrogate().inConstruction()) {
                this.getDatabase().create(this);
            }
            if (this.updates != null) {
                this.getDatabase().update(this, this.updates);
            }
            if (this.deletes != null) {
                for (TimeIndex t : this.deletes) {
                    this.getDatabase().deleteValue(this, t);
                }
            }
            if (this.range != null) {
                this.getDatabase().update(this, this.range);
            }
            this.update();
        }
    }

    @Override
    protected void update() {
        super.update();
        this.updates = null;
        this.deletes = null;
        this.range = null;
    }
}

