/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.AttributeDefinitionImpl;
import ch.agent.crnickl.impl.SchemaImpl;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.impl.SeriesDefinitionImpl;
import ch.agent.crnickl.impl.UpdatableSchemaVisitor;
import ch.agent.t2.time.TimeDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdatableSchemaImpl
extends SchemaImpl
implements UpdatableSchema {
    private boolean delete;
    private UpdatableSchema base;
    private String editedName;
    private UpdatableSchema editedBase;
    private SchemaUpdatePolicy policy;

    public UpdatableSchemaImpl(String name, UpdatableSchema base, Collection<AttributeDefinition<?>> attributeDefs, Collection<SeriesDefinition> seriesDefinitions, Surrogate surrogate) throws T2DBException {
        super(true, name, attributeDefs, seriesDefinitions, surrogate, null);
        this.base = base;
        this.editedBase = base;
        this.policy = this.getDatabase().getSchemaUpdatePolicy();
    }

    @Override
    public void applyUpdates() throws T2DBException {
        if (this.delete) {
            this.getDatabase().getCache().clear(this);
            this.policy.willDelete(this);
            this.getDatabase().deleteSchema(this);
            this.delete = false;
        } else {
            if (this.getSurrogate().inConstruction()) {
                this.policy.willUpdate(this);
                this.getDatabase().create(this);
            } else {
                this.getDatabase().getCache().clear(this);
                this.policy.willUpdate(this);
                this.getDatabase().update(this);
            }
            this.update();
        }
    }

    @Override
    protected void update() throws T2DBException {
        super.update();
        this.base = this.editedBase;
        this.editedName = null;
        this.getAttributeDefinitionsObject().consolidate();
        this.getSeriesDefinitionsObject().consolidate();
    }

    @Override
    public UpdatableSchema edit() {
        return this;
    }

    @Override
    public void destroy() throws T2DBException {
        this.delete = true;
    }

    @Override
    public String getName() {
        if (this.editedName != null) {
            return this.editedName;
        }
        return super.getName();
    }

    @Override
    public void setName(String name) throws T2DBException {
        if (name == null || name.length() == 0) {
            throw T2DBMsg.exception("D01102", new Object[0]);
        }
        this.editedName = name;
    }

    @Override
    public UpdatableSchema getBase() {
        return this.editedBase;
    }

    public UpdatableSchema getPreviousBase() {
        return this.base;
    }

    @Override
    public void setBase(UpdatableSchema base) throws T2DBException {
        if (base != null && base.inConstruction()) {
            throw T2DBMsg.exception("D30128", base.getName());
        }
        this.editedBase = base;
    }

    @Override
    public SeriesDefinition addSeries(int seriesNr) throws T2DBException {
        return this.addSeries(seriesNr, false);
    }

    private SeriesDefinition addSeries(int seriesNr, boolean merging) throws T2DBException {
        SeriesDefinitionImpl ss = new SeriesDefinitionImpl(seriesNr, null, null);
        boolean added = false;
        try {
            added = this.getSeriesDefinitionsObject().addComponent(ss);
        }
        catch (T2DBException e) {
            throw T2DBMsg.exception((Throwable)((Object)e), "D30137", seriesNr, this);
        }
        if (!added && !merging) {
            throw T2DBMsg.exception("D30124", seriesNr, this);
        }
        return ss;
    }

    @Override
    public void deleteSeries(int seriesNr) throws T2DBException {
        if (!this.getSeriesDefinitionsObject().deleteComponent(seriesNr)) {
            throw T2DBMsg.exception("D30125", seriesNr, this.getName());
        }
    }

    @Override
    public void eraseSeries(int seriesNr) throws T2DBException {
        this.startEditingSeriesSchema(seriesNr).setErasing(true);
    }

    @Override
    public void setSeriesDescription(int seriesNr, String description) throws T2DBException {
        this.editSeriesAttributeDefinition(seriesNr, 1, true);
        this.startEditingSeriesSchema(seriesNr).setDescription(description);
    }

    @Override
    public void setSeriesName(int seriesNr, String name) throws T2DBException {
        AttributeDefinitionImpl def = this.editSeriesAttributeDefinition(seriesNr, 1, false);
        if (def == null) {
            Property<?> property = this.getDatabase().getSymbolBuiltInProperty();
            def = (AttributeDefinitionImpl)this.addAttribute(seriesNr, 1);
            def.setProperty(property);
        }
        def.setValue(name);
    }

    @Override
    public void setSeriesType(int seriesNr, ValueType<?> type) throws T2DBException {
        AttributeDefinitionImpl def = this.editSeriesAttributeDefinition(seriesNr, 2, false);
        if (def == null) {
            Property<?> property = this.getDatabase().getTypeBuiltInProperty();
            def = (AttributeDefinitionImpl)this.addAttribute(seriesNr, 2);
            def.setProperty(property);
        }
        def.setValue(type);
    }

    @Override
    public void setSeriesType(int seriesNr, String type) throws T2DBException {
        ValueType<?> vt = this.getDatabase().getTypeBuiltInProperty().getValueType();
        this.setSeriesType(seriesNr, (ValueType)vt.scan(type));
    }

    @Override
    public void setSeriesTimeDomain(int seriesNr, TimeDomain timeDomain) throws T2DBException {
        AttributeDefinitionImpl def = this.editSeriesAttributeDefinition(seriesNr, 3, false);
        if (def == null) {
            Property<?> property = this.getDatabase().getTimeDomainBuiltInProperty();
            def = (AttributeDefinitionImpl)this.addAttribute(seriesNr, 3);
            def.setProperty(property);
        }
        def.setValue(timeDomain);
    }

    @Override
    public void setSeriesSparsity(int seriesNr, boolean sparse) throws T2DBException {
        AttributeDefinitionImpl def = this.editSeriesAttributeDefinition(seriesNr, 4, false);
        if (def == null) {
            Property<?> property = this.getDatabase().getSparsityBuiltInProperty();
            def = (AttributeDefinitionImpl)this.addAttribute(seriesNr, 4);
            def.setProperty(property);
        }
        def.setValue(sparse);
    }

    @Override
    public AttributeDefinition<?> addAttribute(int attrNr) throws T2DBException {
        return this.addAttribute(attrNr, false);
    }

    private AttributeDefinition<?> addAttribute(int attrNr, boolean merging) throws T2DBException {
        AttributeDefinitionImpl<Object> def = new AttributeDefinitionImpl<Object>(0, attrNr, null, null);
        boolean added = false;
        try {
            added = this.getAttributeDefinitionsObject().addComponent(def);
        }
        catch (T2DBException e) {
            throw T2DBMsg.exception((Throwable)((Object)e), "D30136", attrNr, this);
        }
        if (!added && !merging) {
            throw T2DBMsg.exception("D30127", attrNr, this);
        }
        return def;
    }

    @Override
    public void deleteAttribute(int attrNr) throws T2DBException {
        if (!this.getAttributeDefinitionsObject().deleteComponent(attrNr)) {
            throw T2DBMsg.exception("D30123", attrNr, this.getName());
        }
    }

    @Override
    public void eraseAttribute(int attrNr) throws T2DBException {
        this.editAttributeDefinition(attrNr).setErasing(true);
    }

    @Override
    public <T> void setAttributeProperty(int attrNr, Property<T> property) throws T2DBException {
        this.editAttributeDefinition(attrNr).setProperty(property);
    }

    @Override
    public <T> void setAttributeDefault(int attrNr, T defaultValue) throws T2DBException {
        this.editAttributeDefinition(attrNr).setValue(defaultValue);
    }

    @Override
    public AttributeDefinition<?> addAttribute(int seriesNr, int attrNr) throws T2DBException {
        return this.addAttribute(seriesNr, attrNr, false);
    }

    private AttributeDefinition<?> addAttribute(int seriesNr, int attrNr, boolean merging) throws T2DBException {
        AttributeDefinitionImpl<Object> def = new AttributeDefinitionImpl<Object>(seriesNr, attrNr, null, null);
        boolean added = false;
        try {
            added = this.startEditingSeriesSchema(seriesNr).getAttributeDefinitionsObject().addComponent(def);
        }
        catch (T2DBException e) {
            throw T2DBMsg.exception((Throwable)((Object)e), "D30138", attrNr, seriesNr, this);
        }
        if (!added && !merging) {
            throw T2DBMsg.exception("D30118", attrNr, seriesNr, this);
        }
        return def;
    }

    @Override
    public void deleteAttribute(int seriesNr, int attrNr) throws T2DBException {
        if (!this.startEditingSeriesSchema(seriesNr).getAttributeDefinitionsObject().deleteComponent(attrNr)) {
            throw T2DBMsg.exception("D30126", attrNr, seriesNr, this.getName());
        }
    }

    @Override
    public void eraseAttribute(int seriesNr, int attrNr) throws T2DBException {
        this.editSeriesAttributeDefinition(seriesNr, attrNr, true).setErasing(true);
    }

    @Override
    public void setAttributeProperty(int seriesNr, int attrNr, Property<?> property) throws T2DBException {
        this.editSeriesAttributeDefinition(seriesNr, attrNr, true).setProperty(property);
    }

    @Override
    public void setAttributeDefault(int seriesNr, int attrNr, Object defaultValue) throws T2DBException {
        this.editSeriesAttributeDefinition(seriesNr, attrNr, true).setValue(defaultValue);
    }

    protected SeriesDefinitionImpl startEditingSeriesSchema(int seriesNr) throws T2DBException {
        SeriesDefinitionImpl sch = (SeriesDefinitionImpl)this.getSeriesDefinitionsObject().editComponent(seriesNr);
        if (sch == null) {
            throw T2DBMsg.exception("D30125", seriesNr, this.getName());
        }
        return sch;
    }

    protected AttributeDefinitionImpl<?> editAttributeDefinition(int attrNr) throws T2DBException {
        AttributeDefinitionImpl def = (AttributeDefinitionImpl)this.getAttributeDefinitionsObject().editComponent(attrNr);
        if (def == null) {
            throw T2DBMsg.exception("D30123", attrNr, this.getName());
        }
        return def;
    }

    protected AttributeDefinitionImpl<?> editSeriesAttributeDefinition(int seriesNr, int attrNr, boolean mustExist) throws T2DBException {
        AttributeDefinitionImpl def = (AttributeDefinitionImpl)this.startEditingSeriesSchema(seriesNr).getAttributeDefinitionsObject().editComponent(attrNr);
        if (def == null && mustExist) {
            throw T2DBMsg.exception("D30126", attrNr, seriesNr, this.getName());
        }
        return def;
    }

    public void merge(UpdatableSchema schema) throws T2DBException {
        for (AttributeDefinition<?> def : schema.getAttributeDefinitions()) {
            int dn = def.getNumber();
            if (def.isErasing()) {
                this.deleteAttribute(dn);
                continue;
            }
            this.addAttribute(dn, true);
            if (def.getProperty() != null) {
                this.setAttributeProperty(dn, def.getProperty());
            }
            if (def.getValue() == null) continue;
            this.setAttributeDefault(dn, def.getValue());
        }
        for (SeriesDefinition ss : schema.getSeriesDefinitions()) {
            int sn = ss.getNumber();
            if (ss.isErasing()) {
                this.deleteSeries(sn);
                continue;
            }
            this.addSeries(sn, true);
            for (AttributeDefinition<?> def : ss.getAttributeDefinitions()) {
                int dn = def.getNumber();
                if (def.isErasing()) {
                    this.deleteAttribute(sn, dn);
                    continue;
                }
                this.addAttribute(sn, dn, true);
                if (def.getProperty() != null) {
                    this.setAttributeProperty(sn, dn, def.getProperty());
                }
                if (def.getValue() == null) continue;
                this.setAttributeDefault(sn, dn, def.getValue());
            }
            if (ss.getDescription() == null) continue;
            this.setSeriesDescription(sn, ss.getDescription());
        }
    }

    protected Schema consolidate(String name, Surrogate surrogate, List<Surrogate> dependencyList) throws T2DBException {
        this.getAttributeDefinitionsObject().consolidate();
        this.getSeriesDefinitionsObject().consolidate();
        return new SchemaImpl(name, this.getAttributeDefinitions(), this.getSeriesDefinitions(), surrogate, dependencyList);
    }

    @Override
    public Schema resolve() throws T2DBException {
        List<UpdatableSchema> schemaList = this.getSchemaList();
        Collections.reverse(schemaList);
        UpdatableSchemaImpl result = null;
        for (UpdatableSchema schema : schemaList) {
            if (result == null) {
                result = new UpdatableSchemaImpl(schema.getName(), schema.getBase(), schema.getAttributeDefinitions(), schema.getSeriesDefinitions(), schema.getSurrogate());
                continue;
            }
            result.merge(schema);
        }
        ArrayList<Surrogate> keys = new ArrayList<Surrogate>(schemaList.size());
        for (Schema schema : schemaList) {
            keys.add(schema.getSurrogate());
        }
        Schema finalResult = result.consolidate(this.getName(), this.getSurrogate(), keys);
        for (AttributeDefinition<?> ad : finalResult.getAttributeDefinitions()) {
            if (ad.isComplete()) continue;
            throw T2DBMsg.exception("D30111", this.getName(), ad.getNumber());
        }
        for (SeriesDefinition sd : finalResult.getSeriesDefinitions()) {
            for (AttributeDefinition<?> ad : sd.getAttributeDefinitions()) {
                if (ad.isComplete()) continue;
                throw T2DBMsg.exception("D30113", this.getName(), ad.getNumber(), sd.getNumber());
            }
            if (sd.isComplete()) continue;
            throw T2DBMsg.exception("D30112", this.getName(), sd.getNumber());
        }
        return finalResult;
    }

    private List<UpdatableSchema> getSchemaList() throws T2DBException {
        LinkedHashSet<String> cycleDetector = new LinkedHashSet<String>();
        ArrayList<UpdatableSchema> list = new ArrayList<UpdatableSchema>();
        for (UpdatableSchema schema = this; schema != null; schema = schema.getBase()) {
            if (cycleDetector.contains(schema.getName())) {
                throw T2DBMsg.exception("D30110", this.toString(), this.format(" -> ", cycleDetector, schema.toString()));
            }
            cycleDetector.add(schema.getName());
            list.add(schema);
        }
        return list;
    }

    private String format(String sep, Set<String> list, String last) {
        StringBuffer b = new StringBuffer();
        for (String el : list) {
            b.append(el);
            b.append(sep);
        }
        b.append(last);
        return b.toString();
    }

    public int traverse(boolean resolve, UpdatableSchemaVisitor visitor) throws T2DBException {
        UpdatableSchemaImpl updated = resolve ? (SchemaImpl)this.resolve() : this;
        SchemaImpl original = null;
        if (!this.inConstruction()) {
            original = resolve ? (SchemaImpl)this.getDatabase().getSchema(this.getSurrogate()) : (SchemaImpl)((Object)this.getDatabase().getUpdatableSchema(this.getSurrogate()));
        }
        int total = 0;
        Map<Integer, AttributeDefinition<?>> editedADs = updated.getAttributeDefinitionsObject().getMap();
        HashMap<Integer, AttributeDefinition<?>> origADs = original == null ? new HashMap() : original.getAttributeDefinitionsObject().getMap();
        total += this.visit(visitor, null, editedADs, origADs);
        Map<Integer, SeriesDefinition> editedSDs = updated.getSeriesDefinitionsObject().getMap();
        Map<Object, Object> originalSDs = original == null ? new HashMap() : original.getSeriesDefinitionsObject().getMap();
        HashSet<Object> deletedSDs = new HashSet<Object>(originalSDs.keySet());
        deletedSDs.removeAll(editedSDs.keySet());
        for (Integer n : deletedSDs) {
            visitor.visit(this, null, (SeriesDefinition)originalSDs.get(n));
            ++total;
        }
        for (SeriesDefinition seriesDefinition : editedSDs.values()) {
            SeriesDefinition origSD;
            if (!this.equalIgnoringAttributes(seriesDefinition, origSD = (SeriesDefinition)originalSDs.get(seriesDefinition.getNumber()))) {
                visitor.visit(this, seriesDefinition, origSD);
                ++total;
            }
            Map<Integer, AttributeDefinition<?>> editedSADs = ((SeriesDefinitionImpl)seriesDefinition).getAttributeDefinitionsObject().getMap();
            HashMap<Integer, AttributeDefinition<?>> origSADs = origSD == null ? new HashMap() : ((SeriesDefinitionImpl)origSD).getAttributeDefinitionsObject().getMap();
            total += this.visit(visitor, seriesDefinition, editedSADs, origSADs);
        }
        return total;
    }

    protected int visit(UpdatableSchemaVisitor visitor, SeriesDefinition seriesDef, Map<Integer, AttributeDefinition<?>> editedADs, Map<Integer, AttributeDefinition<?>> origADs) throws T2DBException {
        int total = 0;
        if (origADs.size() == 0) {
            for (AttributeDefinition<?> editedAD : editedADs.values()) {
                visitor.visit(this, seriesDef, editedAD, null);
                ++total;
            }
        } else {
            HashSet<Integer> deletedADs = new HashSet<Integer>(origADs.keySet());
            deletedADs.removeAll(editedADs.keySet());
            for (Integer n : deletedADs) {
                visitor.visit(this, seriesDef, null, origADs.get(n));
                ++total;
            }
            for (AttributeDefinition attributeDefinition : editedADs.values()) {
                AttributeDefinition<?> origAD;
                if (attributeDefinition.equals(origAD = origADs.get(attributeDefinition.getNumber()))) continue;
                visitor.visit(this, seriesDef, attributeDefinition, origAD);
                ++total;
            }
        }
        return total;
    }

    private boolean equalIgnoringAttributes(SeriesDefinition def, SeriesDefinition old) {
        return old != null && def.isErasing() == old.isErasing() && def.getDescription() == old.getDescription();
    }
}

