/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.ChronicleImpl;
import ch.agent.crnickl.impl.SurrogateImpl;
import ch.agent.crnickl.impl.UpdatableSeriesImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class UpdatableChronicleImpl
extends ChronicleImpl
implements UpdatableChronicle {
    private boolean delete;
    private Schema schema;
    private Chronicle collection;
    private String name;
    private String description;
    private Map<String, Attribute<?>> attributesUpdate;
    private Map<String, UpdatableSeries<?>> seriesUpdate = new LinkedHashMap();

    public UpdatableChronicleImpl(Surrogate surrogate) {
        super(surrogate);
    }

    @Override
    public UpdatableChronicle edit() {
        return this;
    }

    @Override
    public String getName(boolean full) throws T2DBException {
        String result = null;
        if (full) {
            result = super.getName(full);
        } else if (this.name != null) {
            result = this.name;
        } else if (!this.getSurrogate().inConstruction()) {
            result = super.getName(full);
        }
        return result;
    }

    @Override
    public String getDescription(boolean full) throws T2DBException {
        String result = null;
        if (full) {
            result = super.getDescription(full);
        } else if (this.description != null) {
            result = this.description;
        } else if (!this.getSurrogate().inConstruction()) {
            result = super.getDescription(full);
        }
        return result;
    }

    @Override
    public Attribute<?> getAttribute(String attrName, boolean mustExist) throws T2DBException {
        Attribute<?> result;
        Attribute<?> attribute = result = this.attributesUpdate == null ? null : this.attributesUpdate.get(attrName);
        if (result == null) {
            if (this.getSurrogate().inConstruction()) {
                Schema esch = this.getSchema(true);
                if (esch == null) {
                    if (mustExist) {
                        throw T2DBMsg.exception("D40114", this.getName(true));
                    }
                } else {
                    AttributeDefinition<?> def = this.getSchema(true).getAttributeDefinition(attrName, mustExist);
                    if (def != null) {
                        result = def.getAttribute();
                    }
                }
            } else {
                result = super.getAttribute(attrName, mustExist);
            }
        }
        return result;
    }

    @Override
    public Chronicle getCollection() throws T2DBException {
        Chronicle result = null;
        if (this.collection != null) {
            result = this.collection;
        } else if (!this.getSurrogate().inConstruction()) {
            result = super.getCollection();
        }
        return result;
    }

    @Override
    public Schema getSchema(boolean effective) throws T2DBException {
        Schema result = null;
        if (this.schema != null) {
            result = this.schema;
        } else if (this.getSurrogate().inConstruction()) {
            if (effective && this.collection != null) {
                result = this.collection.getSchema(effective);
            }
        } else {
            result = super.getSchema(effective);
        }
        return result;
    }

    @Override
    public void setName(String name) throws T2DBException {
        if (this.delete) {
            throw T2DBMsg.exception("D40109", this.getName(true));
        }
        this.getDatabase().getNamingPolicy().checkSimpleName(name, false);
        this.name = name;
    }

    @Override
    public void setDescription(String description) throws T2DBException {
        if (this.delete) {
            throw T2DBMsg.exception("D40109", this.getName(true));
        }
        this.description = description;
    }

    @Override
    public void setAttribute(Attribute<?> value) throws T2DBException {
        if (this.delete) {
            throw T2DBMsg.exception("D40109", this.getName(true));
        }
        if (this.attributesUpdate == null) {
            this.attributesUpdate = new HashMap();
        }
        this.attributesUpdate.put(value.getProperty().getName(), value);
    }

    @Override
    public void setCollection(Chronicle collection) throws T2DBException {
        if (this.delete) {
            throw T2DBMsg.exception("D40109", this.getName(true));
        }
        this.collection = collection;
    }

    @Override
    public void setSchema(Schema schema) throws T2DBException {
        if (this.delete) {
            throw T2DBMsg.exception("D40109", this.getName(true));
        }
        this.schema = schema;
    }

    @Override
    public <T> Series<T> getSeries(String seriesName) throws T2DBException {
        UpdatableSeries<?> u;
        Series<Object> s = null;
        if (this.seriesUpdate != null && (u = this.seriesUpdate.get(seriesName)) != null) {
            s = u;
        }
        if (s == null && !this.getSurrogate().inConstruction()) {
            s = super.getSeries(seriesName);
        }
        return s;
    }

    @Override
    public <T> UpdatableSeries<T> createSeries(String seriesName) throws T2DBException {
        Series<T> s = this.getSeries(seriesName);
        if (s != null) {
            throw T2DBMsg.exception("D50108", s.getName(true));
        }
        SeriesDefinition schema = this.getSchema(true).getSeriesDefinition(seriesName, true);
        UpdatableSeriesImpl u = new UpdatableSeriesImpl(this, seriesName, schema.getNumber(), new SurrogateImpl(this.getDatabase(), DBObjectType.SERIES, null));
        this.seriesUpdate.put(seriesName, u);
        return u;
    }

    @Override
    public <T> UpdatableSeries<T> updateSeries(String seriesName) throws T2DBException {
        UpdatableSeries<T> u;
        Series<T> s = this.getSeries(seriesName);
        UpdatableSeries<T> updatableSeries = u = s == null ? null : s.edit();
        if (u != null) {
            this.seriesUpdate.put(seriesName, u);
        }
        return u;
    }

    @Override
    public UpdatableChronicle createChronicle(String orig, boolean tweakable, String description, Collection<Attribute<?>> attributes, Schema schema) throws T2DBException {
        if (this.getSurrogate().inConstruction() && !this.isTopChronicle()) {
            throw T2DBMsg.exception("D40108", this.getName(true));
        }
        if (schema instanceof UpdatableSchema) {
            throw T2DBMsg.exception("D40104", this.getName(true), schema.getName());
        }
        String name = this.getDatabase().getNamingPolicy().checkSimpleName(orig, tweakable);
        Chronicle current = this.getChronicle(name, false);
        if (current != null) {
            if (tweakable) {
                if ((name = this.findNextAvailableName(name, 2, 9)) == null) {
                    throw T2DBMsg.exception("D40127", name, this.getName(true));
                }
            } else {
                throw T2DBMsg.exception("D40126", name, this.getName(true));
            }
        }
        UpdatableChronicleImpl ent = new UpdatableChronicleImpl(new SurrogateImpl(this.getDatabase(), DBObjectType.CHRONICLE, null));
        ent.collection = this;
        ent.name = name;
        ent.description = description;
        ent.schema = schema;
        if (attributes != null) {
            for (Attribute<?> attr : attributes) {
                ent.setAttribute(attr);
            }
        }
        return ent;
    }

    private String findNextAvailableName(String orig, int start, int end) throws T2DBException {
        String name = null;
        for (int i = start; i <= end && this.getChronicle(name = orig + i, false) != null; ++i) {
            name = null;
        }
        return name;
    }

    @Override
    public void destroy() throws T2DBException {
        if (this.seriesUpdate.size() != 0 || this.name != null || this.description != null || this.collection != null || this.schema != null || this.attributesUpdate != null) {
            throw T2DBMsg.exception("D40107", this.getName(true));
        }
        this.delete = true;
    }

    @Override
    public void applyUpdates() throws T2DBException {
        boolean done = false;
        this.getDatabase().getCache().clear(this);
        if (this.delete) {
            this.getDatabase().deleteChronicle(this);
            this.delete = false;
            done = true;
        } else {
            if (this.getSurrogate().inConstruction()) {
                this.getDatabase().create(this);
                this.name = null;
                this.description = null;
                this.collection = null;
                this.schema = null;
                done = true;
            } else if (this.updateIfModified()) {
                this.name = null;
                this.description = null;
                this.collection = null;
                this.schema = null;
                done = true;
            }
            if (this.attributesUpdate != null) {
                this.updateAttributes(this.attributesUpdate.values());
                done = true;
                this.attributesUpdate = null;
            }
            if (this.seriesUpdate.size() > 0) {
                for (UpdatableSeries<?> s : this.seriesUpdate.values()) {
                    s.applyUpdates();
                }
                done = true;
                this.seriesUpdate.clear();
            }
        }
        if (done) {
            this.update();
        }
    }

    @Override
    protected void update() {
        super.update();
    }

    public void updateAttributes(Collection<Attribute<?>> attributes) throws T2DBException {
        Schema schema = this.getSchema(true);
        if (schema == null) {
            throw T2DBMsg.exception("D30115", new Object[0]);
        }
        for (Attribute<?> attribute : attributes) {
            Property<?> property = attribute.getProperty();
            ValueType<?> type = property.getValueType();
            AttributeDefinition<?> def = schema.getAttributeDefinition(property.getName(), true);
            if (def == null) {
                throw T2DBMsg.exception("D30114", property.getName());
            }
            String value = type.toString(attribute.get());
            if (value == null || value.length() == 0) {
                this.getDatabase().deleteAttributeValue(this, def);
                continue;
            }
            String description = attribute.getDescription(false);
            if (description == null) {
                description = "";
            } else if (type.isRestricted() && description.equals(type.getValueDescriptions().get(attribute.get()))) {
                description = "";
            }
            this.getDatabase().update(this, def, value, description);
        }
    }

    private boolean updateIfModified() throws T2DBException {
        boolean anything = false;
        String name = this.getName(false);
        String description = this.getDescription(false);
        Chronicle current = this.getDatabase().getChronicle(this);
        Chronicle collection = this.getCollection();
        Schema schema = this.getSchema(false);
        if (!this.equal(name, current.getName(false))) {
            this.getDatabase().getNamingPolicy().checkSimpleName(name, false);
            anything = true;
        }
        if (!this.equal(description, current.getDescription(false))) {
            anything = true;
        }
        if (!this.equal(collection, current.getCollection())) {
            throw T2DBMsg.exception("D40110", this.getName(true));
        }
        if (!this.equal(schema, current.getSchema(false))) {
            throw T2DBMsg.exception("D40111", this.getName(true));
        }
        if (anything) {
            this.getDatabase().update(this);
        }
        return anything;
    }

    private boolean equal(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }
}

