/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.DBObjectImpl;
import ch.agent.crnickl.impl.UpdatableSeriesImpl;
import ch.agent.t2.T2Exception;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.timeseries.Observation;
import ch.agent.t2.timeseries.TimeAddressable;
import ch.agent.t2.timeseries.TimeSeriesFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SeriesImpl<T>
extends DBObjectImpl
implements Series<T> {
    private Chronicle chronicle;
    private String name;
    private int number;
    private SeriesDefinition schema;
    private TimeDomain timeDomain;
    private ValueType<T> type;

    public SeriesImpl(Chronicle chronicle, String name, int number, Surrogate surrogate) {
        super(surrogate);
        this.chronicle = chronicle;
        this.name = name;
        this.number = number;
    }

    protected void update() {
    }

    @Override
    public UpdatableSeries<T> edit() {
        return new UpdatableSeriesImpl(this.chronicle, this.name, this.number, this.getSurrogate());
    }

    @Override
    public Chronicle getChronicle() {
        return this.chronicle;
    }

    @Override
    public SeriesDefinition getDefinition() throws T2DBException {
        if (this.schema == null) {
            this.schema = this.getChronicle().getSchema(true).getSeriesDefinition(this.number, true);
        }
        return this.schema;
    }

    @Override
    public String getName(boolean full) throws T2DBException {
        if (full) {
            return this.getDatabase().getNamingPolicy().fullName(this.getNames());
        }
        if (this.name == null) {
            this.name = this.getDefinition().getName();
        }
        return this.name;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public List<String> getNames() throws T2DBException {
        List<String> names = this.getChronicle().getNames();
        names.add(this.getName(false));
        return names;
    }

    @Override
    public ValueType<T> getValueType() throws T2DBException {
        if (this.type == null) {
            this.type = this.getDefinition().getValueType();
        }
        return this.type;
    }

    @Override
    public TimeDomain getTimeDomain() throws T2DBException {
        if (this.timeDomain == null) {
            this.timeDomain = this.getDefinition().getTimeDomain();
        }
        return this.timeDomain;
    }

    @Override
    public boolean isSparse() throws T2DBException {
        return this.getDefinition().isSparse();
    }

    @Override
    public String getDescription(boolean full) throws T2DBException {
        if (full) {
            return this.getDatabase().getNamingPolicy().fullDescription(this.getDescriptions());
        }
        return this.getDefinition().getDescription();
    }

    @Override
    public List<String> getDescriptions() throws T2DBException {
        List<String> descriptions = this.getChronicle().getDescriptions();
        descriptions.add(this.getDescription(false));
        return descriptions;
    }

    @Override
    public Attribute<?> getAttribute(String name, boolean mustExist) throws T2DBException {
        AttributeDefinition<?> def = this.getDefinition().getAttributeDefinition(name, false);
        if (def != null) {
            return def.getAttribute();
        }
        return this.getChronicle().getAttribute(name, mustExist);
    }

    @Override
    public Collection<Attribute<?>> getAttributes() throws T2DBException {
        ArrayList result = new ArrayList();
        SeriesDefinition schema = this.getDefinition();
        if (schema != null) {
            Collection<AttributeDefinition<?>> defs = schema.getAttributeDefinitions();
            for (AttributeDefinition<?> def : defs) {
                if (!def.isComplete()) {
                    throw T2DBMsg.exception("D50115", this.getName(true), def.getNumber());
                }
                result.add(this.getAttribute(def.getName(), true));
            }
        }
        return result;
    }

    @Override
    public TimeAddressable<T> getValues(Range range) throws T2Exception, T2DBException {
        return this.getValues(range, false);
    }

    @Override
    public TimeAddressable<T> getValues(Range range, boolean forceSparse) throws T2Exception, T2DBException {
        if (range != null) {
            range.getTimeDomain().requireEquality(this.getTimeDomain());
        }
        if (!forceSparse) {
            forceSparse = this.isSparse();
        }
        TimeAddressable ts = TimeSeriesFactory.make((TimeDomain)this.getTimeDomain(), this.getValueType().getType(), (boolean)forceSparse);
        if (!this.getSurrogate().inConstruction()) {
            this.getDatabase().getValues(this, range, ts);
        }
        return ts;
    }

    private void checkTime(TimeIndex time) throws T2Exception, T2DBException {
        if (time == null) {
            throw new IllegalArgumentException("time null");
        }
        time.getTimeDomain().requireEquality(this.getTimeDomain());
    }

    @Override
    public Observation<T> getLastObservation(TimeIndex time) throws T2Exception, T2DBException {
        if (time != null) {
            this.checkTime(time);
        }
        if (this.getSurrogate().inConstruction()) {
            return null;
        }
        return this.getDatabase().getLastObservation(this, time);
    }

    @Override
    public Observation<T> getFirstObservation(TimeIndex time) throws T2Exception, T2DBException {
        if (time != null) {
            this.checkTime(time);
        }
        if (this.getSurrogate().inConstruction()) {
            return null;
        }
        return this.getDatabase().getFirstObservation(this, time);
    }

    @Override
    public T getValue(TimeIndex time) throws T2Exception, T2DBException {
        this.checkTime(time);
        return (T)this.getValues(new Range(time, time)).get(time);
    }

    @Override
    public Range getRange() throws T2Exception, T2DBException {
        return this.getDatabase().getRange(this);
    }

    @Override
    public <S> Series<S> typeCheck(Class<S> type) throws T2DBException {
        try {
            if (type.isAssignableFrom(this.getValueType().getType())) {
                return this;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw T2DBMsg.exception("D50101", this.getName(true), type.getName(), this.getValueType().getType().getName());
    }

    public String toString() {
        try {
            return this.getName(true);
        }
        catch (T2DBException e) {
            return this.getSurrogate().toString();
        }
    }
}

