/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.SchemaComponent;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.SchemaComponentContainer;
import ch.agent.crnickl.impl.SchemaComponentImpl;
import ch.agent.crnickl.impl.SchemaComponents;
import ch.agent.t2.time.TimeDomain;
import java.util.ArrayList;
import java.util.Collection;

public class SeriesDefinitionImpl
extends SchemaComponentImpl
implements SeriesDefinition {
    private boolean erasing;
    private int number;
    private String description;
    private SchemaComponents<AttributeDefinition<?>> attributes;

    public SeriesDefinitionImpl(int number, String description, Collection<AttributeDefinition<?>> attributeDefs) throws T2DBException {
        if (number < 1) {
            throw T2DBMsg.exception("D30117", new Object[0]);
        }
        this.number = number;
        this.description = description;
        this.attributes = new SchemaComponents(attributeDefs);
    }

    @Override
    public void setContainer(SchemaComponentContainer container) {
        this.attributes.setContainer(container);
    }

    @Override
    public boolean isComplete() {
        return !this.isErasing() && this.getName() != null && this.getValueType() != null && this.getTimeDomain() != null && this.attributes.isComplete();
    }

    @Override
    public boolean isErasing() {
        if (this.erasing) {
            this.erasing = this.description == null && this.attributes.getMap().size() == 0;
        }
        return this.erasing;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public Collection<AttributeDefinition<?>> getAttributeDefinitions() {
        return this.attributes.getComponents();
    }

    @Override
    public Collection<AttributeDefinition<?>> getCustomAttributeDefinitions() {
        Collection<AttributeDefinition<?>> defs = this.getAttributeDefinitions();
        ArrayList customDefs = new ArrayList(defs.size() - 3);
        for (AttributeDefinition<?> def : defs) {
            if (def.getNumber() <= 9) continue;
            customDefs.add(def);
        }
        return customDefs;
    }

    @Override
    public AttributeDefinition<?> getAttributeDefinition(String name, boolean mustExist) throws T2DBException {
        AttributeDefinition<?> def = this.attributes.getComponent(name);
        if (def == null && mustExist) {
            throw T2DBMsg.exception("D30119", name, this.getNumber());
        }
        return def;
    }

    @Override
    public AttributeDefinition<?> getAttributeDefinition(int attrNr, boolean mustExist) throws T2DBException {
        AttributeDefinition<?> def = this.attributes.getComponent(attrNr);
        if (def == null && mustExist) {
            throw T2DBMsg.exception("D30120", attrNr, this.getNumber());
        }
        return def;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        AttributeDefinition<?> def = this.attributes.getComponent(1);
        return def == null ? null : (String)def.getValue();
    }

    @Override
    public TimeDomain getTimeDomain() {
        AttributeDefinition<?> def = this.attributes.getComponent(3);
        return def == null ? null : (TimeDomain)def.getValue();
    }

    @Override
    public ValueType<?> getValueType() {
        AttributeDefinition<?> def = this.attributes.getComponent(2);
        return def == null ? null : (ValueType)def.getValue();
    }

    @Override
    public boolean isSparse() {
        AttributeDefinition<?> def = this.attributes.getComponent(4);
        return def == null ? false : (Boolean)def.getValue();
    }

    public void setErasing(boolean erasing) {
        this.checkEdit();
        this.doSetErasing(erasing);
    }

    private void doSetErasing(boolean erasing) {
        this.erasing = erasing;
        if (erasing) {
            this.description = null;
            try {
                this.attributes = new SchemaComponents(null);
            }
            catch (T2DBException t2DBException) {
                // empty catch block
            }
        }
    }

    public void setDescription(String description) {
        this.checkEdit();
        this.description = description;
    }

    protected SchemaComponents<AttributeDefinition<?>> getAttributeDefinitionsObject() {
        return this.attributes;
    }

    @Override
    public void edit(SchemaComponent component) throws T2DBException {
        if (!(component instanceof SeriesDefinition)) {
            throw new IllegalArgumentException(component == null ? null : component.getClass().getName());
        }
        SeriesDefinition arg = (SeriesDefinition)component;
        if (arg.isErasing()) {
            this.doSetErasing(true);
        } else {
            if (arg.getDescription() != null) {
                this.setDescription(arg.getDescription());
            }
            this.attributes.consolidate();
        }
    }

    @Override
    public SchemaComponent copy() {
        try {
            SeriesDefinitionImpl sd = null;
            if (this.isErasing()) {
                sd = new SeriesDefinitionImpl(this.number, null, null);
                sd.setErasing(true);
            } else {
                ArrayList components = new ArrayList();
                for (AttributeDefinition<?> compo : this.attributes.getComponents()) {
                    components.add((AttributeDefinition)compo.copy());
                }
                sd = new SeriesDefinitionImpl(this.number, this.description, components);
            }
            return sd;
        }
        catch (T2DBException e) {
            throw new RuntimeException("bug", (Throwable)((Object)e));
        }
    }

    @Override
    public int compareTo(SeriesDefinition o) {
        if (this.getNumber() > o.getNumber()) {
            return 1;
        }
        if (this.getNumber() < o.getNumber()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        String name = this.getName();
        return name == null ? "" + this.number : name;
    }
}

