/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.impl.UpdatableSchemaImpl;
import ch.agent.crnickl.impl.UpdatableSchemaVisitor;
import java.util.Collection;

public class SchemaUpdatePolicyImpl
implements SchemaUpdatePolicy {
    private DatabaseBackend database;
    private UpdatableSchemaVisitor visitor;

    public SchemaUpdatePolicyImpl(DatabaseBackend database) {
        this.database = database;
        this.visitor = new Visitor(this);
    }

    @Override
    public void willDelete(UpdatableSchema schema) throws T2DBException {
        Collection<UpdatableSchema> schemas = this.database.getUpdatableSchemas("*");
        int count = 0;
        for (UpdatableSchema s : schemas) {
            if (!schema.equals(s.getBase())) continue;
            ++count;
        }
        if (count > 0) {
            throw T2DBMsg.exception("D30140", schema.getName(), count);
        }
        Surrogate entity = this.database.findChronicle(schema);
        if (entity != null) {
            throw T2DBMsg.exception("D30141", schema.getName(), this.chronicleName(entity));
        }
    }

    @Override
    public void willUpdate(UpdatableSchema schema) throws T2DBException {
        try {
            ((UpdatableSchemaImpl)schema).traverse(true, this.visitor);
        }
        catch (T2DBException e) {
            throw T2DBMsg.exception((Throwable)((Object)e), "D30105", schema.getName());
        }
    }

    private void willDeleteOrErase(UpdatableSchema schema, SeriesDefinition ss) throws T2DBException {
        Surrogate entity = this.database.findChronicle(ss, (Schema)schema);
        if (entity != null) {
            throw T2DBMsg.exception("D30150", ss.getNumber(), schema.getName(), this.chronicleName(entity));
        }
    }

    private void willDeleteOrErase(UpdatableSchema schema, SeriesDefinition ss, AttributeDefinition<?> def) throws T2DBException {
        if (ss != null) {
            if (this.database.isBuiltIn(def)) {
                throw T2DBMsg.exception("D30148", def.getNumber(), ss.getNumber(), schema.getName());
            }
        } else {
            Surrogate entity = this.database.findChronicle(def.getProperty(), (Schema)schema);
            if (entity != null) {
                throw T2DBMsg.exception("D30146", def.getNumber(), schema.getName(), this.chronicleName(entity));
            }
        }
    }

    private void willUpdate(UpdatableSchema schema, SeriesDefinition ss, AttributeDefinition<?> def) throws T2DBException {
        if (ss != null && this.database.isBuiltIn(def) && def.getNumber() != 1) {
            throw T2DBMsg.exception("D30149", def.getNumber(), ss.getNumber(), schema.getName());
        }
    }

    @Override
    public <T> void willDelete(Property<T> property) throws T2DBException {
    }

    @Override
    public <T> void willDelete(ValueType<T> valueType) throws T2DBException {
    }

    @Override
    public <T> void willDelete(ValueType<T> valueType, T value) throws T2DBException {
    }

    private String chronicleName(Surrogate entity) {
        try {
            Chronicle c = entity.getDatabase().getChronicle(entity);
            return c.getName(true);
        }
        catch (T2DBException e) {
            return entity.toString();
        }
    }

    private static class Visitor
    implements UpdatableSchemaVisitor {
        private SchemaUpdatePolicyImpl policy;

        private Visitor(SchemaUpdatePolicyImpl policy) {
            this.policy = policy;
        }

        @Override
        public void visit(UpdatableSchema schema, SeriesDefinition def, SeriesDefinition original) throws T2DBException {
            if (def == null) {
                if (!original.isErasing()) {
                    this.policy.willDeleteOrErase(schema, original);
                }
            } else if (def.isErasing() && (original == null || !original.isErasing())) {
                this.policy.willDeleteOrErase(schema, def);
            }
        }

        @Override
        public void visit(UpdatableSchema schema, SeriesDefinition seriesDef, AttributeDefinition<?> attrDef, AttributeDefinition<?> origAttrDef) throws T2DBException {
            if (attrDef == null) {
                if (!origAttrDef.isErasing()) {
                    this.policy.willDeleteOrErase(schema, seriesDef, origAttrDef);
                }
            } else if (attrDef.isErasing()) {
                Schema resolved = schema.resolve();
                AttributeDefinition<?> def = resolved.getAttributeDefinition(attrDef.getNumber(), false);
                if (def != null) {
                    this.policy.willDeleteOrErase(schema, seriesDef, def);
                }
            } else if (origAttrDef != null) {
                this.policy.willUpdate(schema, seriesDef, attrDef);
            }
        }
    }
}

