/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableProperty;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.DBObjectImpl;
import ch.agent.crnickl.impl.UpdatablePropertyImpl;
import java.util.List;

public class PropertyImpl<T>
extends DBObjectImpl
implements Property<T> {
    private String name;
    private ValueType<T> valueType;
    private boolean indexed;

    public PropertyImpl(String name, ValueType<T> valueType, boolean indexed, Surrogate surrogate) {
        super(surrogate);
        this.name = name;
        this.valueType = valueType;
        this.indexed = indexed;
    }

    protected void update() {
        this.name = this.getName();
    }

    @Override
    public ValueType<T> getValueType() {
        return this.valueType;
    }

    @Override
    public UpdatableProperty<T> edit() {
        return new UpdatablePropertyImpl<T>(this.name, this.valueType, this.indexed, this.getSurrogate());
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T scan(String value) throws T2DBException {
        try {
            return this.getValueType().scan(value);
        }
        catch (T2DBException e) {
            throw T2DBMsg.exception((Throwable)((Object)e), "D20110", value, this.name);
        }
    }

    @Override
    public void check(T value) throws T2DBException {
        try {
            this.getValueType().check(value);
        }
        catch (T2DBException e) {
            throw T2DBMsg.exception((Throwable)((Object)e), "D20110", value, this.name);
        }
    }

    @Override
    public List<Chronicle> getChronicles(T value, int maxSize) throws T2DBException {
        return this.getDatabase().getChroniclesByAttributeValue(this, value, maxSize);
    }

    @Override
    public <S> Property<S> typeCheck(Class<S> type) throws T2DBException {
        try {
            if (type.isAssignableFrom(this.getValueType().getType())) {
                return this;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw T2DBMsg.exception("D10101", this.getName(), type.getName(), this.getValueType().getType().getName());
    }

    public String toString() {
        return this.getName();
    }
}

