/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectId;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.impl.DBObjectImpl;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.DatabaseMethods;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.PermissionChecker;
import ch.agent.crnickl.impl.SurrogateImpl;

public class DatabaseMethodsImpl
implements DatabaseMethods,
PermissionChecker {
    public void checkIntegrity(DBObject object, Surrogate s, Surrogate referrer) throws T2DBException {
        if (object == null) {
            if (referrer == null) {
                throw T2DBMsg.exception("D02106", s.toString());
            }
            throw T2DBMsg.exception("D02107", s.toString(), referrer.toString());
        }
    }

    @Override
    public Surrogate makeSurrogate(Database db, DBObjectType dot, DBObjectId id) {
        return new SurrogateImpl((DatabaseBackend)db, dot, id);
    }

    @Override
    public Surrogate makeSurrogate(DBObject dBObject, DBObjectId id) {
        Surrogate s = dBObject.getSurrogate();
        return this.makeSurrogate(s.getDatabase(), s.getDBObjectType(), id);
    }

    @Override
    public boolean check(Permission permission, DBObject dBObject, boolean permissionRequired) throws T2DBException {
        return ((DBObjectImpl)dBObject).getDatabase().check(permission, dBObject, permissionRequired);
    }

    @Override
    public void check(Permission permission, DBObject dBObject) throws T2DBException {
        ((DBObjectImpl)dBObject).getDatabase().check(permission, dBObject);
    }

    @Override
    public boolean check(Permission permission, Surrogate surrogate, boolean permissionRequired) throws T2DBException {
        return ((DatabaseBackend)surrogate.getDatabase()).check(permission, surrogate, permissionRequired);
    }

    @Override
    public void check(Permission permission, Surrogate surrogate) throws T2DBException {
        ((DatabaseBackend)surrogate.getDatabase()).check(permission, surrogate);
    }
}

