/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.core.KeyedException;
import ch.agent.core.KeyedMessage;
import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.DatabaseConfiguration;
import ch.agent.crnickl.api.MessageListener;
import ch.agent.crnickl.api.NamingPolicy;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableProperty;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.UpdateEvent;
import ch.agent.crnickl.api.UpdateEventOperation;
import ch.agent.crnickl.api.UpdateEventPublisher;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.ChronicleImpl;
import ch.agent.crnickl.impl.ChronicleUpdatePolicy;
import ch.agent.crnickl.impl.ChronicleUpdatePolicyExtension;
import ch.agent.crnickl.impl.ChronicleUpdatePolicyImpl;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.DatabaseCache;
import ch.agent.crnickl.impl.DatabaseCacheImpl;
import ch.agent.crnickl.impl.NameSpace;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.PermissionChecker;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.impl.SchemaUpdatePolicyImpl;
import ch.agent.crnickl.impl.SurrogateImpl;
import ch.agent.crnickl.impl.UpdatablePropertyImpl;
import ch.agent.crnickl.impl.UpdatableSchemaImpl;
import ch.agent.crnickl.impl.UpdatableValueTypeImpl;
import ch.agent.crnickl.impl.UpdateEventImpl;
import ch.agent.crnickl.impl.UpdateEventPublisherImpl;
import ch.agent.crnickl.impl.ValueAccessMethods;
import ch.agent.crnickl.impl.ValueTypeImpl;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.timeseries.Observation;
import ch.agent.t2.timeseries.TimeAddressable;
import ch.agent.t2.timeseries.TimeSeriesFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public abstract class DatabaseBackendImpl
implements DatabaseBackend {
    private int hashCode = -1;
    private DatabaseCache cache;
    private UpdateEventPublisher eventHub;
    private NameSpace topChronicle;
    private MessageListener messageListener;
    private PermissionChecker permissionChecker;
    private SchemaUpdatePolicy sup;
    private ChronicleUpdatePolicyExtension eupx;
    private ChronicleUpdatePolicy eup;
    private NamingPolicy nm;
    private boolean strictNameSpaceMode;
    private Map<String, ValueAccessMethods<?>> am;

    public DatabaseBackendImpl(String name) {
        this.topChronicle = new NameSpace(name, String.format("%s (%s)", this.getClass().getSimpleName(), name), new SurrogateImpl(this, DBObjectType.CHRONICLE, null));
        this.setMessageListener(null);
        this.nm = new NamingPolicy();
        this.am = new HashMap();
    }

    private MessageListener getDefaultMessageListener() {
        return new MessageListener(){

            @Override
            public void setFilterLevel(Level level) {
                if (!level.equals(Level.OFF)) {
                    throw new UnsupportedOperationException("the default message listener ignores all messages");
                }
            }

            @Override
            public boolean isListened(Level level) {
                return false;
            }

            @Override
            public void log(Level level, KeyedMessage msg) {
            }

            @Override
            public void log(Level level, String text) {
            }

            @Override
            public void log(Exception e) {
            }
        };
    }

    private PermissionChecker getDefaultPermissionChecker() {
        return new PermissionChecker(){

            @Override
            public void check(Permission permission, Surrogate surrogate) throws T2DBException {
            }

            @Override
            public boolean check(Permission permission, Surrogate surrogate, boolean permissionRequired) throws T2DBException {
                return true;
            }

            @Override
            public void check(Permission permission, DBObject dBObject) throws T2DBException {
            }

            @Override
            public boolean check(Permission permission, DBObject dBObject, boolean permissionRequired) throws T2DBException {
                return true;
            }
        };
    }

    @Override
    public <T> ValueAccessMethods<T> getAccessMethods(ValueType<T> valueType) {
        ValueAccessMethods<?> accessMethods = this.am.get(valueType.getExternalRepresentation());
        return accessMethods;
    }

    @Override
    public <T> void setAccessMethods(String valueTypeExternalRepresentation, ValueAccessMethods<T> accessMethods) {
        this.am.put(valueTypeExternalRepresentation, accessMethods);
    }

    @Override
    public boolean isStrictNameSpaceMode() {
        return this.strictNameSpaceMode;
    }

    @Override
    public void setStrictNameSpaceMode(boolean strictNameSpaceMode) {
        if (strictNameSpaceMode != this.strictNameSpaceMode) {
            this.getCache().clear();
        }
        this.strictNameSpaceMode = strictNameSpaceMode;
    }

    @Override
    public Surrogate makeSurrogate(String string) throws T2DBException {
        return SurrogateImpl.makeSurrogate(this, string);
    }

    protected void checkSurrogate(Surrogate surrogate, DBObjectType required) throws T2DBException {
        if (surrogate.inConstruction() || !surrogate.getDBObjectType().equals((Object)required)) {
            throw T2DBMsg.exception("D02102", surrogate.getDBObjectType().name(), required.name());
        }
        if (!surrogate.getDBObjectType().equals((Object)required) && surrogate.getDatabase() != this) {
            throw T2DBMsg.exception("D02103", surrogate.getDatabase().getTopChronicle().getName(true), this.getTopChronicle().getName(true));
        }
    }

    protected boolean isChronicleUpdatePolicyExtensionMandatory() {
        return false;
    }

    protected boolean isChronicleUpdatePolicyExtensionAllowed() {
        return true;
    }

    @Override
    public void configure(DatabaseConfiguration configuration) throws T2DBException {
        Class<?> extClass;
        String parameter = configuration.getParameter("timeSeriesMaxGap", false);
        int maxGap = -1;
        try {
            if (parameter != null) {
                maxGap = new Integer(parameter);
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception(e, "D00108", "timeSeriesMaxGap", parameter);
        }
        if (maxGap > -1) {
            TimeSeriesFactory.getInstance().setMaxGap(maxGap);
        }
        int cacheSize = 0;
        float cacheLoadFactor = 0.0f;
        parameter = configuration.getParameter("dbCacheSize", false);
        try {
            cacheSize = parameter == null ? 96 : new Integer(parameter);
        }
        catch (Exception e) {
            throw T2DBMsg.exception(e, "D00108", "dbCacheSize", parameter);
        }
        parameter = configuration.getParameter("dbCacheLoadFactor", false);
        try {
            cacheLoadFactor = parameter == null ? 0.75f : new Float(parameter).floatValue();
        }
        catch (Exception e) {
            throw T2DBMsg.exception(e, "D00108", "dbCacheLoadFactor", parameter);
        }
        if (cacheSize > 0) {
            this.cache = cacheLoadFactor > 0.0f ? new DatabaseCacheImpl(this, cacheSize, cacheLoadFactor) : new DatabaseCacheImpl(this, cacheSize);
        }
        parameter = configuration.getParameter("dbStrictNameSpace", false);
        try {
            if (parameter == null) {
                this.setStrictNameSpaceMode(false);
            } else {
                this.setStrictNameSpaceMode(new Boolean(parameter));
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception(e, "D00108", "dbStrictNameSpace", parameter);
        }
        this.eupx = null;
        parameter = configuration.getParameter("dbChronicleUpdatePolicyExtension", false);
        try {
            if (parameter != null && parameter.length() > 0) {
                if (!this.isChronicleUpdatePolicyExtensionAllowed()) {
                    throw T2DBMsg.exception("D00107", new Object[0]);
                }
                extClass = Class.forName(parameter);
                this.eupx = (ChronicleUpdatePolicyExtension)extClass.newInstance();
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception(e, "D00108", "dbChronicleUpdatePolicyExtension", parameter);
        }
        if (this.eupx == null && this.isChronicleUpdatePolicyExtensionMandatory()) {
            throw T2DBMsg.exception("D00109", "dbChronicleUpdatePolicyExtension");
        }
        this.permissionChecker = null;
        parameter = configuration.getParameter("dbPermissionChecker", false);
        try {
            if (parameter != null && parameter.length() > 0) {
                extClass = Class.forName(parameter);
                this.permissionChecker = (PermissionChecker)extClass.newInstance();
            }
        }
        catch (Exception e) {
            throw T2DBMsg.exception(e, "D00108", "dbPermissionChecker", parameter);
        }
        this.validateNameSpace();
    }

    @Override
    public boolean isBuiltIn(AttributeDefinition<?> def) {
        return def.getNumber() <= 9;
    }

    @Override
    public DatabaseCache getCache() {
        return this.cache;
    }

    @Override
    public NamingPolicy getNamingPolicy() {
        return this.nm;
    }

    @Override
    public ChronicleUpdatePolicy getChronicleUpdatePolicy() {
        if (this.eup == null) {
            this.eup = new ChronicleUpdatePolicyImpl(this, this.eupx);
        }
        return this.eup;
    }

    @Override
    public SchemaUpdatePolicy getSchemaUpdatePolicy() {
        if (this.sup == null) {
            this.sup = new SchemaUpdatePolicyImpl(this);
        }
        return this.sup;
    }

    @Override
    public UpdateEventPublisher getUpdateEventPublisher() {
        if (this.eventHub == null) {
            this.eventHub = new UpdateEventPublisherImpl();
        }
        return this.eventHub;
    }

    protected void publish(UpdateEvent event) {
        this.getUpdateEventPublisher().publish(event, false);
    }

    @Override
    public void setMessageListener(MessageListener listener) {
        MessageListener messageListener = this.messageListener = listener == null ? this.getDefaultMessageListener() : listener;
        if (this.cache != null) {
            ((DatabaseCacheImpl)this.cache).setMessageListener(this.messageListener);
        }
    }

    @Override
    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    protected PermissionChecker getPermissionChecker() {
        if (this.permissionChecker == null) {
            this.permissionChecker = this.getDefaultPermissionChecker();
        }
        return this.permissionChecker;
    }

    @Override
    public boolean check(Permission permission, DBObject dBObject, boolean permissionRequired) throws T2DBException {
        return this.getPermissionChecker().check(permission, dBObject, permissionRequired);
    }

    @Override
    public void check(Permission permission, DBObject dBObject) throws T2DBException {
        this.getPermissionChecker().check(permission, dBObject);
    }

    @Override
    public boolean check(Permission permission, Surrogate surrogate, boolean permissionRequired) throws T2DBException {
        return this.getPermissionChecker().check(permission, surrogate, permissionRequired);
    }

    @Override
    public void check(Permission permission, Surrogate surrogate) throws T2DBException {
        this.getPermissionChecker().check(permission, surrogate);
    }

    private void validateNameSpace() throws T2DBException {
        String name = this.getTopChronicle().getName(true);
        name = this.getNamingPolicy().checkSimpleName(name, false);
        if (!this.isStrictNameSpaceMode()) {
            Collection<Chronicle> topMembers = null;
            try {
                topMembers = this.topChronicle.getMembers();
            }
            catch (T2DBException e) {
                topMembers = new ArrayList<Chronicle>();
            }
            for (Chronicle en : topMembers) {
                if (!en.getName(false).equals(name)) continue;
                throw T2DBMsg.exception("D00110", name);
            }
        }
    }

    @Override
    public Chronicle getTopChronicle() {
        if (this.topChronicle == null) {
            throw new IllegalStateException("bug: name space not available");
        }
        return this.topChronicle;
    }

    @Override
    public Chronicle getChronicle(String name, boolean mustExist) throws T2DBException {
        return this.getTopChronicle().findChronicle(name, mustExist);
    }

    @Override
    public <T> UpdatableSeries<T> getUpdatableSeries(String name, boolean mustExist) throws T2DBException {
        UpdatableChronicle updEnt;
        String[] es = this.getNamingPolicy().split(name);
        String chronicleName = es[0];
        String seriesName = es[1];
        UpdatableSeries series = null;
        if (chronicleName == null) {
            throw T2DBMsg.exception("D50116", name);
        }
        Chronicle ent = this.getChronicle(chronicleName, mustExist);
        if (ent != null && (series = (updEnt = ent.edit()).updateSeries(seriesName)) == null && mustExist) {
            series = updEnt.createSeries(seriesName);
        }
        return series;
    }

    @Override
    public <T> Series<T> getSeries(String name, boolean mustExist) throws T2DBException {
        Series series = null;
        String[] split = this.getNamingPolicy().split(name);
        if (split[0] == null) {
            throw T2DBMsg.exception("D50116", name);
        }
        Chronicle chronicle = this.getChronicle(split[0], mustExist);
        if (chronicle != null) {
            Series<T>[] s = chronicle.getSeries(new String[]{split[1]}, null, mustExist);
            series = s[0];
        }
        if (series == null && mustExist) {
            throw T2DBMsg.exception("D50106", name);
        }
        return series;
    }

    @Override
    public Chronicle getChronicle(Surrogate surrogate) throws T2DBException {
        this.checkSurrogate(surrogate, DBObjectType.CHRONICLE);
        ChronicleImpl chronicle = new ChronicleImpl(surrogate);
        chronicle.getName(false);
        return chronicle;
    }

    @Override
    public <T> Range getRange(Series<T> series) throws T2DBException {
        return ((ValueTypeImpl)series.getValueType()).getAccessMethods().getRange(series);
    }

    @Override
    public <T> long getValues(Series<T> series, Range range, TimeAddressable<T> ts) throws T2DBException {
        return ((ValueTypeImpl)series.getValueType()).getAccessMethods().getValues(series, range, ts);
    }

    @Override
    public <T> Observation<T> getFirstObservation(Series<T> series, TimeIndex time) throws T2DBException {
        return ((ValueTypeImpl)series.getValueType()).getAccessMethods().getFirst(series, time);
    }

    @Override
    public <T> Observation<T> getLastObservation(Series<T> series, TimeIndex time) throws T2DBException {
        return ((ValueTypeImpl)series.getValueType()).getAccessMethods().getLast(series, time);
    }

    @Override
    public <T> boolean update(UpdatableSeries<T> series, Range range) throws T2DBException {
        boolean done = ((ValueTypeImpl)series.getValueType()).getAccessMethods().updateSeries(series, range, this.getChronicleUpdatePolicy());
        if (done) {
            this.publish(new UpdateEventImpl(UpdateEventOperation.MODIFY, series));
        }
        return done;
    }

    @Override
    public <T> boolean deleteValue(UpdatableSeries<T> series, TimeIndex t) throws T2DBException {
        boolean done = ((ValueTypeImpl)series.getValueType()).getAccessMethods().deleteValue(series, t, this.getChronicleUpdatePolicy());
        if (done) {
            this.publish(new UpdateEventImpl(UpdateEventOperation.MODIFY, series));
        }
        return done;
    }

    @Override
    public <T> long update(UpdatableSeries<T> series, TimeAddressable<T> values) throws T2DBException {
        long count = ((ValueTypeImpl)series.getValueType()).getAccessMethods().updateValues(series, values, this.getChronicleUpdatePolicy());
        if (count > 0L) {
            UpdateEventImpl event = new UpdateEventImpl(UpdateEventOperation.MODIFY, series);
            if (this.getMessageListener().isListened(Level.FINER)) {
                event.withComment(values.toString());
            }
            this.publish(event);
        }
        return count;
    }

    @Override
    public Schema getSchema(Surrogate surrogate) throws T2DBException {
        this.checkSurrogate(surrogate, DBObjectType.SCHEMA);
        return this.getUpdatableSchema(surrogate).resolve();
    }

    @Override
    public Property<?> getProperty(String name, boolean mustExist) throws T2DBException {
        Property<?> prop = this.getProperty(name);
        if (prop == null && mustExist) {
            throw T2DBMsg.exception("D20109", name);
        }
        return prop;
    }

    @Override
    public Property<?> getSymbolBuiltInProperty() throws T2DBException {
        return this.getCache().lookUpProperty("Symbol");
    }

    @Override
    public Property<?> getTimeDomainBuiltInProperty() throws T2DBException {
        return this.getCache().lookUpProperty("Calendar");
    }

    @Override
    public Property<?> getTypeBuiltInProperty() throws T2DBException {
        return this.getCache().lookUpProperty("Type");
    }

    @Override
    public Property<?> getSparsityBuiltInProperty() throws T2DBException {
        return this.getCache().lookUpProperty("Sparsity");
    }

    @Override
    public Collection<Schema> getSchemas(String pattern) throws T2DBException {
        Collection<Surrogate> keys = this.getSchemaSurrogates(pattern);
        ArrayList<Schema> result = new ArrayList<Schema>(keys.size());
        for (Surrogate surrogate : keys) {
            try {
                result.add(this.getSchema(surrogate));
            }
            catch (KeyedException e) {
                this.getMessageListener().log((Exception)((Object)e));
            }
        }
        return result;
    }

    @Override
    public Collection<UpdatableSchema> getUpdatableSchemas(String pattern) throws T2DBException {
        Collection<Surrogate> keys = this.getSchemaSurrogates(pattern);
        ArrayList<UpdatableSchema> result = new ArrayList<UpdatableSchema>(keys.size());
        for (Surrogate surrogate : keys) {
            result.add(this.getUpdatableSchema(surrogate));
        }
        return result;
    }

    @Override
    public UpdatableSchema getUpdatableSchema(Schema schema) throws T2DBException {
        if (schema instanceof UpdatableSchema) {
            throw new IllegalArgumentException("schema is an UpdatableSchema");
        }
        return this.getUpdatableSchema(schema.getSurrogate());
    }

    @Override
    public <T> UpdatableValueType<T> createValueType(String name, boolean restricted, String scannerClassOrKeyword) throws T2DBException {
        return new UpdatableValueTypeImpl(name, restricted, scannerClassOrKeyword, null, new SurrogateImpl(this, DBObjectType.VALUE_TYPE, null));
    }

    @Override
    public <T> UpdatableProperty<T> createProperty(String name, ValueType<T> valueType, boolean indexed) throws T2DBException {
        SurrogateImpl surrogate = new SurrogateImpl(this, DBObjectType.PROPERTY, null);
        return new UpdatablePropertyImpl<T>(name, valueType, indexed, surrogate);
    }

    @Override
    public UpdatableSchema createSchema(String name, String nameOfBase) throws T2DBException {
        if (this.getSchemas(name).size() > 0) {
            throw T2DBMsg.exception("D30108", name);
        }
        UpdatableSchema base = null;
        if (nameOfBase != null && nameOfBase.length() > 0) {
            Collection<UpdatableSchema> list = this.getUpdatableSchemas(nameOfBase);
            if (list.size() != 1) {
                throw T2DBMsg.exception("D30109", name, nameOfBase);
            }
            base = list.iterator().next();
        }
        SurrogateImpl surrogate = new SurrogateImpl(this, DBObjectType.SCHEMA, null);
        return new UpdatableSchemaImpl(name, base, null, null, surrogate);
    }

    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        try {
            return this.getTopChronicle().getName(true);
        }
        catch (Exception e) {
            throw new RuntimeException("bug", e);
        }
    }
}

