/*
 *   Copyright 2012-2013 Hauser Olsson GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package ch.agent.crnickl.api;

import ch.agent.crnickl.impl.SurrogateImpl.InvalidDBObject;

/**
 * An UpdateEvent is generated by CrNiCKL when something interesting occurs.
 * The type of an update event is the database object type of the event source.
 * 
 * @author Jean-Paul Vetterli
 */
public interface UpdateEvent {
	
	/**
	 * Return the type of the database object source of the event.
	 * @return the database object type
	 */
	DBObjectType getType();
	
	/**
	 * Return a constant identifying the operation which generated the event.
	 * @return a constant identifying the operation
	 */
	UpdateEventOperation getOperation();
	
	/**
	 * Return the surrogate of the database object source of the event.
	 * 
	 * @return a surrogate
	 */
	Surrogate getSurrogate();
	
	/**
	 * Return a comment giving informal details on the operation reported in the event. 
	 * 
	 * @return a comment or null
	 */
	String getComment();
	
	/**
	 * Return the database object reported by the event. 
	 * The source is <b>not reliable</b> because it can
	 * identify something which has been deleted. Depending on the case, the
	 * source still holds useful information like the name. If a reliable source
	 * is required, it can be constructed from the surrogate using the
	 * {@link Surrogate#getObject()} method, which returns either a valid source of an
	 * {@link InvalidDBObject} object.
	 * 
	 * @return the database object for which the event was generated
	 */
	DBObject getSource();
	
	/**
	 * Return the database object for which the event was reported.
	 * If the object is invalid, return null.  
	 * @return the database object for which the event was generated or null
	 */
	DBObject getSourceOrNull();
	
}

