/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.UpdateEvent;
import ch.agent.crnickl.api.UpdateEventPublisher;
import ch.agent.crnickl.api.UpdateEventSubscriber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateEventPublisherImpl
implements UpdateEventPublisher {
    private Map<UpdateEventSubscriber, Subscription> subscriptions = new HashMap<UpdateEventSubscriber, Subscription>();
    private Map<UpdateEventSubscriber, Subscription> prioritySubscriptions = new HashMap<UpdateEventSubscriber, Subscription>();
    private List<UpdateEvent> events = new ArrayList<UpdateEvent>();

    @Override
    public void subscribe(UpdateEventSubscriber subscriber, DBObjectType type, boolean priority) {
        Subscription s = this.subscriptions.get(subscriber);
        if (s == null) {
            s = this.prioritySubscriptions.get(subscriber);
        }
        if (s == null) {
            s = new Subscription();
            if (priority) {
                s.setPriority(true);
                this.prioritySubscriptions.put(subscriber, s);
            } else {
                this.subscriptions.put(subscriber, s);
            }
        } else if (priority && !s.isPriority()) {
            s.setPriority(true);
            this.subscriptions.remove(subscriber);
            this.prioritySubscriptions.put(subscriber, s);
        }
        s.subscribe(type);
    }

    @Override
    public void unsubscribe(UpdateEventSubscriber subscriber) {
        this.subscriptions.remove(subscriber);
        this.prioritySubscriptions.remove(subscriber);
    }

    @Override
    public void unsubscribeAll() {
        this.subscriptions.clear();
        this.prioritySubscriptions.clear();
    }

    @Override
    public void publish(UpdateEvent event, boolean immediate) {
        if (immediate) {
            this.notify(event, this.prioritySubscriptions);
            this.notify(event, this.subscriptions);
        } else {
            this.events.add(event);
        }
    }

    @Override
    public void release() {
        for (UpdateEvent event : this.events) {
            this.notify(event, this.prioritySubscriptions);
        }
        for (UpdateEvent event : this.events) {
            this.notify(event, this.subscriptions);
        }
        this.clear();
    }

    private void notify(UpdateEvent event, Map<UpdateEventSubscriber, Subscription> subs) {
        for (Map.Entry<UpdateEventSubscriber, Subscription> s : subs.entrySet()) {
            if (!s.getValue().isSubscribed(event.getType())) continue;
            s.getKey().notify(event);
        }
    }

    public int clear() {
        int size = this.events.size();
        this.events.clear();
        return size;
    }

    protected class Subscription {
        private boolean[] types = new boolean[DBObjectType.values().length];
        private boolean priority;

        public boolean isPriority() {
            return this.priority;
        }

        public void setPriority(boolean priority) {
            this.priority = priority;
        }

        public boolean isSubscribed(DBObjectType type) {
            return this.types[type.ordinal()];
        }

        public void subscribe(DBObjectType type) {
            this.types[type.ordinal()] = true;
        }

        public void unsubscribe(DBObjectType type) {
            this.types[type.ordinal()] = false;
        }
    }
}

