/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdateEvent;
import ch.agent.crnickl.api.UpdateEventOperation;

public class UpdateEventImpl
implements UpdateEvent {
    private DBObjectType type;
    private UpdateEventOperation op;
    private DBObject source;
    private String comment;

    public UpdateEventImpl(UpdateEventOperation op, DBObject source) {
        if (source == null) {
            throw new IllegalArgumentException("source null");
        }
        this.source = source;
        this.type = this.source.getSurrogate().getDBObjectType();
        this.op = op;
    }

    public UpdateEvent withComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public DBObjectType getType() {
        return this.type;
    }

    @Override
    public UpdateEventOperation getOperation() {
        return this.op;
    }

    @Override
    public Surrogate getSurrogate() {
        return this.source.getSurrogate();
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public DBObject getSource() {
        return this.source;
    }

    @Override
    public DBObject getSourceOrNull() {
        DBObject dBObject = this.getSource();
        return dBObject.isValid() ? dBObject : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateEventImpl other = (UpdateEventImpl)obj;
        if (this.op != other.op) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        String result = null;
        try {
            result = this.comment == null ? String.format("%s %s %s", this.op.name(), this.type.name(), this.source.toString()) : String.format("%s %s %s (%s)", this.op.name(), this.type.name(), this.source.toString(), this.comment);
        }
        catch (Exception e) {
            result = this.comment == null ? String.format("%s %s %s", this.op.name(), this.type.name(), ((Object)this.getSurrogate()).toString()) : String.format("%s %s %s (%s)", this.op.name(), this.type.name(), ((Object)this.getSurrogate()).toString(), this.comment);
        }
        return result;
    }
}

