/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.impl.ValueTypeImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UpdatableValueTypeImpl<T>
extends ValueTypeImpl<T>
implements UpdatableValueType<T> {
    private boolean delete;
    private String name;
    private Map<T, String> added = new HashMap<T, String>();
    private Map<T, String> edited = new HashMap<T, String>();
    private Set<T> deleted = new HashSet<T>();

    protected UpdatableValueTypeImpl(ValueTypeImpl<T> valueType) throws T2DBException {
        super(valueType);
    }

    public UpdatableValueTypeImpl(String name, boolean restricted, String scannerClassOrKeyword, Map<String, String> valuesAndDescriptions, Surrogate surrogate) throws T2DBException {
        super(name, restricted, scannerClassOrKeyword, valuesAndDescriptions, surrogate);
    }

    @Override
    protected void update() throws T2DBException {
        this.name = null;
        this.added.clear();
        this.edited.clear();
        this.deleted.clear();
        super.update();
    }

    @Override
    public void applyUpdates() throws T2DBException {
        if (this.delete) {
            this.getDatabase().deleteValueType(this);
            this.delete = false;
        } else {
            if (this.getSurrogate().inConstruction()) {
                this.getDatabase().create(this);
                this.name = null;
            }
            if (this.name != null) {
                this.getDatabase().update(this);
            }
            if (this.added.size() > 0 || this.edited.size() > 0 || this.deleted.size() > 0) {
                this.getDatabase().update(this, this.added, this.edited, this.deleted);
            }
            this.update();
        }
    }

    @Override
    public UpdatableValueType<T> edit() {
        return this;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.getName();
    }

    @Override
    public void setName(String name) throws T2DBException {
        if (this.delete) {
            throw T2DBMsg.exception("D10120", this.getName());
        }
        this.name = name;
    }

    @Override
    public Set<T> getValues() {
        return this.getValueDescriptions().keySet();
    }

    @Override
    public Map<T, String> getValueDescriptions() {
        if (this.added.size() > 0 || this.edited.size() > 0 || this.deleted.size() > 0) {
            HashMap v = new HashMap(super.getValueDescriptions());
            for (Map.Entry<T, String> e : this.added.entrySet()) {
                v.put(e.getKey(), e.getValue());
            }
            for (Map.Entry<T, String> e : this.edited.entrySet()) {
                v.put(e.getKey(), e.getValue());
            }
            for (Map.Entry<Object, String> value : this.deleted) {
                v.remove(value);
            }
            return v;
        }
        return super.getValueDescriptions();
    }

    @Override
    public void addValue(T value, String description) throws T2DBException {
        if (!this.isRestricted()) {
            throw T2DBMsg.exception("D10108", this.getName());
        }
        if (value == null) {
            throw new IllegalArgumentException("value null");
        }
        if (this.delete) {
            throw T2DBMsg.exception("D10120", this.getName());
        }
        if (this.getValues().contains(value)) {
            throw T2DBMsg.exception("D10121", this.getName(), value);
        }
        this.added.put(value, description);
    }

    @Override
    public void updateValue(T value, String description) throws T2DBException {
        if (!this.isRestricted()) {
            throw T2DBMsg.exception("D10108", this.getName());
        }
        if (value == null) {
            throw new IllegalArgumentException("value null");
        }
        if (this.delete) {
            throw T2DBMsg.exception("D10120", this.getName());
        }
        if (!this.getValues().contains(value)) {
            throw T2DBMsg.exception("D10123", this.getName(), value);
        }
        this.edited.put(value, description);
    }

    @Override
    public void deleteValue(T value) throws T2DBException {
        if (!this.isRestricted()) {
            throw T2DBMsg.exception("D10108", this.getName());
        }
        if (this.delete) {
            throw T2DBMsg.exception("D10120", this.getName());
        }
        if (value == null || !this.getValues().contains(value)) {
            throw T2DBMsg.exception("D10122", this.getName(), value);
        }
        this.deleted.add(value);
    }

    @Override
    public void destroy() throws T2DBException {
        if (this.name != null || this.added.size() > 0 || this.edited.size() > 0 || this.deleted.size() > 0) {
            throw T2DBMsg.exception("D10119", this.getName());
        }
        this.delete = true;
    }
}

