/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.AttributeDefinitionImpl;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.SchemaImpl;
import ch.agent.crnickl.impl.SeriesDefinitionImpl;
import ch.agent.crnickl.impl.SurrogateImpl;
import ch.agent.t2.time.TimeDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UpdatableSchemaImpl
extends SchemaImpl
implements UpdatableSchema {
    private boolean delete;
    private UpdatableSchema base;
    private String editedName;
    private UpdatableSchema editedBase;
    private boolean editedBaseSet;

    public UpdatableSchemaImpl(String name, UpdatableSchema base, Collection<AttributeDefinition<?>> attributeDefs, Collection<SeriesDefinition> seriesDefinitions, Surrogate surrogate) {
        super(true, name, attributeDefs, seriesDefinitions, surrogate, null);
        this.base = base;
    }

    @Override
    public void applyUpdates() throws T2DBException {
        if (this.delete) {
            this.getDatabase().deleteSchema(this);
            this.delete = false;
        } else {
            if (this.getSurrogate().inConstruction()) {
                this.getDatabase().create(this);
                if (this.editedBaseSet) {
                    this.base = this.editedBase;
                }
                this.editedBaseSet = false;
                this.editedName = null;
                this.editedBase = null;
            } else {
                this.getDatabase().getCache().clear(this);
            }
            this.getDatabase().update(this);
            this.update();
        }
    }

    @Override
    protected void update() throws T2DBException {
        super.update();
        if (this.editedBaseSet) {
            this.base = this.editedBase;
        }
        this.editedBaseSet = false;
        this.editedBase = null;
        this.editedName = null;
        this.getAttributeDefinitionsObject().consolidate();
        this.getSeriesDefinitionsObject().consolidate();
    }

    @Override
    public UpdatableSchema edit() {
        return this;
    }

    @Override
    public void destroy() throws T2DBException {
        this.delete = true;
    }

    @Override
    public String getName() {
        if (this.editedName != null) {
            return this.editedName;
        }
        return super.getName();
    }

    @Override
    public void setName(String name) throws T2DBException {
        if (name != null && name.length() == 0) {
            name = null;
        }
        this.editedName = name;
    }

    @Override
    public UpdatableSchema getBase() {
        if (this.editedBase != null) {
            return this.editedBase;
        }
        return this.base;
    }

    public UpdatableSchema getPreviousBase() {
        return this.base;
    }

    @Override
    public void setBase(UpdatableSchema base) throws T2DBException {
        this.editedBase = base;
    }

    @Override
    public SeriesDefinition addSeries(int seriesNr) throws T2DBException {
        return this.addSeries(seriesNr, false);
    }

    private SeriesDefinition addSeries(int seriesNr, boolean merging) throws T2DBException {
        SeriesDefinitionImpl ss = new SeriesDefinitionImpl(seriesNr, null, null);
        boolean added = this.getSeriesDefinitionsObject().addComponent(ss);
        if (!added && !merging) {
            throw T2DBMsg.exception("D30124", seriesNr, this);
        }
        return ss;
    }

    @Override
    public void deleteSeries(int seriesNr) throws T2DBException {
        this.getSeriesDefinitionsObject().deleteComponent(seriesNr);
    }

    @Override
    public void eraseSeries(int seriesNr) throws T2DBException {
        this.startEditingSeriesSchema(seriesNr).setErasing(true);
    }

    @Override
    public void setSeriesDescription(int seriesNr, String description) throws T2DBException {
        this.editSeriesAttributeDefinition(seriesNr, 1, true);
        this.startEditingSeriesSchema(seriesNr).setDescription(description);
    }

    @Override
    public void setSeriesName(int seriesNr, String name) throws T2DBException {
        AttributeDefinitionImpl def = this.editSeriesAttributeDefinition(seriesNr, 1, false);
        if (def == null) {
            Property<?> property = this.getBuiltInProperty(1);
            def = (AttributeDefinitionImpl)this.addAttribute(seriesNr, 1);
            def.setProperty(property);
        }
        def.setValue(name);
    }

    @Override
    public void setSeriesType(int seriesNr, ValueType<?> type) throws T2DBException {
        AttributeDefinitionImpl def = this.editSeriesAttributeDefinition(seriesNr, 2, false);
        if (def == null) {
            Property<?> property = this.getBuiltInProperty(2);
            def = (AttributeDefinitionImpl)this.addAttribute(seriesNr, 2);
            def.setProperty(property);
        }
        def.setValue(type);
    }

    @Override
    public void setSeriesType(int seriesNr, String type) throws T2DBException {
        DatabaseBackend db = ((SurrogateImpl)this.getSurrogate()).getDatabase();
        SurrogateImpl surrogate = new SurrogateImpl(db, DBObjectType.VALUE_TYPE, 2);
        ValueType vt = db.getValueType(surrogate);
        this.setSeriesType(seriesNr, (ValueType)vt.scan(type));
    }

    @Override
    public void setSeriesTimeDomain(int seriesNr, TimeDomain timeDomain) throws T2DBException {
        AttributeDefinitionImpl def = this.editSeriesAttributeDefinition(seriesNr, 3, false);
        if (def == null) {
            Property<?> property = this.getBuiltInProperty(3);
            def = (AttributeDefinitionImpl)this.addAttribute(seriesNr, 3);
            def.setProperty(property);
        }
        def.setValue(timeDomain);
    }

    @Override
    public void setSeriesSparsity(int seriesNr, boolean sparse) throws T2DBException {
        AttributeDefinitionImpl def = this.editSeriesAttributeDefinition(seriesNr, 4, false);
        if (def == null) {
            Property<?> property = this.getBuiltInProperty(4);
            def = (AttributeDefinitionImpl)this.addAttribute(seriesNr, 4);
            def.setProperty(property);
        }
        def.setValue(sparse);
    }

    public Collection<SeriesDefinition> getEditedSeriesDefinitions() {
        return this.getSeriesDefinitionsObject().getEditedComponents();
    }

    public Set<Integer> getDeletedSeriesDefinitions() {
        return this.getSeriesDefinitionsObject().getDeletedComponents();
    }

    @Override
    public AttributeDefinition<?> addAttribute(int attrNr) throws T2DBException {
        return this.addAttribute(attrNr, false);
    }

    private AttributeDefinition<?> addAttribute(int attrNr, boolean merging) throws T2DBException {
        AttributeDefinitionImpl<Object> def = new AttributeDefinitionImpl<Object>(attrNr, null, null);
        boolean added = this.getAttributeDefinitionsObject().addComponent(def);
        if (!added && !merging) {
            throw T2DBMsg.exception("D30127", attrNr, this);
        }
        return def;
    }

    @Override
    public void deleteAttribute(int attrNr) throws T2DBException {
        this.getAttributeDefinitionsObject().deleteComponent(attrNr);
    }

    @Override
    public void eraseAttribute(int attrNr) throws T2DBException {
        this.editAttributeDefinition(attrNr).setErasing(true);
    }

    @Override
    public <T> void setAttributeProperty(int attrNr, Property<T> property) throws T2DBException {
        this.editAttributeDefinition(attrNr).setProperty(property);
    }

    @Override
    public <T> void setAttributeDefault(int attrNr, T defaultValue) throws T2DBException {
        this.editAttributeDefinition(attrNr).setValue(defaultValue);
    }

    @Override
    public AttributeDefinition<?> addAttribute(int seriesNr, int attrNr) throws T2DBException {
        return this.addAttribute(seriesNr, attrNr, false);
    }

    private AttributeDefinition<?> addAttribute(int seriesNr, int attrNr, boolean merging) throws T2DBException {
        AttributeDefinitionImpl<Object> def = new AttributeDefinitionImpl<Object>(attrNr, null, null);
        boolean added = this.startEditingSeriesSchema(seriesNr).getAttributeDefinitionsObject().addComponent(def);
        if (!added && !merging) {
            throw T2DBMsg.exception("D30118", attrNr, seriesNr, this);
        }
        return def;
    }

    @Override
    public void deleteAttribute(int seriesNr, int attrNr) throws T2DBException {
        this.startEditingSeriesSchema(seriesNr).getAttributeDefinitionsObject().deleteComponent(attrNr);
    }

    @Override
    public void eraseAttribute(int seriesNr, int attrNr) throws T2DBException {
        this.editSeriesAttributeDefinition(seriesNr, attrNr, true).setErasing(true);
    }

    @Override
    public void setAttributeProperty(int seriesNr, int attrNr, Property<?> property) throws T2DBException {
        this.editSeriesAttributeDefinition(seriesNr, attrNr, true).setProperty(property);
    }

    @Override
    public void setAttributeDefault(int seriesNr, int attrNr, Object defaultValue) throws T2DBException {
        this.editSeriesAttributeDefinition(seriesNr, attrNr, true).setValue(defaultValue);
    }

    public Collection<AttributeDefinition<?>> getEditedAttributeDefinitions(int seriesNr) throws T2DBException {
        SeriesDefinitionImpl schema = (SeriesDefinitionImpl)this.findEditedSeriesSchema(seriesNr);
        return schema == null ? new ArrayList() : schema.getAttributeDefinitionsObject().getEditedComponents();
    }

    public Set<Integer> getDeletedAttributeDefinitions(int seriesNr) throws T2DBException {
        SeriesDefinitionImpl schema = (SeriesDefinitionImpl)this.findEditedSeriesSchema(seriesNr);
        return schema == null ? new HashSet() : schema.getAttributeDefinitionsObject().getDeletedComponents();
    }

    public Collection<AttributeDefinition<?>> getEditedAttributeDefinitions() {
        return this.getAttributeDefinitionsObject().getEditedComponents();
    }

    public Set<Integer> getDeletedAttributeDefinitions() {
        return this.getAttributeDefinitionsObject().getDeletedComponents();
    }

    protected SeriesDefinition findEditedSeriesSchema(int seriesNr) throws T2DBException {
        SeriesDefinition schema = null;
        for (SeriesDefinition ss : this.getEditedSeriesDefinitions()) {
            if (ss.getNumber() != seriesNr) continue;
            schema = ss;
        }
        return schema;
    }

    protected SeriesDefinitionImpl startEditingSeriesSchema(int seriesNr) throws T2DBException {
        SeriesDefinitionImpl sch = (SeriesDefinitionImpl)this.getSeriesDefinitionsObject().edit(seriesNr);
        if (sch == null) {
            throw T2DBMsg.exception("D30125", seriesNr, this.getName());
        }
        return sch;
    }

    protected AttributeDefinitionImpl<?> editAttributeDefinition(int attrNr) throws T2DBException {
        AttributeDefinitionImpl def = (AttributeDefinitionImpl)this.getAttributeDefinitionsObject().edit(attrNr);
        if (def == null) {
            throw T2DBMsg.exception("D30123", attrNr, this.getName());
        }
        return def;
    }

    protected AttributeDefinitionImpl<?> editSeriesAttributeDefinition(int seriesNr, int attrNr, boolean mustExist) throws T2DBException {
        AttributeDefinitionImpl def = (AttributeDefinitionImpl)this.startEditingSeriesSchema(seriesNr).getAttributeDefinitionsObject().edit(attrNr);
        if (def == null && mustExist) {
            throw T2DBMsg.exception("D30126", attrNr, seriesNr, this.getName());
        }
        return def;
    }

    private Property<?> getBuiltInProperty(int magicNumber) throws T2DBException {
        SurrogateImpl thisKey = (SurrogateImpl)this.getSurrogate();
        SurrogateImpl propKey = new SurrogateImpl(thisKey.getDatabase(), DBObjectType.PROPERTY, magicNumber);
        return thisKey.getDatabase().getProperty(propKey);
    }

    public void merge(UpdatableSchema schema) throws T2DBException {
        for (AttributeDefinition<?> def : schema.getAttributeDefinitions()) {
            int dn = def.getNumber();
            if (def.isErasing()) {
                this.deleteAttribute(dn);
                continue;
            }
            this.addAttribute(dn, true);
            if (def.getProperty() != null) {
                this.setAttributeProperty(dn, def.getProperty());
            }
            if (def.getValue() == null) continue;
            this.setAttributeDefault(dn, def.getValue());
        }
        for (SeriesDefinition ss : schema.getSeriesDefinitions()) {
            int sn = ss.getNumber();
            if (ss.isErasing()) {
                this.deleteSeries(sn);
                continue;
            }
            this.addSeries(sn, true);
            for (AttributeDefinition<?> def : ss.getAttributeDefinitions()) {
                int dn = def.getNumber();
                if (def.isErasing()) {
                    this.deleteAttribute(sn, dn);
                    continue;
                }
                this.addAttribute(sn, dn, true);
                if (def.getProperty() != null) {
                    this.setAttributeProperty(sn, dn, def.getProperty());
                }
                if (def.getValue() == null) continue;
                this.setAttributeDefault(sn, dn, def.getValue());
            }
            if (ss.getDescription() == null) continue;
            this.setSeriesDescription(sn, ss.getDescription());
        }
    }

    public Schema consolidate(String name, Surrogate surrogate, List<Surrogate> dependencyList) throws T2DBException {
        try {
            this.getAttributeDefinitionsObject().consolidate();
            this.getSeriesDefinitionsObject().consolidate();
        }
        catch (T2DBException e) {
            throw T2DBMsg.exception((Throwable)((Object)e), "D30129", name);
        }
        return new SchemaImpl(name, this.getAttributeDefinitions(), this.getSeriesDefinitions(), surrogate, dependencyList);
    }
}

