/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableProperty;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.PropertyImpl;

public class UpdatablePropertyImpl<T>
extends PropertyImpl<T>
implements UpdatableProperty<T> {
    private boolean delete;
    private String name;

    public UpdatablePropertyImpl(String name, ValueType<T> valueType, boolean indexed, Surrogate surrogate) {
        super(name, valueType, indexed, surrogate);
    }

    @Override
    protected void update() {
        super.update();
        this.name = null;
    }

    @Override
    public UpdatableProperty<T> edit() {
        return this;
    }

    @Override
    public void applyUpdates() throws T2DBException {
        if (this.delete) {
            this.getDatabase().deleteProperty(this);
            this.delete = false;
        } else {
            if (this.getSurrogate().inConstruction()) {
                this.getDatabase().create(this);
            }
            if (this.name != null) {
                this.getDatabase().getCache().clear(this);
                this.getDatabase().update(this);
            }
            this.update();
        }
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.getName();
    }

    @Override
    public void setName(String name) throws T2DBException {
        if (this.delete) {
            throw T2DBMsg.exception("D20108", this.getName());
        }
        this.name = name;
    }

    @Override
    public void destroy() throws T2DBException {
        if (this.name != null) {
            throw T2DBMsg.exception("D20107", this.getName());
        }
        this.delete = true;
    }
}

