/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.impl.DatabaseBackend;

public class SurrogateImpl
implements Surrogate {
    private String string;
    private int hashCode;
    private DatabaseBackend db;
    private DBObjectType dot;
    private int id;

    public SurrogateImpl(DatabaseBackend db, DBObjectType dot, int id) {
        this.db = db;
        this.dot = dot;
        this.id = id;
    }

    @Override
    public void upgrade(Surrogate surrogate) {
        if (!this.inConstruction()) {
            throw new IllegalStateException();
        }
        if (((SurrogateImpl)surrogate).dot != this.dot || ((SurrogateImpl)surrogate).id <= 0) {
            throw new RuntimeException("bug: " + ((Object)surrogate).toString());
        }
        this.id = ((SurrogateImpl)surrogate).id;
    }

    @Override
    public DatabaseBackend getDatabase() {
        return this.db;
    }

    @Override
    public DBObjectType getDBObjectType() {
        return this.dot;
    }

    public Integer getId() {
        return this.id;
    }

    @Override
    public boolean inConstruction() {
        return this.id <= 0;
    }

    @Override
    public DBObject getObject() {
        if (this.inConstruction()) {
            return null;
        }
        try {
            switch (this.dot) {
                case CHRONICLE: {
                    return this.getDatabase().getChronicle(this);
                }
                case SERIES: {
                    return this.getDatabase().getSeries(this);
                }
                case SCHEMA: {
                    return this.getDatabase().getSchema(this);
                }
                case PROPERTY: {
                    return this.getDatabase().getProperty(this);
                }
                case VALUE_TYPE: {
                    return this.getDatabase().getValueType(this);
                }
            }
            throw new RuntimeException("bug: " + this.dot.name());
        }
        catch (T2DBException e) {
            return new InvalidDBObject(this, e.getMsg().toString());
        }
    }

    @Override
    public int hashCode() {
        if (this.inConstruction()) {
            throw new IllegalStateException();
        }
        if (this.hashCode <= 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.db == null ? 0 : this.db.hashCode());
            result = 31 * result + (this.dot == null ? 0 : this.dot.hashCode());
            this.hashCode = result = 31 * result + this.id;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SurrogateImpl other = (SurrogateImpl)obj;
        if (this.db == null ? other.db != null : !this.db.equals(other.db)) {
            return false;
        }
        if (this.dot != other.dot) {
            return false;
        }
        return this.id > 0 && this.id == other.id;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            Chronicle top = this.db.getTopChronicle();
            this.string = String.format("%s-%d-%d", top == null ? null : top.toString(), this.dot.ordinal(), this.id);
        }
        return this.string;
    }

    public class InvalidDBObject
    implements DBObject {
        private Surrogate surrogate;
        private String hint;

        public InvalidDBObject(Surrogate surrogate, String hint) {
            this.surrogate = surrogate;
            this.hint = hint;
        }

        @Override
        public Surrogate getSurrogate() {
            return this.surrogate;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        public String toString() {
            if (this.hint != null) {
                return String.format("%s (%s)", ((Object)this.surrogate).toString(), this.hint);
            }
            return ((Object)this.surrogate).toString();
        }
    }
}

