/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.SchemaComponent;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.SchemaComponents;
import ch.agent.t2.time.TimeDomain;
import java.util.ArrayList;
import java.util.Collection;

public class SeriesDefinitionImpl
implements SeriesDefinition {
    private boolean editMode;
    private boolean erasing;
    private int number;
    private String description;
    private SchemaComponents<AttributeDefinition<?>> attributes;

    public SeriesDefinitionImpl(int number, String description, Collection<AttributeDefinition<?>> attributeDefs) throws T2DBException {
        if (number < 1) {
            throw T2DBMsg.exception("D30117", new Object[0]);
        }
        this.number = number;
        this.description = description;
        this.attributes = new SchemaComponents(attributeDefs, 3, 30, (SchemaComponent[])new AttributeDefinition[0]);
    }

    @Override
    public boolean isComplete() {
        return !this.erasing && this.getName() != null && this.getValueType() != null && this.getTimeDomain() != null && this.attributes.isComplete();
    }

    @Override
    public boolean isErasing() {
        return this.erasing;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public Collection<AttributeDefinition<?>> getAttributeDefinitions() {
        return this.attributes.getComponents();
    }

    @Override
    public Collection<AttributeDefinition<?>> getCustomAttributeDefinitions() {
        Collection<AttributeDefinition<?>> defs = this.getAttributeDefinitions();
        ArrayList customDefs = new ArrayList(defs.size() - 3);
        for (AttributeDefinition<?> def : defs) {
            if (def.getNumber() <= 9) continue;
            customDefs.add(def);
        }
        return customDefs;
    }

    @Override
    public AttributeDefinition<?> getAttributeDefinition(String name, boolean mustExist) throws T2DBException {
        AttributeDefinition<?> def = this.attributes.getComponent(name);
        if (def == null && mustExist) {
            throw T2DBMsg.exception("D30119", name, this.getNumber());
        }
        return def;
    }

    @Override
    public AttributeDefinition<?> getAttributeDefinition(int attrNr, boolean mustExist) throws T2DBException {
        AttributeDefinition<?> def = this.attributes.getComponent(attrNr);
        if (def == null && mustExist) {
            throw T2DBMsg.exception("D30120", attrNr, this.getNumber());
        }
        return def;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        AttributeDefinition<?> def = this.attributes.getComponent(1);
        return def == null ? null : (String)def.getValue();
    }

    @Override
    public TimeDomain getTimeDomain() {
        AttributeDefinition<?> def = this.attributes.getComponent(3);
        return def == null ? null : (TimeDomain)def.getValue();
    }

    @Override
    public ValueType<?> getValueType() {
        AttributeDefinition<?> def = this.attributes.getComponent(2);
        return def == null ? null : (ValueType)def.getValue();
    }

    @Override
    public boolean isSparse() {
        AttributeDefinition<?> def = this.attributes.getComponent(4);
        return def == null ? false : (Boolean)def.getValue();
    }

    public void setErasing(boolean erasing) {
        this.checkEdit();
        this.erasing = erasing;
    }

    public void setDescription(String description) {
        this.checkEdit();
        this.description = description;
    }

    protected SchemaComponents<AttributeDefinition<?>> getAttributeDefinitionsObject() {
        return this.attributes;
    }

    @Override
    public void edit() {
        this.editMode = true;
    }

    private void checkEdit() {
        if (!this.editMode) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void edit(SchemaComponent component) throws T2DBException {
        if (!(component instanceof SeriesDefinition)) {
            throw new IllegalArgumentException(component == null ? null : component.getClass().getName());
        }
        SeriesDefinition arg = (SeriesDefinition)component;
        if (arg.isErasing()) {
            this.erasing = true;
        } else {
            if (arg.getDescription() != null) {
                this.setDescription(arg.getDescription());
            }
            try {
                this.attributes.consolidate();
            }
            catch (T2DBException e) {
                throw T2DBMsg.exception((Throwable)((Object)e), "D30131", this.getName(), component.getName());
            }
        }
    }

    @Override
    public void consolidate() throws T2DBException {
        this.attributes.consolidate();
    }

    @Override
    public int compareTo(SeriesDefinition o) {
        if (this.getNumber() > o.getNumber()) {
            return 1;
        }
        if (this.getNumber() < o.getNumber()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        String name = this.getName();
        return name == null ? "" + this.number : name;
    }
}

