/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.impl.UpdatableSchemaImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class SchemaUpdatePolicyImpl
implements SchemaUpdatePolicy {
    private DatabaseBackend database;

    public SchemaUpdatePolicyImpl(DatabaseBackend database) {
        this.database = database;
    }

    @Override
    public void willDelete(UpdatableSchema schema) throws T2DBException {
        Collection<UpdatableSchema> schemas = this.database.getUpdatableSchemas("*");
        int count = 0;
        for (UpdatableSchema s : schemas) {
            if (!schema.equals(s.getBase())) continue;
            ++count;
        }
        if (count > 0) {
            throw T2DBMsg.exception("D30140", schema.getName(), count);
        }
        schemas.clear();
        schemas.add(schema);
        Collection<Surrogate> entities = this.database.findChronicles(schemas);
        if (entities.size() > 0) {
            throw T2DBMsg.exception("D30141", schema.getName(), entities.size());
        }
    }

    @Override
    public void willUpdate(UpdatableSchema s) throws T2DBException {
        UpdatableSchemaImpl schema = (UpdatableSchemaImpl)s;
        UpdatableSchema base = schema.getBase();
        UpdatableSchema previousBase = schema.getPreviousBase();
        boolean baseEdited = false;
        if (base != null) {
            baseEdited = !base.equals(previousBase);
        } else if (previousBase != null) {
            baseEdited = true;
        }
        if (baseEdited) {
            boolean otherEdits;
            boolean bl = otherEdits = schema.getDeletedAttributeDefinitions().size() + schema.getEditedAttributeDefinitions().size() + schema.getDeletedSeriesDefinitions().size() + schema.getEditedSeriesDefinitions().size() > 0;
            if (otherEdits) {
                throw T2DBMsg.exception("D30139", schema.getName());
            }
            this.willUpdateBase(schema);
        }
    }

    private void willUpdateBase(UpdatableSchema s) throws T2DBException {
        UpdatableSchemaImpl schema = (UpdatableSchemaImpl)s;
        String baseSchemaName = schema.getBase() == null ? null : schema.getBase().getName();
        UpdatableSchemaImpl currentUES = new UpdatableSchemaImpl(schema.getName(), schema.getPreviousBase(), schema.getAttributeDefinitions(), schema.getSeriesDefinitions(), schema.getSurrogate());
        UpdatableSchemaImpl editedUES = new UpdatableSchemaImpl(schema.getName(), schema.getBase(), schema.getAttributeDefinitions(), schema.getSeriesDefinitions(), schema.getSurrogate());
        Schema current = this.database.resolve(currentUES);
        Schema edited = this.database.resolve(editedUES);
        if (current.getAttributeDefinitions().size() > edited.getAttributeDefinitions().size()) {
            throw T2DBMsg.exception("D30142", baseSchemaName);
        }
        if (current.getSeriesDefinitions().size() > edited.getSeriesDefinitions().size()) {
            throw T2DBMsg.exception("D30143", baseSchemaName);
        }
        for (AttributeDefinition<?> def : current.getAttributeDefinitions()) {
            if (def.equals(edited.getAttributeDefinition(def.getNumber(), false))) continue;
            throw T2DBMsg.exception("D30144", baseSchemaName, def.getNumber());
        }
        for (SeriesDefinition ss : current.getSeriesDefinitions()) {
            for (AttributeDefinition<?> def : current.getAttributeDefinitions()) {
                if (def.equals(edited.getAttributeDefinition(def.getNumber(), false))) continue;
                throw T2DBMsg.exception("D30145", baseSchemaName, def.getNumber(), ss.getNumber());
            }
        }
    }

    @Override
    public void willDelete(UpdatableSchema schema, AttributeDefinition<?> def) throws T2DBException {
        Set<UpdatableSchema> schemas = this.findDependentSchemas(schema);
        Iterator<UpdatableSchema> it = schemas.iterator();
        while (it.hasNext()) {
            UpdatableSchema s = it.next();
            if (s.getAttributeDefinition(def.getNumber(), false) != null) continue;
            it.remove();
        }
        Collection<Surrogate> entities = this.database.findChronicles(def.getProperty(), schemas);
        if (entities.size() > 0) {
            throw T2DBMsg.exception("D30146", def.getNumber(), schema.getName(), entities.size());
        }
    }

    private Set<UpdatableSchema> findDependentSchemas(UpdatableSchema schema) throws T2DBException {
        Collection<UpdatableSchema> schemas = this.database.getUpdatableSchemas("*");
        HashMap<String, UpdatableSchema> bases = new HashMap<String, UpdatableSchema>(schemas.size());
        for (UpdatableSchema s : schemas) {
            bases.put(s.getName(), s.getBase());
        }
        String name = schema.getName();
        HashSet<UpdatableSchema> result = new HashSet<UpdatableSchema>();
        result.add(schema);
        LinkedHashSet<String> cycleDetector = new LinkedHashSet<String>();
        block1: for (UpdatableSchema s : schemas) {
            cycleDetector.clear();
            cycleDetector.add(s.getName());
            for (UpdatableSchema base = s.getBase(); base != null; base = base.getBase()) {
                if (!base.getName().equals(name)) continue;
                if (!cycleDetector.add(base.getName())) {
                    throw T2DBMsg.exception("D30147", schema.getName(), ((Object)cycleDetector).toString());
                }
                result.add(s);
                continue block1;
            }
        }
        return result;
    }

    @Override
    public void willUpdate(UpdatableSchema schema, AttributeDefinition<?> def) throws T2DBException {
    }

    @Override
    public void willDelete(UpdatableSchema schema, SeriesDefinition ss) throws T2DBException {
        Set<UpdatableSchema> schemas = this.findDependentSchemas(schema);
        Iterator<UpdatableSchema> it = schemas.iterator();
        while (it.hasNext()) {
            UpdatableSchema s = it.next();
            if (s.getSeriesDefinition(ss.getNumber(), false) != null) continue;
            it.remove();
        }
        Collection<Surrogate> entities = this.database.findChronicles(ss, schemas);
        if (entities.size() > 0) {
            throw T2DBMsg.exception("D30150", ss.getNumber(), schema.getName(), entities.size());
        }
    }

    @Override
    public void willDelete(UpdatableSchema schema, SeriesDefinition ss, AttributeDefinition<?> def) throws T2DBException {
        if (this.database.isBuiltIn(def)) {
            throw T2DBMsg.exception("D30148", def.getNumber(), ss.getNumber(), schema.getName());
        }
    }

    @Override
    public void willUpdate(UpdatableSchema schema, SeriesDefinition ss, AttributeDefinition<?> def) throws T2DBException {
        if (this.database.isBuiltIn(def) && def.getNumber() != 1) {
            throw T2DBMsg.exception("D30149", def.getNumber(), ss.getNumber(), schema.getName());
        }
    }
}

