/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.SchemaComponent;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.impl.DBObjectImpl;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.SchemaComponents;
import ch.agent.crnickl.impl.SurrogateImpl;
import java.util.Collection;
import java.util.List;

public class SchemaImpl
extends DBObjectImpl
implements Schema {
    private boolean updatable;
    private String name;
    private SchemaComponents<SeriesDefinition> seriesDefinitions;
    private SchemaComponents<AttributeDefinition<?>> attributes;
    private List<Surrogate> dependencyList;

    public SchemaImpl(String name, Collection<AttributeDefinition<?>> attributeDefs, Collection<SeriesDefinition> seriesDefinitions, Surrogate surrogate, List<Surrogate> dependencyList) {
        this(false, name, attributeDefs, seriesDefinitions, surrogate, dependencyList);
    }

    protected SchemaImpl(boolean updatable, String name, Collection<AttributeDefinition<?>> attributeDefs, Collection<SeriesDefinition> seriesDefinitions, Surrogate surrogate, List<Surrogate> dependencyList) {
        super(surrogate);
        this.updatable = updatable;
        if (name == null) {
            throw new IllegalArgumentException("name null");
        }
        this.name = name;
        DatabaseBackend database = ((SurrogateImpl)surrogate).getDatabase();
        this.attributes = new SchemaComponents(attributeDefs, database.getNameIndexThreshold(), -1, null);
        this.seriesDefinitions = new SchemaComponents(seriesDefinitions, database.getNameIndexThreshold(), database.getNumberIndexMaxRange(), (SchemaComponent[])new SeriesDefinition[0]);
        this.dependencyList = dependencyList;
    }

    protected void update() throws T2DBException {
        SchemaImpl schema = null;
        schema = this.updatable ? (SchemaImpl)this.getDatabase().getSchema(this.getSurrogate()) : (SchemaImpl)((Object)this.getDatabase().getUpdatableSchema(this.getSurrogate()));
        this.name = schema.name;
        this.seriesDefinitions = schema.seriesDefinitions;
        this.attributes = schema.attributes;
    }

    @Override
    public boolean isComplete() {
        return this.attributes.isComplete() && this.seriesDefinitions.getComponents().size() > 0 && this.seriesDefinitions.isComplete();
    }

    @Override
    public UpdatableSchema edit() {
        try {
            return this.getDatabase().getUpdatableSchema(this);
        }
        catch (T2DBException e) {
            throw new RuntimeException("bug", (Throwable)((Object)e));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<SeriesDefinition> getSeriesDefinitions() {
        return this.seriesDefinitions.getComponents();
    }

    @Override
    public SeriesDefinition getSeriesDefinition(String name, boolean mustExist) throws T2DBException {
        SeriesDefinition schema = this.seriesDefinitions.getComponent(name);
        if (schema == null && mustExist) {
            throw T2DBMsg.exception("D30121", name, this.getName());
        }
        return schema;
    }

    @Override
    public SeriesDefinition getSeriesDefinition(int number, boolean mustExist) throws T2DBException {
        SeriesDefinition schema = this.seriesDefinitions.getComponent(number);
        if (schema == null && mustExist) {
            throw T2DBMsg.exception("D30125", number, this.getName());
        }
        return schema;
    }

    @Override
    public Collection<AttributeDefinition<?>> getAttributeDefinitions() {
        return this.attributes.getComponents();
    }

    @Override
    public AttributeDefinition<?> getAttributeDefinition(String name, boolean mustExist) throws T2DBException {
        AttributeDefinition<?> def = this.attributes.getComponent(name);
        if (def == null && mustExist) {
            throw T2DBMsg.exception("D30122", name, this.getName());
        }
        return def;
    }

    @Override
    public AttributeDefinition<?> getAttributeDefinition(int number, boolean mustExist) throws T2DBException {
        AttributeDefinition<?> def = this.attributes.getComponent(number);
        if (def == null && mustExist) {
            throw T2DBMsg.exception("D30123", number, this.getName());
        }
        return def;
    }

    protected SchemaComponents<AttributeDefinition<?>> getAttributeDefinitionsObject() {
        return this.attributes;
    }

    protected SchemaComponents<SeriesDefinition> getSeriesDefinitionsObject() {
        return this.seriesDefinitions;
    }

    public List<Surrogate> getDependencyList() {
        return this.dependencyList;
    }

    @Override
    public boolean dependsOnSchema(Schema schema) {
        Surrogate surrogate = schema.getSurrogate();
        if (this.dependencyList != null) {
            for (Surrogate k : this.dependencyList) {
                if (!((Object)k).equals(surrogate)) continue;
                return true;
            }
            return false;
        }
        return ((Object)this.getSurrogate()).equals(surrogate);
    }

    public String toString() {
        return this.getName();
    }
}

