/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.SchemaComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SchemaComponents<T extends SchemaComponent> {
    private Map<Integer, T> components = new TreeMap<Integer, T>();
    private Map<String, T> byName;
    private T[] byNumber;
    private int byNumberBase;
    private Map<Integer, T> edited;
    private Set<Integer> deleted;
    private boolean editMode;
    private int nameIndexThreshold;
    private int numberIndexMaxRange;
    private T[] template;

    public SchemaComponents(Collection<T> components, int nameIndexThreshold, int numberIndexMaxRange, T[] template) {
        this.nameIndexThreshold = nameIndexThreshold;
        this.numberIndexMaxRange = numberIndexMaxRange;
        this.template = template;
        if (components != null) {
            for (SchemaComponent component : components) {
                this.components.put(component.getNumber(), component);
            }
            this.makeIndexes();
        }
    }

    public SchemaComponents(Collection<T> components) {
        this(components, -1, -1, null);
    }

    private void clearUpdates() {
        if (this.edited != null) {
            this.edited.clear();
        }
        if (this.deleted != null) {
            this.deleted.clear();
        }
    }

    public boolean isComplete() {
        boolean ready;
        boolean bl = ready = !this.editMode;
        if (ready) {
            for (SchemaComponent compo : this.components.values()) {
                if (compo.isComplete()) continue;
                ready = false;
                break;
            }
        }
        return ready;
    }

    public Collection<T> getComponents() {
        return this.components.values();
    }

    public Collection<T> getEditedComponents() {
        return this.edited == null ? new ArrayList() : this.edited.values();
    }

    public Set<Integer> getDeletedComponents() {
        return this.deleted == null ? new HashSet() : this.deleted;
    }

    public T getComponent(int number) {
        SchemaComponent component = null;
        if (this.byNumber != null) {
            int i = number - this.byNumberBase;
            if (i >= 0 && i < this.byNumber.length) {
                component = this.byNumber[i];
            }
        } else {
            component = (SchemaComponent)this.components.get(number);
        }
        return (T)component;
    }

    public T getComponent(String name) {
        SchemaComponent component = null;
        if (this.byName == null) {
            for (SchemaComponent c : this.components.values()) {
                if (!c.getName().equals(name)) continue;
                component = c;
                break;
            }
        } else {
            component = (SchemaComponent)this.byName.get(name);
        }
        return (T)component;
    }

    public T edit(int number) {
        this.edit();
        this.deleted.remove(number);
        SchemaComponent component = (SchemaComponent)this.edited.get(number);
        if (component == null && (component = this.getComponent(number)) != null) {
            component.edit();
            this.edited.put(number, component);
        }
        return (T)component;
    }

    public boolean addComponent(T component) throws T2DBException {
        boolean added = false;
        this.edit();
        Integer number = component.getNumber();
        if (this.getComponent(number) == null && this.edited.get(number) == null) {
            this.deleted.remove(number);
            component.edit();
            this.edited.put(number, component);
            added = true;
        }
        return added;
    }

    public boolean deleteComponent(int number) {
        this.edit();
        boolean done = false;
        if (this.edited.remove(number) != null) {
            done = true;
        } else if (this.getComponent(number) != null) {
            this.deleted.add(number);
            done = true;
        }
        return done;
    }

    protected void edit() {
        if (!this.editMode) {
            this.editMode = true;
            this.edited = new TreeMap<Integer, T>();
            this.deleted = new TreeSet<Integer>();
            this.byName = null;
            this.byNumber = null;
        }
    }

    public void consolidate() throws T2DBException {
        if (this.editMode) {
            for (Integer n : this.deleted) {
                this.components.remove(n);
            }
            for (Map.Entry entry : this.edited.entrySet()) {
                if (this.components.containsKey(entry.getKey())) {
                    ((SchemaComponent)this.components.get(entry.getKey())).edit((SchemaComponent)entry.getValue());
                    continue;
                }
                ((SchemaComponent)entry.getValue()).consolidate();
                this.components.put((Integer)entry.getKey(), (T)entry.getValue());
            }
            this.clearUpdates();
            this.editMode = false;
            this.checkUniqueNames(this.components.values());
            this.makeIndexes();
        }
    }

    private void checkUniqueNames(Collection<T> components) throws T2DBException {
        HashSet<String> names = new HashSet<String>(components.size());
        for (SchemaComponent compo : components) {
            if (names.add(compo.getName())) continue;
            throw T2DBMsg.exception("D30130", compo.getName());
        }
    }

    private void makeNumberIndex(Collection<T> components, int maxRange, T[] template) {
        this.byNumber = null;
        if (maxRange > -1) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (SchemaComponent component : components) {
                min = Math.min(min, component.getNumber());
                max = Math.max(max, component.getNumber());
            }
            int range = max - min + 1;
            if (range <= maxRange) {
                this.byNumberBase = min;
                ArrayList<SchemaComponent> list = new ArrayList<SchemaComponent>(range);
                for (int i = 0; i < range; ++i) {
                    list.add(null);
                }
                for (SchemaComponent component : components) {
                    list.set(component.getNumber() - this.byNumberBase, component);
                }
                this.byNumber = (SchemaComponent[])list.toArray(template);
            }
        }
    }

    private void makeNameIndex(Collection<T> components, int threshold) {
        this.byName = null;
        if (threshold > -1 && components.size() > threshold && this.isComplete()) {
            this.byName = new HashMap<String, T>(components.size());
            for (SchemaComponent component : components) {
                String name = component.getName();
                if (name == null) {
                    throw new IllegalArgumentException("bug: " + component.getNumber());
                }
                this.byName.put(name, component);
            }
        }
    }

    private void makeIndexes() {
        this.makeNameIndex(this.components.values(), this.nameIndexThreshold);
        this.makeNumberIndex(this.components.values(), this.numberIndexMaxRange, (SchemaComponent[])this.template);
    }

    public String toString() {
        return this.components.values().toString();
    }
}

