/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.impl.DBObjectImpl;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.DatabaseMethods;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.PermissionChecker;
import ch.agent.crnickl.impl.SurrogateImpl;

public class DatabaseMethodsImpl
implements DatabaseMethods,
PermissionChecker {
    @Override
    public int getId(DBObject dBObject) {
        try {
            int id = ((SurrogateImpl)dBObject.getSurrogate()).getId();
            if (id < 1) {
                throw new RuntimeException("bug (database integrity violation)");
            }
            return id;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("bug: " + dBObject.toString(), e);
        }
    }

    @Override
    public int getIdOrZero(DBObject dBObject) {
        try {
            SurrogateImpl key;
            int id = 0;
            if (dBObject != null && !(key = (SurrogateImpl)dBObject.getSurrogate()).inConstruction() && (id = key.getId().intValue()) < 1) {
                throw new RuntimeException("bug (database integrity violation)");
            }
            return id;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("bug: " + dBObject.toString(), e);
        }
    }

    @Override
    public int getId(Surrogate surrogate) {
        try {
            int id = ((SurrogateImpl)surrogate).getId();
            if (id < 1) {
                throw new RuntimeException("bug (database integrity violation)");
            }
            return id;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("bug: " + ((Object)surrogate).toString(), e);
        }
    }

    @Override
    public Surrogate makeSurrogate(Database db, DBObjectType dot, int id) {
        return new SurrogateImpl((DatabaseBackend)db, dot, id);
    }

    @Override
    public Surrogate makeSurrogate(DBObject dBObject, int id) {
        Surrogate s = dBObject.getSurrogate();
        return this.makeSurrogate(s.getDatabase(), s.getDBObjectType(), id);
    }

    @Override
    public boolean check(Permission permission, DBObject dBObject, boolean permissionRequired) throws T2DBException {
        return ((DBObjectImpl)dBObject).getDatabase().check(permission, dBObject, permissionRequired);
    }

    @Override
    public void check(Permission permission, DBObject dBObject) throws T2DBException {
        ((DBObjectImpl)dBObject).getDatabase().check(permission, dBObject);
    }

    @Override
    public boolean check(Permission permission, Surrogate surrogate, boolean permissionRequired) throws T2DBException {
        return ((DatabaseBackend)surrogate.getDatabase()).check(permission, surrogate, permissionRequired);
    }

    @Override
    public void check(Permission permission, Surrogate surrogate) throws T2DBException {
        ((DatabaseBackend)surrogate.getDatabase()).check(permission, surrogate);
    }
}

