/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.MessageListener;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.impl.AttributeDefinitionImpl;
import ch.agent.crnickl.impl.ChronicleImpl;
import ch.agent.crnickl.impl.DatabaseCache;
import ch.agent.crnickl.impl.PropertyImpl;
import ch.agent.crnickl.impl.SchemaImpl;
import ch.agent.crnickl.impl.SeriesDefinitionImpl;
import ch.agent.crnickl.impl.SurrogateImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class DatabaseCacheImpl
implements DatabaseCache {
    private int capacity;
    private int removedTotal;
    private int removedTotalThreshold = 1;
    private Map<Object, ChronicleImpl> byIdCache;
    private Map<String, ChronicleImpl> byNameCache;
    private Map<Object, SchemaRefCounter> schemaCache;
    private Map<Object, PropertyRefCounter> propCache;
    private MessageListener messageListener;

    public DatabaseCacheImpl(int capacity, float loadFactor) {
        this.capacity = capacity;
        this.byIdCache = Collections.synchronizedMap(new ChronicleCache(capacity, loadFactor, this));
        this.byNameCache = Collections.synchronizedMap(new HashMap());
        this.schemaCache = Collections.synchronizedMap(new HashMap());
        this.propCache = Collections.synchronizedMap(new HashMap());
    }

    public DatabaseCacheImpl(int capacity) {
        this(capacity, 0.75f);
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    @Override
    public ChronicleImpl lookUpChronicle(Surrogate surrogate) {
        return this.byIdCache.get(((SurrogateImpl)surrogate).getId());
    }

    @Override
    public ChronicleImpl lookUpChronicle(String name) {
        return this.byNameCache.get(name);
    }

    @Override
    public ChronicleImpl store(ChronicleImpl entity) throws T2DBException {
        ChronicleImpl copy = null;
        if (!entity.isTopChronicle() && this.lookUpChronicle(entity.getSurrogate()) == null) {
            Schema schema = entity.getSchema(false);
            schema = this.ref((SchemaImpl)schema);
            copy = new ChronicleImpl(entity.getName(false), entity.getDescription(false), entity.getCollection(), schema, entity.getSurrogate());
            this.put(copy);
        }
        return copy;
    }

    private void remove(ChronicleImpl entity) {
        try {
            Schema schema = entity.getSchema(false);
            if (schema != null) {
                this.unRef((SchemaImpl)schema);
            }
            this.byNameCache.remove(entity.getName(true));
        }
        catch (T2DBException e) {
            throw new RuntimeException("bug", (Throwable)((Object)e));
        }
    }

    private void put(ChronicleImpl entity) {
        try {
            this.byIdCache.put(((SurrogateImpl)entity.getSurrogate()).getId(), entity);
            this.byNameCache.put(entity.getName(true), entity);
        }
        catch (T2DBException e) {
            throw new RuntimeException("bug", (Throwable)((Object)e));
        }
    }

    @Override
    public int size() {
        return this.byIdCache.size();
    }

    private void removed(ChronicleImpl chronicle) {
        this.remove(chronicle);
        ++this.removedTotal;
        if (this.removedTotal % this.removedTotalThreshold == 0) {
            this.message(Level.WARNING, new T2DBMsg("D00121", this.capacity, this.removedTotal, chronicle.toString()).toString());
            if (this.removedTotalThreshold < 100000 && this.removedTotal >= this.removedTotalThreshold * 10) {
                this.removedTotalThreshold *= 10;
            }
        }
    }

    private SchemaImpl ref(SchemaImpl schema) {
        SchemaImpl esh = null;
        if (schema != null) {
            Integer id = ((SurrogateImpl)schema.getSurrogate()).getId();
            SchemaRefCounter ref = this.schemaCache.get(id);
            if (ref == null) {
                try {
                    Collection<AttributeDefinition<?>> defCopies = this.ref1(schema.getAttributeDefinitions());
                    Collection<SeriesDefinition> ssCopies = this.ref2(schema.getSeriesDefinitions());
                    esh = new SchemaImpl(schema.getName(), defCopies, ssCopies, schema.getSurrogate(), schema.getDependencyList());
                }
                catch (T2DBException e) {
                    throw new RuntimeException("bug", (Throwable)((Object)e));
                }
                this.schemaCache.put(id, new SchemaRefCounter(esh));
            } else {
                esh = ref.schema;
                ref.incr();
            }
        }
        return esh;
    }

    private Collection<AttributeDefinition<?>> ref1(Collection<AttributeDefinition<?>> defs) throws T2DBException {
        ArrayList defCopies = new ArrayList();
        for (AttributeDefinition<?> def : defs) {
            AttributeDefinitionImpl defCopy = new AttributeDefinitionImpl(def.getNumber(), this.ref((PropertyImpl)def.getProperty()), def.getValue());
            defCopies.add(defCopy);
        }
        return defCopies;
    }

    private Collection<SeriesDefinition> ref2(Collection<SeriesDefinition> sss) throws T2DBException {
        ArrayList<SeriesDefinition> ssCopies = new ArrayList<SeriesDefinition>();
        for (SeriesDefinition ss : sss) {
            Collection<AttributeDefinition<?>> defCopies = this.ref1(ss.getAttributeDefinitions());
            SeriesDefinitionImpl ssCopy = new SeriesDefinitionImpl(ss.getNumber(), ss.getDescription(), defCopies);
            ssCopies.add(ssCopy);
        }
        return ssCopies;
    }

    private void unRef(SchemaImpl schema) {
        Integer id = ((SurrogateImpl)schema.getSurrogate()).getId();
        SchemaRefCounter ref = this.schemaCache.get(id);
        if (ref.decr() < 1) {
            this.schemaCache.remove(id);
            for (AttributeDefinition<?> def : schema.getAttributeDefinitions()) {
                this.unRef((PropertyImpl)def.getProperty());
            }
            for (SeriesDefinition ss : schema.getSeriesDefinitions()) {
                for (AttributeDefinition<?> def : ss.getAttributeDefinitions()) {
                    this.unRef((PropertyImpl)def.getProperty());
                }
            }
        }
    }

    private PropertyImpl<?> ref(PropertyImpl<?> property) {
        Integer id = ((SurrogateImpl)property.getSurrogate()).getId();
        PropertyRefCounter ref = this.propCache.get(id);
        PropertyImpl p = null;
        if (ref == null) {
            p = property;
            this.propCache.put(id, new PropertyRefCounter(p));
        } else {
            p = ref.property;
            ref.incr();
        }
        return p;
    }

    private void unRef(PropertyImpl<?> property) {
        Integer id = ((SurrogateImpl)property.getSurrogate()).getId();
        PropertyRefCounter ref = this.propCache.get(id);
        if (ref.decr() < 1) {
            this.propCache.remove(id);
        }
    }

    private void reset() {
        this.byNameCache.clear();
        this.byIdCache.clear();
        this.schemaCache.clear();
        this.propCache.clear();
    }

    @Override
    public void clear() {
        this.reset();
    }

    @Override
    public void clear(Chronicle chronicle) {
        ChronicleImpl e;
        Integer id = ((SurrogateImpl)chronicle.getSurrogate()).getId();
        if (id != 0 && (e = this.byIdCache.remove(id)) != null) {
            this.remove(e);
        }
    }

    @Override
    public void clear(Schema schema) {
        if (this.schemaCache.get(((SurrogateImpl)schema.getSurrogate()).getId()) != null) {
            this.clear();
        }
    }

    @Override
    public void clear(Property<?> property) {
        if (this.propCache.get(((SurrogateImpl)property.getSurrogate()).getId()) != null) {
            this.clear();
        }
    }

    private void message(Level level, String text) {
        if (this.messageListener != null && this.messageListener.isListened(level)) {
            this.messageListener.log(level, text);
        }
    }

    protected class ChronicleCache
    extends LinkedHashMap<Object, ChronicleImpl> {
        private int capacity;
        private DatabaseCacheImpl callback;

        public ChronicleCache(int capacity, float loadFactor, DatabaseCacheImpl callback) {
            super((int)Math.ceil((float)capacity / loadFactor), loadFactor, true);
            this.capacity = capacity;
            this.callback = callback;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, ChronicleImpl> eldest) {
            if (this.size() > this.capacity) {
                this.callback.removed(eldest.getValue());
                return true;
            }
            return false;
        }
    }

    private class PropertyRefCounter
    extends RefCounter {
        private PropertyImpl<?> property;

        public PropertyRefCounter(PropertyImpl<?> property) {
            this.property = property;
        }
    }

    private class SchemaRefCounter
    extends RefCounter {
        private SchemaImpl schema;

        public SchemaRefCounter(SchemaImpl schema) {
            this.schema = schema;
        }
    }

    private abstract class RefCounter {
        private int refCount = 1;

        public void incr() {
            ++this.refCount;
        }

        public int decr() {
            return --this.refCount;
        }
    }
}

