/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.SeriesDefinition;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.impl.DBObjectImpl;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.DatabaseCache;
import ch.agent.crnickl.impl.UpdatableChronicleImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChronicleImpl
extends DBObjectImpl
implements Chronicle {
    private Data data;

    public ChronicleImpl(Surrogate surrogate) {
        super(surrogate);
    }

    protected ChronicleImpl(String name, String description, Chronicle parent, Schema schema, Surrogate surrogate) {
        this(surrogate);
        this.data = new Data();
        this.data.name = name;
        this.data.description = description;
        this.data.collection = parent;
        this.data.schema = schema;
    }

    public ChronicleImpl(RawData rawData) throws T2DBException {
        super(rawData.getSurrogate());
        Schema schema = null;
        if (rawData.getSchema() != null) {
            schema = this.getDatabase().getSchema(rawData.getSchema());
        }
        this.data = new Data();
        this.data.name = rawData.getName();
        this.data.description = rawData.getDescription();
        this.data.collection = rawData.getCollection();
        this.data.schema = schema;
    }

    private void getData() throws T2DBException {
        if (this.data == null) {
            ChronicleImpl e;
            DatabaseBackend d = this.getDatabase();
            DatabaseCache c = d.getCache();
            ChronicleImpl chronicleImpl = e = c == null ? null : c.lookUpChronicle(this.getSurrogate());
            if (e != null) {
                this.data = e.data;
            } else {
                Chronicle chronicle = d.getChronicle(this);
                this.data = ((ChronicleImpl)chronicle).data;
                if (c != null && this.data.collection != null) {
                    c.store((ChronicleImpl)this.data.collection);
                }
            }
        }
    }

    @Override
    public Chronicle getChronicle(String simpleName, boolean mustExist) throws T2DBException {
        Chronicle chronicle = this.getDatabase().getChronicleOrNull(this, simpleName);
        if (chronicle == null && mustExist) {
            throw T2DBMsg.exception("D40102", this.getName(true), simpleName);
        }
        return chronicle;
    }

    @Override
    public Chronicle findChronicle(String fullName, boolean mustExist) throws T2DBException {
        DatabaseCache cache = this.getDatabase().getCache();
        Chronicle chronicle = cache.lookUpChronicle(fullName);
        if (chronicle == null) {
            String[] parts = this.getDatabase().getNamingPolicy().split(fullName);
            if (parts[0] == null) {
                chronicle = this.getDatabase().getTopChronicle();
                boolean isNameSpace = chronicle.getName(true).equals(fullName);
                if (this.getDatabase().isStrictNameSpaceMode()) {
                    if (!isNameSpace) {
                        throw T2DBMsg.exception("D40103", chronicle.getName(true), fullName);
                    }
                } else if (!isNameSpace && (chronicle = chronicle.getChronicle(parts[1], mustExist)) != null) {
                    cache.store((ChronicleImpl)chronicle);
                }
            } else {
                chronicle = this.findChronicle(parts[0], true);
                cache.store((ChronicleImpl)chronicle);
                chronicle = chronicle.getChronicle(parts[1], mustExist);
            }
        }
        return chronicle;
    }

    @Override
    public boolean isTopChronicle() {
        return false;
    }

    @Override
    public UpdatableChronicle edit() {
        UpdatableChronicleImpl u = new UpdatableChronicleImpl(this.getSurrogate());
        if (this.data != null) {
            u.data = this.data;
            u.data.name = this.data.name;
            u.data.description = this.data.description;
            u.data.collection = this.data.collection;
            u.data.schema = this.data.schema;
        }
        return u;
    }

    protected void update() {
        this.data = null;
    }

    @Override
    public Chronicle getCollection() throws T2DBException {
        this.getData();
        return this.data.collection;
    }

    @Override
    public Collection<Chronicle> getMembers() throws T2DBException {
        return this.getDatabase().getChroniclesByParent(this);
    }

    @Override
    public Schema getSchema(boolean effective) throws T2DBException {
        Chronicle c;
        this.getData();
        Schema es = this.data.schema;
        if (effective && es == null && (c = this.getCollection()) != null) {
            es = c.getSchema(effective);
        }
        return es;
    }

    @Override
    public String getName(boolean full) throws T2DBException {
        if (full) {
            return this.getDatabase().getNamingPolicy().fullName(this.getNames());
        }
        this.getData();
        return this.data.name;
    }

    @Override
    public List<String> getNames() throws T2DBException {
        List<String> names = null;
        Chronicle collection = this.getCollection();
        if (collection != null) {
            names = collection.getNames();
        } else {
            names = new ArrayList<String>();
            names.add(this.getDatabase().getTopChronicle().getName(false));
        }
        names.add(this.getName(false));
        return names;
    }

    @Override
    public String getDescription(boolean full) throws T2DBException {
        if (full) {
            return this.getDatabase().getNamingPolicy().fullDescription(this.getDescriptions());
        }
        this.getData();
        return this.data.description;
    }

    @Override
    public List<String> getDescriptions() throws T2DBException {
        List<String> descriptions = null;
        Chronicle collection = this.getCollection();
        if (collection != null) {
            descriptions = collection.getDescriptions();
        } else {
            descriptions = new ArrayList<String>();
            descriptions.add(this.getDatabase().getTopChronicle().getDescription(false));
        }
        descriptions.add(this.getDescription(false));
        return descriptions;
    }

    @Override
    public Attribute<?> getAttribute(String attrName, boolean mustExist) throws T2DBException {
        Attribute<?> attribute = null;
        Schema esch = this.getSchema(true);
        if (esch == null) {
            if (mustExist) {
                throw T2DBMsg.exception("D40114", this.getName(true));
            }
        } else {
            AttributeDefinition<?> def = esch.getAttributeDefinition(attrName, mustExist);
            if (def != null) {
                attribute = def.getAttribute();
                List<Chronicle> chronicles = new ArrayList();
                int lastChronicleWithSchema = 0;
                for (Chronicle chronicle = this; chronicle != null && !chronicle.isTopChronicle(); chronicle = chronicle.getCollection()) {
                    Schema sch = chronicle.getSchema(false);
                    if (sch != null) {
                        if (sch.getAttributeDefinition(def.getNumber(), false) == null) break;
                        lastChronicleWithSchema = chronicles.size();
                    }
                    chronicles.add(chronicle);
                }
                chronicles = chronicles.subList(0, lastChronicleWithSchema + 1);
                this.getDatabase().getAttributeValue(chronicles, attribute);
            }
        }
        return attribute;
    }

    @Override
    public <T> Series<T> getSeries(String name) throws T2DBException {
        Series<T>[] s = this.getSeries(new String[]{name}, null, true);
        return s[0];
    }

    @Override
    public <T> Series<T>[] getSeries(String[] names, Class<T> type, boolean mustBeDefined) throws T2DBException {
        int[] seriesNr = new int[names.length];
        Schema es = this.getSchema(true);
        if (es == null) {
            throw T2DBMsg.exception("D40114", this.getName(true));
        }
        for (int i = 0; i < names.length; ++i) {
            SeriesDefinition ss = es.getSeriesDefinition(names[i], mustBeDefined);
            seriesNr[i] = ss == null ? 0 : ss.getNumber();
        }
        Series<T>[] series = this.getDatabase().getSeries(this, names, seriesNr);
        if (type != null) {
            for (Series s : series) {
                if (s == null) continue;
                s.typeCheck(type);
            }
        }
        return series;
    }

    @Override
    public Collection<Attribute<?>> getAttributes() throws T2DBException {
        ArrayList result = new ArrayList();
        Schema schema = this.getSchema(true);
        if (schema != null) {
            Collection<AttributeDefinition<?>> defs = schema.getAttributeDefinitions();
            for (AttributeDefinition<?> def : defs) {
                if (!def.isComplete()) {
                    throw T2DBMsg.exception("D40115", this.getName(true), def.getNumber());
                }
                result.add(this.getAttribute(def.getName(), true));
            }
        }
        return result;
    }

    @Override
    public Collection<Series<?>> getSeries() throws T2DBException {
        ArrayList result = new ArrayList();
        Schema schema = this.getSchema(true);
        if (schema != null) {
            Series<T>[] allSeries;
            Collection<SeriesDefinition> sss = schema.getSeriesDefinitions();
            String[] names = new String[sss.size()];
            int i = 0;
            for (SeriesDefinition ss : sss) {
                names[i++] = ss.getName();
            }
            for (Series s : allSeries = this.getSeries(names, null, true)) {
                if (s == null) continue;
                result.add(s);
            }
        }
        return result;
    }

    @Override
    public boolean isMemberOf(Chronicle collection) throws T2DBException {
        if (this.equals(collection)) {
            return true;
        }
        if (this.isTopChronicle()) {
            return false;
        }
        return ((ChronicleImpl)this.getCollection()).isMemberOf(collection);
    }

    public String toString() {
        try {
            return this.getName(true);
        }
        catch (T2DBException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    private class Data {
        private String name;
        private String description;
        private Chronicle collection;
        private Schema schema;

        private Data() {
        }
    }

    public static class RawData {
        private Surrogate surrogate;
        private String name;
        private String description;
        private Chronicle collection;
        private Surrogate schema;

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setSurrogate(Surrogate surrogate) {
            this.surrogate = surrogate;
        }

        public void setCollection(Chronicle collection) {
            this.collection = collection;
        }

        public void setSchema(Surrogate schema) {
            this.schema = schema;
        }

        public Surrogate getSurrogate() {
            return this.surrogate;
        }

        public Chronicle getCollection() {
            return this.collection;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Surrogate getSchema() {
            return this.schema;
        }
    }
}

