/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.AttributeDefinitionImpl;

public class AttributeImpl<T>
implements Attribute<T> {
    private AttributeDefinitionImpl<T> definition;
    private T value;
    private String description;

    public AttributeImpl(AttributeDefinitionImpl<T> attributeDefinition) {
        if (attributeDefinition == null) {
            throw new IllegalArgumentException("attributeDefinition null");
        }
        this.definition = attributeDefinition;
        this.value = attributeDefinition.getValue();
    }

    @Override
    public Property<T> getProperty() {
        return this.definition.getProperty();
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = this.definition.getValue();
    }

    @Override
    public void set(T value) throws T2DBException {
        this.definition.getProperty().check(value);
        this.value = value;
    }

    @Override
    public void scan(Object value) throws T2DBException {
        if (value == null) {
            this.set(null);
        } else {
            ValueType<T> vt = this.definition.getProperty().getValueType();
            if (vt.isCompatible(value)) {
                this.set(value);
            } else if (value instanceof String) {
                this.set(vt.scan((String)value));
            } else {
                throw T2DBMsg.exception("D10114", value, vt.getType().getName());
            }
        }
    }

    @Override
    public String getDescription(boolean effective) {
        ValueType<T> vt;
        String result = this.description;
        if (result == null && effective && (vt = this.getProperty().getValueType()).isRestricted()) {
            result = vt.getValueDescriptions().get(this.value);
        }
        return result;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public <S> Attribute<S> typeCheck(Class<S> type) throws T2DBException {
        this.getProperty().typeCheck(type);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeImpl other = (AttributeImpl)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        try {
            return this.getProperty().getName() + "=" + (this.value == null ? null : this.definition.getProperty().getValueType().toString(this.value));
        }
        catch (T2DBException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }
}

