/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.SchemaComponent;
import ch.agent.crnickl.impl.AttributeImpl;

public class AttributeDefinitionImpl<T>
implements AttributeDefinition<T>,
SchemaComponent {
    private boolean editMode;
    private boolean erasing;
    private int number;
    private Property<T> property;
    private Object value;
    private boolean valueSet;

    public AttributeDefinitionImpl(int number, Property<T> property, T value) throws T2DBException {
        if (number < 1) {
            throw T2DBMsg.exception("D30117", new Object[0]);
        }
        this.number = number;
        this.property = property;
        if (value != null) {
            this.getProperty().getValueType().check(value);
        }
        this.value = value;
    }

    @Override
    public boolean isComplete() {
        return !this.erasing && this.property != null;
    }

    @Override
    public boolean isErasing() {
        return this.erasing;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public Property<T> getProperty() {
        return this.property;
    }

    @Override
    public String getName() {
        return this.property == null ? null : this.property.getName();
    }

    @Override
    public T getValue() {
        return (T)this.value;
    }

    @Override
    public Attribute<T> getAttribute() {
        if (!this.isComplete()) {
            throw new IllegalStateException();
        }
        return new AttributeImpl(this);
    }

    public String toString() {
        return this.property == null ? "" + this.number : this.property.getName() + " " + this.value;
    }

    @Override
    public int compareTo(AttributeDefinition<T> o) {
        if (this.getNumber() > o.getNumber()) {
            return 1;
        }
        if (this.getNumber() < o.getNumber()) {
            return -1;
        }
        return 0;
    }

    public void setErasing(boolean erasing) {
        this.checkEdit();
        this.erasing = erasing;
    }

    public void setProperty(Property<T> property) throws T2DBException {
        this.checkEdit();
        this.property = property;
        try {
            this.checkType();
        }
        catch (T2DBException e) {
            throw T2DBMsg.exception((Throwable)((Object)e), "D30133", this.getValue(), this.getNumber(), property);
        }
    }

    public void setValue(Object value) throws T2DBException {
        this.checkEdit();
        this.value = value;
        this.valueSet = true;
        this.checkType();
    }

    public boolean isValueSet() {
        return this.valueSet;
    }

    @Override
    public void edit() {
        this.editMode = true;
    }

    @Override
    public void edit(SchemaComponent component) {
        if (!(component instanceof AttributeDefinition)) {
            throw new IllegalArgumentException(component == null ? null : component.getClass().getName());
        }
        AttributeDefinition arg = (AttributeDefinition)component;
        if (arg.isErasing()) {
            this.erasing = true;
        } else {
            if (arg.getProperty() != null) {
                this.property = arg.getProperty();
            }
            if (arg.getValue() != null) {
                this.value = arg.getValue();
            }
        }
    }

    @Override
    public void consolidate() throws T2DBException {
    }

    private void checkEdit() {
        if (!this.editMode) {
            throw new IllegalStateException();
        }
    }

    private void checkType() throws T2DBException {
        if (this.property != null && this.value != null) {
            if (!this.property.getValueType().isCompatible(this.value)) {
                if (this.value instanceof String) {
                    this.value = this.property.getValueType().scan((String)this.value);
                } else {
                    throw T2DBMsg.exception("D30132", this.value, this.property, this.property.getValueType());
                }
            }
            this.property.getValueType().check(this.value);
        }
    }

    @Override
    public <S> AttributeDefinition<S> typeCheck(Class<S> type) throws T2DBException {
        this.getProperty().typeCheck(type);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.erasing ? 1231 : 1237);
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeDefinitionImpl other = (AttributeDefinitionImpl)obj;
        if (this.erasing != other.erasing) {
            return false;
        }
        if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

