/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableProperty;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.junit.AbstractTest;
import ch.agent.crnickl.junit.Util;
import ch.agent.t2.time.Day;
import java.util.List;

public class T060_ByAttributeValueTest
extends AbstractTest {
    private static DatabaseBackend db;

    @Override
    protected void firstSetUp() throws Exception {
        db = (DatabaseBackend)this.getContext().getDatabase();
        this.setup1();
        this.setup2();
    }

    @Override
    protected void lastTearDown() throws Exception {
        Util.deleteChronicles((Database)db, "bt.sm");
        Util.deleteSchema((Database)db, "Stocks");
        Util.deleteProperties((Database)db, "Ticker");
        Util.deleteValueTypes((Database)db, "Ticker");
    }

    private void setup1() throws Exception {
        UpdatableValueType vt = db.createValueType("Ticker", false, "TEXT");
        vt.applyUpdates();
        UpdatableProperty p = db.createProperty("Ticker", (ValueType)vt, true);
        p.applyUpdates();
        UpdatableSchema schema = db.createSchema("Stocks", null);
        schema.addAttribute(2);
        schema.setAttributeProperty(2, (Property)p);
        schema.addSeries(1);
        schema.setSeriesName(1, "price");
        schema.setSeriesType(1, "numeric");
        schema.setSeriesTimeDomain(1, Day.DOMAIN);
        schema.applyUpdates();
        db.commit();
    }

    private void setup2() throws Exception {
        Schema stocks = (Schema)db.getSchemas("Stocks").iterator().next();
        UpdatableChronicle sm = db.getTopChronicle().edit().createChronicle("sm", false, "Stock markets", null, stocks);
        sm.applyUpdates();
        UpdatableChronicle ch = sm.createChronicle("ch", false, "CH", null, null);
        ch.applyUpdates();
        UpdatableChronicle chsun = ch.createChronicle("sunxyzzy", false, "ch's sun xyzzy", null, null);
        Attribute ticker = chsun.getAttribute("Ticker", true);
        ticker.scan((Object)"SUN");
        chsun.setAttribute(ticker);
        chsun.applyUpdates();
        UpdatableChronicle us = sm.createChronicle("us", false, "US", null, null);
        us.applyUpdates();
        UpdatableChronicle ussun = us.createChronicle("sungobdigook", false, "us's sun gobbledygook", null, null);
        ussun.setAttribute(ticker);
        ussun.applyUpdates();
        UpdatableChronicle ussun2 = us.createChronicle("sunco", false, "another us sun", null, null);
        ticker.scan((Object)"SUN2");
        ussun2.setAttribute(ticker);
        ussun2.applyUpdates();
        db.commit();
    }

    public void testGetByAttributeValue() {
        try {
            Property ticker = db.getProperty("Ticker", true);
            List result = ticker.getChronicles(ticker.scan("SUN"), 42);
            T060_ByAttributeValueTest.assertEquals((int)2, (int)result.size());
        }
        catch (Exception e) {
            T060_ByAttributeValueTest.fail((String)e.getMessage());
        }
    }

    public <T> void testDeleteAttributeValue() {
        try {
            UpdatableChronicle ussun2 = db.getChronicle("bt.sm.us.sunco", true).edit();
            Attribute ticker = ussun2.getAttribute("Ticker", true).typeCheck(String.class);
            Property tickerProp = ticker.getProperty();
            List result = tickerProp.getChronicles(tickerProp.scan("SUN2"), 42);
            T060_ByAttributeValueTest.assertEquals((int)1, (int)result.size());
            T060_ByAttributeValueTest.assertEquals((String)"SUN2", (String)((String)ticker.get()).toString());
            ticker.set(null);
            ussun2.setAttribute(ticker);
            T060_ByAttributeValueTest.assertEquals(null, (String)((String)ticker.get()));
            ussun2.applyUpdates();
            db.commit();
            result = tickerProp.getChronicles(tickerProp.scan("SUN2"), 42);
            T060_ByAttributeValueTest.assertEquals((int)0, (int)result.size());
        }
        catch (Exception e) {
            T060_ByAttributeValueTest.fail((String)e.getMessage());
        }
    }
}

