/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdateEvent;
import ch.agent.crnickl.api.UpdateEventSubscriber;
import ch.agent.crnickl.junit.AbstractTest;
import ch.agent.crnickl.junit.Util;

public class T045_EventTest
extends AbstractTest {
    private static final String FULLNAME = "bt.entity";
    private static final String SIMPLENAME = "entity";
    private static Database db;
    private static EventTester tester;

    @Override
    protected void firstSetUp() throws Exception {
        db = this.getContext().getDatabase();
        tester = new EventTester();
        db.getUpdateEventPublisher().subscribe((UpdateEventSubscriber)tester, DBObjectType.CHRONICLE, false);
    }

    @Override
    protected void lastTearDown() throws Exception {
        Util.deleteChronicles(db, FULLNAME);
    }

    public void test001() {
        try {
            UpdatableChronicle e = db.getTopChronicle().edit().createChronicle(SIMPLENAME, false, "junit test 001", null, null);
            T045_EventTest.assertEquals((String)FULLNAME, (String)e.getName(true));
            e.applyUpdates();
            db.commit();
            T045_EventTest.assertEquals((String)FULLNAME, (String)((Chronicle)tester.getEvent().getSourceOrNull()).getName(true));
        }
        catch (T2DBException e) {
            T045_EventTest.fail((String)e.toString());
        }
    }

    public void test002() {
        try {
            UpdatableChronicle e = db.getChronicle(FULLNAME, true).edit();
            e.destroy();
            e.applyUpdates();
            db.commit();
            T045_EventTest.assertEquals((String)db.getNamingPolicy().joinValueAndDescription(FULLNAME, "junit test 001"), (String)tester.getEvent().getComment());
        }
        catch (Exception e) {
            T045_EventTest.fail((String)e.toString());
        }
    }

    private class EventTester
    implements UpdateEventSubscriber {
        private UpdateEvent event;

        private EventTester() {
        }

        public void notify(UpdateEvent event) {
            this.event = event;
        }

        public UpdateEvent getEvent() {
            return this.event;
        }
    }
}

