/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.junit.AbstractTest;
import ch.agent.crnickl.junit.Util;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.timeseries.RegularTimeSeries;
import ch.agent.t2.timeseries.TimeAddressable;

public class T041_UpdatableSeriesTest
extends AbstractTest {
    private static Database db;
    private static final String SERIES = "bt.t040.test";

    @Override
    protected void firstSetUp() throws Exception {
        db = this.getContext().getDatabase();
        UpdatableSchema s = db.createSchema("t040", null);
        s.addSeries(1);
        s.setSeriesName(1, "test");
        s.setSeriesType(1, "numeric");
        s.setSeriesTimeDomain(1, Day.DOMAIN);
        s.applyUpdates();
        String[] split = db.getNamingPolicy().split("bt.t040");
        UpdatableChronicle c = db.getTopChronicle().edit().createChronicle(split[1], false, "test entity", null, s.resolve());
        c.applyUpdates();
        db.commit();
    }

    @Override
    protected void lastTearDown() throws Exception {
        Util.deleteChronicles(db, "bt.t040");
        Util.deleteSchema(db, "t040");
        db.commit();
    }

    public void testCreateSeries() {
        try {
            TimeDomain dom = Day.DOMAIN;
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            RegularTimeSeries ts = new RegularTimeSeries(Double.class, dom);
            ts.put(dom.time("2011-05-01"), (Object)201105.01);
            ts.put(dom.time("2011-05-02"), (Object)201105.02);
            ts.put(dom.time("2011-06-01"), (Object)201106.01);
            ts.put(dom.time("2011-06-30"), (Object)201106.3);
            ts.put(dom.time("2011-07-01"), (Object)201107.01);
            s.setValues((TimeAddressable)ts);
            s.applyUpdates();
            T041_UpdatableSeriesTest.assertEquals((String)"[2011-05-01, 2011-07-01]", (String)s.getRange().toString());
        }
        catch (Exception e) {
            T041_UpdatableSeriesTest.fail((String)e.toString());
        }
    }

    public void testGetSeries01() {
        try {
            Series s = db.getSeries(SERIES, true).typeCheck(Double.class);
            T041_UpdatableSeriesTest.assertEquals((Object)201105.01, (Object)s.getFirstObservation(Day.DOMAIN.time("2011-01-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201106.01, (Object)s.getFirstObservation(Day.DOMAIN.time("2011-05-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201106.01, (Object)s.getLastObservation(Day.DOMAIN.time("2011-06-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201107.01, (Object)s.getLastObservation(Day.DOMAIN.time("2011-12-15")).getValue());
        }
        catch (Exception e) {
            T041_UpdatableSeriesTest.fail((String)e.toString());
        }
    }

    public void testGetSeries02() {
        try {
            UpdatableSeries s = db.getSeries(SERIES, true).typeCheck(Double.class).edit();
            T041_UpdatableSeriesTest.assertEquals((Object)201105.01, (Object)s.getFirstObservation(Day.DOMAIN.time("2011-01-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201106.01, (Object)s.getFirstObservation(Day.DOMAIN.time("2011-05-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201106.01, (Object)s.getLastObservation(Day.DOMAIN.time("2011-06-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201107.01, (Object)s.getLastObservation(Day.DOMAIN.time("2011-12-15")).getValue());
        }
        catch (Exception e) {
            T041_UpdatableSeriesTest.fail((String)e.toString());
        }
    }

    public void testGetSeries03a() {
        try {
            UpdatableSeries s = db.getSeries(SERIES, true).typeCheck(Double.class).edit();
            s.setValue(Day.DOMAIN.time("2011-03-01"), (Object)201103.01);
            s.setValue(Day.DOMAIN.time("2011-03-02"), (Object)201103.02);
            s.setValue(Day.DOMAIN.time("2011-08-01"), (Object)201108.01);
            s.setValue(Day.DOMAIN.time("2011-08-02"), (Object)201108.02);
            T041_UpdatableSeriesTest.assertEquals((String)"[2011-03-01, 2011-08-02]", (String)s.getValues(null).getRange().toString());
            T041_UpdatableSeriesTest.assertEquals((String)"[2011-03-01, 2011-08-02]", (String)s.getRange().toString());
        }
        catch (Exception e) {
            T041_UpdatableSeriesTest.fail((String)e.toString());
        }
    }

    public void testGetSeries03b() {
        try {
            UpdatableSeries s = db.getSeries(SERIES, true).typeCheck(Double.class).edit();
            s.setValue(Day.DOMAIN.time("2011-03-01"), (Object)201103.01);
            s.setValue(Day.DOMAIN.time("2011-03-02"), (Object)201103.02);
            s.setValue(Day.DOMAIN.time("2011-08-01"), (Object)201108.01);
            s.setValue(Day.DOMAIN.time("2011-08-02"), (Object)201108.02);
            T041_UpdatableSeriesTest.assertEquals((Object)201103.01, (Object)s.getFirstObservation(Day.DOMAIN.time("2011-01-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201106.01, (Object)s.getFirstObservation(Day.DOMAIN.time("2011-05-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201106.01, (Object)s.getLastObservation(Day.DOMAIN.time("2011-06-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201108.02, (Object)s.getLastObservation(Day.DOMAIN.time("2011-12-15")).getValue());
        }
        catch (Exception e) {
            T041_UpdatableSeriesTest.fail((String)e.toString());
        }
    }

    public void testGetSeries04() {
        try {
            UpdatableSeries s = db.getSeries(SERIES, true).typeCheck(Double.class).edit();
            s.setRange(new Range(Day.DOMAIN.time("2011-05-02"), Day.DOMAIN.time("2011-06-30")));
            T041_UpdatableSeriesTest.assertEquals((String)"[2011-05-02, 2011-06-30]", (String)s.getRange().toString());
        }
        catch (Exception e) {
            T041_UpdatableSeriesTest.fail((String)e.toString());
        }
    }

    public void testGetSeries05() {
        try {
            UpdatableSeries s = db.getSeries(SERIES, true).typeCheck(Double.class).edit();
            s.setValue(Day.DOMAIN.time("2011-05-01"), null);
            s.setValue(Day.DOMAIN.time("2011-07-01"), null);
            T041_UpdatableSeriesTest.assertEquals((String)"[2011-05-02, 2011-06-30]", (String)s.getRange().toString());
        }
        catch (Exception e) {
            T041_UpdatableSeriesTest.fail((String)e.toString());
        }
    }

    public void testGetSeries06() {
        try {
            UpdatableSeries s = db.getSeries(SERIES, true).typeCheck(Double.class).edit();
            s.setValue(Day.DOMAIN.time("2011-05-01"), null);
            s.setValue(Day.DOMAIN.time("2011-07-01"), null);
            T041_UpdatableSeriesTest.assertEquals((Object)201105.02, (Object)s.getFirstObservation(Day.DOMAIN.time("2011-01-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201106.01, (Object)s.getFirstObservation(Day.DOMAIN.time("2011-05-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201106.01, (Object)s.getLastObservation(Day.DOMAIN.time("2011-06-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201106.3, (Object)s.getLastObservation(Day.DOMAIN.time("2011-12-15")).getValue());
        }
        catch (Exception e) {
            T041_UpdatableSeriesTest.fail((String)e.toString());
        }
    }

    public void testGetSeries07() {
        try {
            UpdatableSeries s = db.getSeries(SERIES, true).typeCheck(Double.class).edit();
            s.setValue(Day.DOMAIN.time("2011-03-01"), (Object)201103.01);
            s.setValue(Day.DOMAIN.time("2011-03-02"), (Object)201103.02);
            s.setValue(Day.DOMAIN.time("2011-05-01"), null);
            s.setValue(Day.DOMAIN.time("2011-07-01"), null);
            s.setValue(Day.DOMAIN.time("2011-08-01"), (Object)201108.01);
            s.setValue(Day.DOMAIN.time("2011-08-02"), (Object)201108.02);
            T041_UpdatableSeriesTest.assertEquals((Object)201103.01, (Object)s.getFirstObservation(Day.DOMAIN.time("2011-01-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201105.02, (Object)s.getFirstObservation(Day.DOMAIN.time("2011-04-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201106.3, (Object)s.getLastObservation(Day.DOMAIN.time("2011-07-15")).getValue());
            T041_UpdatableSeriesTest.assertEquals((Object)201108.02, (Object)s.getLastObservation(Day.DOMAIN.time("2011-12-15")).getValue());
        }
        catch (Exception e) {
            T041_UpdatableSeriesTest.fail((String)e.toString());
        }
    }
}

