/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.junit.AbstractTest;
import ch.agent.crnickl.junit.Util;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeIndex;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class T040_SeriesTest
extends AbstractTest {
    private static Boolean DUMP = false;
    private static Database db;
    private static final String SCHEMA = "t040";
    private static final String CHRONICLE = "bt.t040";
    private static final String SERIES = "bt.t040.test";
    private static final String SERIES2 = "bt.t040.seriestest.test";

    @Override
    protected void firstSetUp() throws Exception {
        db = this.getContext().getDatabase();
        UpdatableSchema s = db.createSchema(SCHEMA, null);
        s.addSeries(1);
        s.setSeriesName(1, "test");
        s.setSeriesType(1, "numeric");
        s.setSeriesTimeDomain(1, Day.DOMAIN);
        s.applyUpdates();
        String[] split = db.getNamingPolicy().split(CHRONICLE);
        UpdatableChronicle c = db.getTopChronicle().edit().createChronicle(split[1], false, "test entity", null, s.resolve());
        c.applyUpdates();
        db.commit();
    }

    @Override
    protected void lastTearDown() throws Exception {
        Util.deleteChronicles(db, CHRONICLE);
        Util.deleteSchema(db, SCHEMA);
    }

    public void test_01() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            T040_SeriesTest.assertEquals((String)SERIES, (String)s.getName(true));
            T040_SeriesTest.assertTrue((boolean)s.getSurrogate().inConstruction());
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_02() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            s.scanValue(t, (Object)"42");
            T040_SeriesTest.assertEquals((Object)42.0, (Object)s.getValue(t));
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_03() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            T040_SeriesTest.assertEquals((Object)Double.NaN, (Object)s.getValue(t));
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_04() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            s.scanValue(t, (Object)"42");
            s.applyUpdates();
            T040_SeriesTest.assertEquals((Object)42.0, (Object)s.getValue(t));
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_05() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            T040_SeriesTest.assertEquals((Object)42.0, (Object)s.getValue(t));
            T040_SeriesTest.assertFalse((boolean)s.getSurrogate().inConstruction());
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_06() {
        try {
            if (this.getContext().isTransactional()) {
                db.rollback();
                UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
                TimeIndex t = s.getTimeDomain().time("2011-03-08");
                T040_SeriesTest.assertEquals((Object)Double.NaN, (Object)s.getValue(t));
                T040_SeriesTest.assertTrue((boolean)s.getSurrogate().inConstruction());
            }
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_07() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            if (this.getContext().isTransactional()) {
                T040_SeriesTest.assertTrue((boolean)s.getSurrogate().inConstruction());
            }
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            s.scanValue(t, (Object)"42");
            T040_SeriesTest.assertEquals((Object)42.0, (Object)s.getValue(t));
            s.applyUpdates();
            db.commit();
            T040_SeriesTest.assertEquals((Object)42.0, (Object)s.getValue(t));
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_08() {
        try {
            db.rollback();
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            T040_SeriesTest.assertEquals((Object)42.0, (Object)s.getValue(t));
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_09() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            s.setRange(null);
            s.applyUpdates();
            s.destroy();
            s.applyUpdates();
            T040_SeriesTest.assertFalse((boolean)s.getSurrogate().getObject().isValid());
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_10() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            s.scanValue(t, (Object)"42");
            s.applyUpdates();
            ((UpdatableChronicle)s.getChronicle()).applyUpdates();
            T040_SeriesTest.assertEquals((Object)42.0, (Object)s.getValue(t));
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_11() {
        try {
            String[] split = db.getNamingPolicy().split(SERIES2);
            UpdatableChronicle testEntity = ((UpdatableChronicle)db.getTopChronicle()).createChronicle(split[0], false, "test 2", null, null);
            testEntity.createSeries(split[1]).typeCheck(Double.class);
            T040_SeriesTest.expectException();
        }
        catch (Exception e) {
            T040_SeriesTest.assertException(e, "D01104");
        }
    }

    public void test_12() {
        try {
            db.getUpdatableSeries(SERIES2, true).typeCheck(Double.class);
            T040_SeriesTest.expectException();
        }
        catch (Exception e) {
            T040_SeriesTest.assertException(e, "D40102");
        }
    }

    public void test_13() {
        try {
            Series[] s = db.getChronicle(CHRONICLE, true).getSeries(new String[]{"test"}, null, true);
            T040_SeriesTest.assertEquals(Double.class, (Object)s[0].getValueType().getType());
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_14() {
        try {
            Chronicle chronicle = db.getChronicle(CHRONICLE, true);
            Series[] s = chronicle.getSeries(new String[]{"test"}, String.class, true);
            T040_SeriesTest.assertEquals(Double.class, (Object)s[0].getValueType().getType());
            T040_SeriesTest.expectException();
        }
        catch (Exception e) {
            T040_SeriesTest.assertException(e, "D50101");
        }
    }

    public void test_15() {
        try {
            Chronicle chronicle = db.getChronicle(CHRONICLE, true);
            Series[] s = chronicle.getSeries(new String[]{"test"}, Double.class, true);
            T040_SeriesTest.assertEquals(Double.class, (Object)s[0].getValueType().getType());
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_20() {
        try {
            Chronicle chronicle = db.getChronicle(CHRONICLE, true);
            T040_SeriesTest.assertEquals((int)1, (int)chronicle.getSchema(true).getSeriesDefinitions().size());
            Schema s0 = chronicle.getSchema(true);
            UpdatableSchema usch = s0.edit();
            usch.addSeries(4);
            usch.setSeriesName(4, "test4");
            usch.setSeriesType(4, "numeric");
            usch.setSeriesTimeDomain(4, Day.DOMAIN);
            T040_SeriesTest.assertEquals((int)2, (int)usch.getSeriesDefinitions().size());
            usch.applyUpdates();
            T040_SeriesTest.assertEquals((int)2, (int)usch.getSeriesDefinitions().size());
            db.commit();
            T040_SeriesTest.assertEquals((int)1, (int)chronicle.getSchema(true).getSeriesDefinitions().size());
            chronicle = db.getChronicle(CHRONICLE, true);
            T040_SeriesTest.assertEquals((int)2, (int)chronicle.getSchema(true).getSeriesDefinitions().size());
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_21() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            s.scanValue(t, (Object)"42.01");
            s.applyUpdates();
            db.commit();
            Chronicle chronicle = db.getChronicle(CHRONICLE, true);
            Series[] ss = chronicle.getSeries(new String[]{"test", "test4"}, Double.class, true);
            T040_SeriesTest.assertEquals((int)2, (int)ss.length);
            T040_SeriesTest.assertEquals(Double.class, (Object)ss[0].getValueType().getType());
            T040_SeriesTest.assertEquals((Object)42.01, (Object)ss[0].getValue(t));
            T040_SeriesTest.assertNull((Object)ss[1]);
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_22() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            s.scanValue(t, (Object)"42");
            s.applyUpdates();
            db.commit();
            Chronicle chronicle = db.getChronicle(CHRONICLE, true);
            chronicle.getSeries(new String[]{"test", "test2", "test4"}, Double.class, true);
            T040_SeriesTest.expectException();
        }
        catch (Exception e) {
            T040_SeriesTest.assertException(e, "D30121");
        }
    }

    public void test_23() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            s.scanValue(t, (Object)"42");
            s.applyUpdates();
            db.commit();
            Chronicle chronicle = db.getChronicle(CHRONICLE, false);
            Series[] ss = chronicle.getSeries(new String[]{"test", "test2", "test4"}, Double.class, false);
            T040_SeriesTest.assertEquals(Double.class, (Object)ss[0].getValueType().getType());
            T040_SeriesTest.assertEquals((Object)42.0, (Object)ss[0].getValue(t));
            T040_SeriesTest.assertNull((Object)ss[1]);
            T040_SeriesTest.assertNull((Object)ss[2]);
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }

    public void test_24() {
        try {
            UpdatableSeries s = db.getSeries(SERIES, true).edit().typeCheck(Double.class);
            TimeIndex t = s.getTimeDomain().time("2011-03-08");
            T040_SeriesTest.assertEquals((Object)42.0, (Object)s.getValue(t));
            t = s.getTimeDomain().time("2011-03-14");
            s.scanValue(t, (Object)"51.3");
            s.scanValue(t.add(2L), (Object)"55");
            s.applyUpdates();
            if (DUMP.booleanValue()) {
                System.out.println(t.getTimeDomain() + " " + s.getRange());
            }
            T040_SeriesTest.assertEquals((long)9L, (long)s.getRange().getSize());
            if (DUMP.booleanValue()) {
                System.out.println(s.getValues(null));
            }
            boolean done = s.setRange(new Range(t.getTimeDomain(), "2011-03-12", "2011-03-17", Adjustment.NONE));
            if (DUMP.booleanValue()) {
                System.out.println(s.getValues(null));
            }
            T040_SeriesTest.assertFalse((boolean)done);
            done = s.setRange(new Range(t.getTimeDomain(), "2011-03-12", "2011-03-16", Adjustment.NONE));
            s.applyUpdates();
            if (DUMP.booleanValue()) {
                System.out.println(s.getValues(null));
            }
            T040_SeriesTest.assertEquals((long)3L, (long)s.getRange().getSize());
            done = s.setRange(null);
            s.applyUpdates();
            T040_SeriesTest.assertEquals((long)0L, (long)s.getRange().getSize());
        }
        catch (Exception e) {
            T040_SeriesTest.fail((String)e.toString());
        }
    }
}

