/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.ValueScanner;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.junit.AbstractTest;
import java.util.Collection;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class T012_ValueTypeTest
extends AbstractTest {
    private Database db;

    @Override
    protected void setUp() throws Exception {
        this.db = this.getContext().getDatabase();
    }

    public void test_010_create_type() {
        try {
            UpdatableValueType vt = this.db.createValueType("foo-type", true, "TEXT");
            vt.addValue(vt.getScanner().scan("bar"), "it's bar");
            vt.addValue(vt.getScanner().scan("baz"), "it's baz");
            vt.applyUpdates();
            T012_ValueTypeTest.assertEquals((String)"foo-type", (String)this.db.getValueType(vt.getSurrogate()).getName());
            T012_ValueTypeTest.assertEquals((String)"it's bar", (String)((String)this.db.getValueType(vt.getSurrogate()).getValueDescriptions().get("bar")));
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_020_create_another_type() {
        try {
            UpdatableValueType vt = this.db.createValueType("bar-type", false, "TEXT");
            vt.applyUpdates();
            T012_ValueTypeTest.assertEquals((int)2, (int)this.db.getValueTypes("*-type").size());
            if (this.getContext().hasStandardRegex()) {
                T012_ValueTypeTest.assertEquals((int)2, (int)this.db.getValueTypes("/.*-t[xyz]pe/").size());
            }
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_030_rename_type() {
        try {
            ValueType vt = this.db.getValueType("foo-type");
            Surrogate s = vt.getSurrogate();
            UpdatableValueType uvt = vt.edit();
            uvt.setName("moo-type");
            uvt.applyUpdates();
            T012_ValueTypeTest.assertEquals((String)"moo-type", (String)this.db.getValueType(s).getName());
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    private void helper_delete_type(String name) throws Exception {
        ValueType vt = this.db.getValueType(name);
        UpdatableValueType uvt = vt.edit();
        uvt.destroy();
        uvt.applyUpdates();
        try {
            this.db.getValueType(name);
            T012_ValueTypeTest.expectException();
        }
        catch (Exception e) {
            T012_ValueTypeTest.assertException(e, "E10109");
        }
    }

    public void test_040_delete_types_by_pattern() {
        try {
            Collection vts = this.db.getValueTypes("*-type");
            for (ValueType vt : vts) {
                this.helper_delete_type(vt.getName());
            }
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_050_delete_non_existing_type() {
        try {
            this.helper_delete_type("foo");
            T012_ValueTypeTest.expectException();
        }
        catch (Exception e) {
            T012_ValueTypeTest.assertException(e, "E10109");
        }
    }

    public void test_060_recreate_type() {
        try {
            UpdatableValueType vt = this.db.createValueType("foo", true, "TEXT");
            vt.applyUpdates();
            T012_ValueTypeTest.assertEquals((int)0, (int)vt.getValues().size());
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_070_type_add_value() {
        try {
            UpdatableValueType vt = this.db.getValueType("foo").typeCheck(String.class).edit();
            vt.addValue(vt.getScanner().scan("foo1"), "Foo 1");
            vt.applyUpdates();
            T012_ValueTypeTest.assertEquals((int)1, (int)vt.getValues().size());
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_080_add_more_values() {
        try {
            UpdatableValueType vt = this.db.getValueType("foo").typeCheck(String.class).edit();
            vt.addValue(vt.getScanner().scan("foo2"), "Foo 2");
            vt.addValue(vt.getScanner().scan("foo4"), "Foo 4");
            vt.applyUpdates();
            T012_ValueTypeTest.assertEquals((int)3, (int)vt.getValues().size());
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_090_get_value_and_description() {
        try {
            ValueType vt = this.db.getValueType("foo");
            Collection values = vt.getValues(null);
            T012_ValueTypeTest.assertEquals((String)"foo1 - Foo 1", (String)((String)values.iterator().next()));
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_100_get_all_values() {
        try {
            UpdatableValueType vt = this.db.getValueType("foo").typeCheck(String.class).edit();
            T012_ValueTypeTest.assertTrue((boolean)((String)vt.getValueDescriptions().get("foo1")).equals("Foo 1"));
            T012_ValueTypeTest.assertTrue((vt.getValueDescriptions().get("baz") == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_110_update_type_no_update() {
        try {
            UpdatableValueType vt = this.db.getValueType("foo").typeCheck(String.class).edit();
            vt.applyUpdates();
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_120_update_existing_value() {
        try {
            UpdatableValueType vt = this.db.getValueType("foo").typeCheck(String.class).edit();
            vt.updateValue(vt.getScanner().scan("foo1"), "Foo 1 edited");
            vt.applyUpdates();
            T012_ValueTypeTest.assertEquals((String)"Foo 1 edited", (String)((String)vt.getValueDescriptions().get("foo1")));
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_130_update_non_existing_value() {
        try {
            UpdatableValueType vt = this.db.getValueType("foo").typeCheck(String.class).edit();
            vt.updateValue(vt.getScanner().scan("foo3"), "Foo 3");
            vt.applyUpdates();
            T012_ValueTypeTest.expectException();
        }
        catch (Exception e) {
            T012_ValueTypeTest.assertException(e, "D10123");
        }
    }

    public void test_140_delete_non_existing_value() {
        try {
            UpdatableValueType vt = this.db.getValueType("foo").typeCheck(String.class).edit();
            vt.deleteValue(vt.getScanner().scan("foo3"));
            vt.applyUpdates();
            T012_ValueTypeTest.expectException();
        }
        catch (Exception e) {
            T012_ValueTypeTest.assertException(e, "D10122");
        }
    }

    public void test_150_delete_existing_value() {
        try {
            UpdatableValueType vt = this.db.getValueType("foo").typeCheck(String.class).edit();
            vt.deleteValue(vt.getScanner().scan("foo4"));
            vt.applyUpdates();
            T012_ValueTypeTest.assertEquals((int)2, (int)vt.getValues().size());
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_160_delete_existing_type() {
        try {
            this.helper_delete_type("foo");
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_170_create_custom_type() {
        try {
            UpdatableValueType vt = this.db.createValueType("foo", true, FooScanner.class.getName());
            vt.addValue(vt.getScanner().scan("bar:1"), "it's bar:1");
            try {
                vt.addValue(vt.getScanner().scan("baz"), "it's baz:2");
                T012_ValueTypeTest.expectException();
            }
            catch (T2DBException e) {
                T012_ValueTypeTest.assertTrue((boolean)e.getMessage().startsWith("not a Foo"));
            }
            vt.applyUpdates();
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public void test_180_delete_custom_type() {
        try {
            UpdatableValueType vt = this.db.getValueType("foo").typeCheck(Foo.class).edit();
            vt.destroy();
            vt.applyUpdates();
        }
        catch (Exception e) {
            T012_ValueTypeTest.fail((String)e.getMessage());
        }
    }

    public static class FooScanner
    implements ValueScanner<Foo> {
        public Class<Foo> getType() {
            return Foo.class;
        }

        public Foo scan(String value) throws T2DBException {
            try {
                String[] parts = value.split(":");
                if (parts.length == 2) {
                    return new Foo(parts[0], Integer.valueOf(parts[1]));
                }
            }
            catch (Exception e) {
                throw T2DBMsg.exception((Throwable)e, (String)("not a Foo: " + value), (Object[])new Object[0]);
            }
            throw T2DBMsg.exception((String)("not a Foo: " + value), (Object[])new Object[0]);
        }

        public void check(Foo value) throws T2DBException {
        }

        public String toString(Foo value) throws T2DBException {
            return value.toString();
        }
    }

    public static class Foo {
        private String foo1;
        private int foo2;

        public Foo(String foo1, int foo2) {
            this.foo1 = foo1;
            this.foo2 = foo2;
        }

        public String getFoo1() {
            return this.foo1;
        }

        public int getFoo2() {
            return this.foo2;
        }

        public String toString() {
            return this.foo1 + ":" + this.foo2;
        }
    }
}

