/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.junit.AbstractTest;
import ch.agent.crnickl.junit.Util;

public class T006_ChronicleTest_NonStrictMode
extends AbstractTest {
    private Database db;
    private static boolean clean;
    private static final String FULLNAME = "bt.standalonetest";
    private static final String SIMPLENAME = "standalonetest";

    @Override
    protected void tearDown() throws Exception {
        ((DatabaseBackend)this.db).setStrictNameSpaceMode(true);
        super.tearDown();
    }

    @Override
    protected void setUp() throws Exception {
        this.db = this.getContext().getDatabase();
        ((DatabaseBackend)this.db).setStrictNameSpaceMode(false);
        if (!clean) {
            Chronicle testData = this.db.getChronicle(SIMPLENAME, false);
            if (testData != null) {
                Util.deleteChronicleCollection(testData);
                UpdatableChronicle upd = testData.edit();
                upd.destroy();
                upd.applyUpdates();
            }
            UpdatableChronicle ex = this.db.getTopChronicle().edit().createChronicle(SIMPLENAME, false, "standalone test", null, null);
            ex.applyUpdates();
            clean = true;
        }
    }

    public void test1() {
        T006_ChronicleTest_NonStrictMode.assertFalse((boolean)((DatabaseBackend)this.db).isStrictNameSpaceMode());
        try {
            UpdatableChronicle e = this.db.getChronicle(SIMPLENAME, true).edit();
            UpdatableChronicle ex = e.createChronicle("x", false, "it's x", null, null);
            ex.applyUpdates();
            Chronicle ent = this.db.getChronicle("standalonetest.x", true);
            T006_ChronicleTest_NonStrictMode.assertEquals((String)"standalonetest.x", (String)ent.getName(true));
        }
        catch (Exception e) {
            T006_ChronicleTest_NonStrictMode.fail((String)e.toString());
        }
    }

    public void test2() {
        T006_ChronicleTest_NonStrictMode.assertFalse((boolean)((DatabaseBackend)this.db).isStrictNameSpaceMode());
        try {
            Chronicle en = this.db.getChronicle("standalonetest.x", true);
            T006_ChronicleTest_NonStrictMode.assertEquals((String)"standalonetest.x", (String)en.getName(true));
        }
        catch (Exception e) {
            T006_ChronicleTest_NonStrictMode.fail((String)e.toString());
        }
    }

    public void test3() {
        T006_ChronicleTest_NonStrictMode.assertFalse((boolean)((DatabaseBackend)this.db).isStrictNameSpaceMode());
        try {
            Chronicle en = this.db.getChronicle("bt.standalonetest.x", true);
            T006_ChronicleTest_NonStrictMode.assertEquals((String)"standalonetest.x", (String)en.getName(true));
        }
        catch (Exception e) {
            T006_ChronicleTest_NonStrictMode.fail((String)e.toString());
        }
    }
}

