/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdateEvent;
import ch.agent.crnickl.api.UpdateEventSubscriber;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.junit.AbstractTest;
import ch.agent.crnickl.junit.Util;

public class T005_CacheTest
extends AbstractTest {
    private static Boolean DUMP = false;
    private static Database db;
    private static boolean notified;

    @Override
    protected void firstSetUp() throws Exception {
        db = this.getContext().getDatabase();
        db.rollback();
        ((DatabaseBackend)db).setStrictNameSpaceMode(false);
        db.getUpdateEventPublisher().subscribe(new UpdateEventSubscriber(){

            public void notify(UpdateEvent event) {
                notified = true;
                if (DUMP.booleanValue()) {
                    System.err.println("T005* " + event.toString());
                }
            }
        }, DBObjectType.CHRONICLE, true);
        Util.deleteChronicles(db, "bt.test");
    }

    @Override
    protected void lastTearDown() throws Exception {
        db.getUpdateEventPublisher().unsubscribeAll();
        ((DatabaseBackend)db).setStrictNameSpaceMode(true);
        if (!notified) {
            T005_CacheTest.fail((String)"no notification seen");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test1() {
        try {
            UpdatableChronicle uc = db.getTopChronicle().edit().createChronicle("test", false, "testing...", null, null);
            uc.applyUpdates();
            String su1 = uc.getSurrogate().toString();
            String su2 = db.getChronicle("test", true).getSurrogate().toString();
            T005_CacheTest.assertEquals((String)su1, (String)su2);
            uc.destroy();
            uc.applyUpdates();
            uc = db.getTopChronicle().edit().createChronicle("test", false, "testing...", null, null);
            uc.applyUpdates();
            String su3 = uc.getSurrogate().toString();
            String su4 = db.getChronicle("test", true).getSurrogate().toString();
            T005_CacheTest.assertEquals((String)su3, (String)su4);
            db.commit();
        }
        catch (Exception e) {
            T005_CacheTest.fail((String)e.getMessage());
        }
    }

    static {
        notified = false;
    }
}

