/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.SimpleDatabaseManager;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.ValueType;
import java.net.URL;
import java.util.Map;

public class Context {
    private SimpleDatabaseManager dbm;
    private boolean isTransactional = false;
    private boolean supportsRegex = false;
    private boolean isPersistent = false;
    private static final String DB_CONFIG = "db.test.config";
    private static final String IS_PERSISTENT = "feature.isPersistent";
    private static final String IS_TRANSACTIONAL = "feature.isTransactional";
    private static final String SUPPORTS_REGEX = "feature.supportsRegex";
    private static final String TRUE = "true";

    protected Database setup() throws Exception {
        if (this.dbm == null) {
            URL url = ClassLoader.getSystemClassLoader().getResource(DB_CONFIG);
            if (url == null) {
                throw new RuntimeException(String.format("Resource \"%s\" not found.", DB_CONFIG));
            }
            this.dbm = new SimpleDatabaseManager("file=" + url.getFile());
            Map parameters = this.dbm.getParameters();
            this.isTransactional = TRUE.equals(parameters.get(IS_TRANSACTIONAL));
            this.supportsRegex = TRUE.equals(parameters.get(SUPPORTS_REGEX));
            this.isPersistent = TRUE.equals(parameters.get(IS_PERSISTENT));
            this.setup(this.dbm, parameters);
        }
        return this.dbm.getDatabase();
    }

    protected void setup(SimpleDatabaseManager dbm, Map<String, String> parameters) throws Exception {
        this.setUpNumberType(dbm.getDatabase());
    }

    public Database getDatabase() throws Exception {
        if (this.dbm == null) {
            this.setup();
        }
        return this.dbm.getDatabase();
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public boolean hasStandardRegex() {
        return this.supportsRegex;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    protected void setUpNumberType(Database db) throws Exception {
        try {
            db.getValueType("numeric").typeCheck(Double.class);
        }
        catch (Exception e) {
            UpdatableValueType uvt = db.createValueType("numeric", false, "NUMBER");
            uvt.applyUpdates();
            UpdatableValueType uvtvt = db.getTypeBuiltInProperty().getValueType().typeCheck(ValueType.class).edit();
            uvtvt.addValue(uvtvt.getScanner().scan("numeric"), null);
            uvtvt.applyUpdates();
            db.commit();
        }
    }
}

