/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.core.KeyedException;
import ch.agent.crnickl.junit.Context;
import java.lang.reflect.Method;
import junit.framework.TestCase;

public class AbstractTest
extends TestCase {
    private static final String EXCEPTION_EXPECTED = "Exception expected";
    private static final String NOT_KEYED = "Not keyed (%s): %s";
    private static int testCount = -1;

    protected Context getContext() {
        throw new RuntimeException("getContext must be overriden");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (testCount < 0) {
            testCount = 0;
            for (Method m : ((Object)((Object)this)).getClass().getMethods()) {
                if (!m.getName().startsWith("test")) continue;
                ++testCount;
            }
            this.firstSetUp();
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (testCount > 0 && --testCount == 0) {
            this.lastTearDown();
            testCount = -1;
        }
    }

    protected void firstSetUp() throws Exception {
    }

    protected void lastTearDown() throws Exception {
    }

    protected static void expectException() {
        AbstractTest.fail((String)EXCEPTION_EXPECTED);
    }

    protected static void assertException(Exception e, String ... keys) {
        Throwable t = e;
        boolean allNull = true;
        for (String key : keys) {
            if (key != null) {
                allNull = false;
                if (t instanceof KeyedException) {
                    AbstractTest.assertEquals((String)key, (String)((KeyedException)t).getMsg().getKey());
                } else {
                    AbstractTest.fail((String)String.format(NOT_KEYED, key, t == null ? "null" : t.toString()));
                }
            }
            t = t == null ? null : t.getCause();
        }
        if (allNull) {
            AbstractTest.fail((String)e.toString());
        }
    }
}

