/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.junit.AbstractTest;
import ch.agent.crnickl.junit.Util;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.timeseries.Observation;
import ch.agent.t2.timeseries.TimeAddressable;
import ch.agent.t2.timeseries.TimeIndexable;
import ch.agent.t2.timeseries.TimeSeriesFactory;
import java.util.Collection;

public class T042_SeriesValuesTest
extends AbstractTest {
    private static Database db;
    protected static String SCHEMA;
    private static final String CHRONICLE;
    private static final String SERIES;
    private static final String SERIES_TYPE = "numeric";
    private static final TimeDomain SERIES_DOMAIN;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.emptySeries(db);
    }

    @Override
    protected void firstSetUp() throws Exception {
        db = this.getContext().getDatabase();
        this.createSchema(db);
        this.createChronicle(db);
        db.commit();
    }

    @Override
    protected void lastTearDown() throws Exception {
        Util.deleteChronicles(db, CHRONICLE);
        Util.deleteSchema(db, SCHEMA);
    }

    public void testSparsity() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true);
            T042_SeriesValuesTest.assertEquals((boolean)this.isSparse(), (boolean)s.isSparse());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testEmptyRange() {
        try {
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true);
            T042_SeriesValuesTest.assertEquals((Object)new Range(s.getTimeDomain()), (Object)s.getRange());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testNonEmptyRange() {
        try {
            TimeAddressable<Double> ts = this.makeTimeSeries();
            T042_SeriesValuesTest.assertEquals((long)62L, (long)ts.getRange().getSize());
            UpdatableSeries s = db.getUpdatableSeries(SERIES, true);
            s.setValues(ts);
            T042_SeriesValuesTest.assertEquals((Object)ts.getRange(), (Object)s.getRange());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testNonEmptyRangeInDatabase() {
        try {
            TimeAddressable<Double> ts = this.makeTimeSeries();
            Series<Double> s = this.makeSeries(ts);
            Series s2 = db.getSeries(SERIES, true);
            T042_SeriesValuesTest.assertNotSame(s, (Object)s2);
            T042_SeriesValuesTest.assertEquals((Object)ts.getRange(), (Object)s2.getRange());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testSubRangeHasNoMissingValuesAtTheBoundaries() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeDomain dom = s.getTimeDomain();
            TimeAddressable ts = s.getValues(new Range(dom, "2011-05-15", "2011-07-15", Adjustment.NONE));
            T042_SeriesValuesTest.assertEquals((Object)new Range(dom, "2011-06-01", "2011-07-01", Adjustment.NONE), (Object)ts.getRange());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetValueOutOfRange() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeIndex t = s.getTimeDomain().time("2011-07-15");
            T042_SeriesValuesTest.assertEquals((Object)Double.NaN, (Object)s.getValue(t));
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetMissingValue_1() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeIndex t = s.getTimeDomain().time("2011-06-15");
            T042_SeriesValuesTest.assertEquals((Object)Double.NaN, (Object)s.getValue(t));
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetMissingValue_2() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeIndex t = s.getTimeDomain().time("2011-06-15");
            T042_SeriesValuesTest.assertEquals((Object)Double.NaN, (Object)s.getValue(t));
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetValue() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeIndex t = s.getTimeDomain().time("2011-07-01");
            T042_SeriesValuesTest.assertEquals((Object)201107.01, (Object)s.getValue(t));
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetLastValue_1() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeDomain dom = s.getTimeDomain();
            Range range = new Range(dom.time("2011-05-15"), dom.time("2011-07-15"));
            TimeAddressable ts = s.getValues(range);
            Observation obs = ts.getLast(dom.time("2011-06-01"));
            T042_SeriesValuesTest.assertEquals((String)"2011-06-01", (String)obs.getTime().toString());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetLastValue_2() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeIndex t = s.getTimeDomain().time("2011-04-30");
            Observation obs = s.getLastObservation(t);
            T042_SeriesValuesTest.assertNull((Object)obs);
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetLastValue_3() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeDomain dom = s.getTimeDomain();
            Range range = new Range(dom.time("2011-05-15"), dom.time("2011-07-15"));
            TimeAddressable ts = s.getValues(range);
            Observation obs = ts.getLast(dom.time("2011-05-31"));
            T042_SeriesValuesTest.assertNull((Object)obs);
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetFirstValue_1() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeIndex t = s.getTimeDomain().time("2011-06-01");
            T042_SeriesValuesTest.assertEquals((Object)201106.01, (Object)s.getFirstObservation(t).getValue());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetFirstValue_2() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeIndex t = s.getTimeDomain().time("2011-05-31");
            T042_SeriesValuesTest.assertEquals((Object)201106.01, (Object)s.getFirstObservation(t).getValue());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetFirstValue_3() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries());
            TimeIndex t = s.getTimeDomain().time("2011-07-31");
            T042_SeriesValuesTest.assertNull((Object)s.getFirstObservation(t));
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testMoreSeries() {
        try {
            UpdatableSeries s = this.makeSeries(this.makeTimeSeries2()).edit();
            TimeAddressable ts = s.getValues(null);
            Range range = new Range(s.getTimeDomain(), "2011-05-01", "2011-07-03", Adjustment.NONE);
            T042_SeriesValuesTest.assertEquals((long)64L, (long)range.getSize());
            T042_SeriesValuesTest.assertEquals((Object)range, (Object)ts.getRange());
            T042_SeriesValuesTest.assertEquals((Object)range, (Object)s.getRange());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetLastValue_4() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries2());
            TimeIndex t = s.getTimeDomain().time("2011-06-04");
            T042_SeriesValuesTest.assertEquals((Object)201106.02, (Object)s.getLastObservation(t).getValue());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetLastValue_5() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries2());
            TimeIndex t = s.getTimeDomain().time("2011-05-31");
            T042_SeriesValuesTest.assertEquals((Object)201105.31, (Object)s.getLastObservation(t).getValue());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetFirstValue_4() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries2());
            TimeIndex t = s.getTimeDomain().time("2011-06-01");
            T042_SeriesValuesTest.assertEquals((Object)201106.01, (Object)s.getFirstObservation(t).getValue());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetFirstValue_5() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries2());
            TimeIndex t = s.getTimeDomain().time("2011-06-03");
            T042_SeriesValuesTest.assertEquals((Object)201106.3, (Object)s.getFirstObservation(t).getValue());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetFirstValue_6() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries2());
            T042_SeriesValuesTest.assertEquals((Object)201105.01, (Object)s.getFirstObservation(null).getValue());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testGetLastValue_6() {
        try {
            Series<Double> s = this.makeSeries(this.makeTimeSeries2());
            T042_SeriesValuesTest.assertEquals((Object)201107.03, (Object)s.getLastObservation(null).getValue());
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testSmallGap_1() {
        try {
            Series<Double> s = this.makeSeriesWithGap("2011-05-01", "2011-05-03");
            TimeIndexable ts = s.getValues(null).asIndexable();
            int missingValuesCount = 0;
            for (Observation obs : ts) {
                if (!ts.isMissing(obs.getValue())) continue;
                ++missingValuesCount;
            }
            T042_SeriesValuesTest.assertEquals((long)(s.getRange().getSize() - 2L), (long)missingValuesCount);
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testSmallGap_2() {
        try {
            Series<Double> s = this.makeSeriesWithGap("2011-05-01", "2011-07-03");
            TimeIndexable ts = s.getValues(null).asIndexable();
            int missingValuesCount = 0;
            for (Observation obs : ts) {
                if (!ts.isMissing(obs.getValue())) continue;
                ++missingValuesCount;
            }
            T042_SeriesValuesTest.assertEquals((long)(s.getRange().getSize() - 2L), (long)missingValuesCount);
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testLargeGap_1() {
        try {
            Series<Double> s = this.makeSeriesWithGap("2011-05-01", "2012-09-13");
            TimeIndexable ts = s.getValues(null).asIndexable();
            int missingValuesCount = 0;
            for (Observation obs : ts) {
                if (!ts.isMissing(obs.getValue())) continue;
                ++missingValuesCount;
            }
            T042_SeriesValuesTest.assertEquals((long)(s.getRange().getSize() - 2L), (long)missingValuesCount);
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testLargeGap_2() {
        try {
            Series<Double> s = this.makeSeriesWithGap("2011-05-01", "2011-05-02");
            int maxGap = s.getValues(null).asIndexable().getMaxGap();
            TimeIndex date1 = s.getFirstObservation(null).getTime();
            TimeIndex date2 = date1.add((long)(maxGap + 2));
            Series<Double> s2 = this.makeSeriesWithGap(date1.toString(), date2.toString());
            s2.getValues(null).asIndexable();
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    public void testLargeGap_3() {
        try {
            Series<Double> s = this.makeSeriesWithGap("2011-05-01", "2011-05-02");
            int maxGap = s.getValues(null).asIndexable().getMaxGap();
            TimeIndex date1 = s.getFirstObservation(null).getTime();
            TimeIndex date2 = date1.add((long)(maxGap + 2 + 1));
            Series<Double> s2 = this.makeSeriesWithGap(date1.toString(), date2.toString());
            s2.getValues(null).asIndexable();
            T042_SeriesValuesTest.expectException();
        }
        catch (Exception e) {
            T042_SeriesValuesTest.assertException(e, "T5019");
        }
    }

    public void testLargeGap_4() {
        try {
            this.makeSeriesWithGap("2011-05-01", "2100-05-02");
            Series s2 = db.getSeries(SERIES, true).typeCheck(Double.class);
            s2.getValues(null);
            if (!this.isSparse()) {
                T042_SeriesValuesTest.expectException();
            }
        }
        catch (Exception e) {
            if (this.isSparse()) {
                T042_SeriesValuesTest.fail((String)e.getMessage());
            }
            T042_SeriesValuesTest.assertException(e, "E50121", "T5019");
        }
    }

    public void testLargeGap_5() {
        try {
            Series<Double> s2 = this.makeSeriesWithGap("2011-05-01", "2100-05-02");
            s2.getValues(null);
        }
        catch (Exception e) {
            T042_SeriesValuesTest.fail((String)e.toString());
        }
    }

    protected boolean isSparse() {
        return false;
    }

    private Schema createSchema(Database db) throws Exception {
        Collection schemas = db.getSchemas(SCHEMA);
        switch (schemas.size()) {
            case 1: {
                return (Schema)schemas.iterator().next();
            }
            case 0: {
                UpdatableSchema s = db.createSchema(SCHEMA, null);
                s.addSeries(1);
                s.setSeriesName(1, db.getNamingPolicy().split(SERIES)[1]);
                s.setSeriesType(1, SERIES_TYPE);
                s.setSeriesTimeDomain(1, SERIES_DOMAIN);
                s.setSeriesSparsity(1, this.isSparse());
                s.applyUpdates();
                return s.resolve();
            }
        }
        throw new IllegalArgumentException(SCHEMA + ": " + schemas.size());
    }

    private Chronicle createChronicle(Database db) throws Exception {
        Chronicle c = db.getChronicle(CHRONICLE, false);
        if (c == null) {
            String[] split = db.getNamingPolicy().split(CHRONICLE);
            UpdatableChronicle uc = db.getTopChronicle().edit().createChronicle(split[1], false, CHRONICLE + " (test)", null, this.createSchema(db));
            uc.applyUpdates();
            c = uc;
        }
        return c;
    }

    private Series<Double> emptySeries(Database db) throws Exception {
        UpdatableSeries s = db.getUpdatableSeries(SERIES, true).typeCheck(Double.class);
        if (!s.inConstruction()) {
            s.setRange(null);
        }
        s.applyUpdates();
        return s;
    }

    private TimeAddressable<Double> makeTimeSeries() throws Exception {
        TimeDomain domain = SERIES_DOMAIN;
        TimeIndexable ts = TimeSeriesFactory.make((TimeDomain)domain, Double.class);
        ts.put(domain.time("2011-05-01"), (Object)201105.01);
        ts.put(domain.time("2011-06-01"), (Object)201106.01);
        ts.put(domain.time("2011-07-01"), (Object)201107.01);
        return ts;
    }

    private TimeAddressable<Double> makeTimeSeries2() throws Exception {
        TimeDomain domain = SERIES_DOMAIN;
        TimeIndexable ts = TimeSeriesFactory.make((TimeDomain)domain, Double.class);
        ts.put(domain.time("2011-05-01"), (Object)201105.01);
        ts.put(domain.time("2011-05-02"), (Object)201105.02);
        ts.put(domain.time("2011-05-03"), (Object)201105.03);
        ts.put(domain.time("2011-05-30"), (Object)201105.3);
        ts.put(domain.time("2011-05-31"), (Object)201105.31);
        ts.put(domain.time("2011-06-01"), (Object)201106.01);
        ts.put(domain.time("2011-06-02"), (Object)201106.02);
        ts.put(domain.time("2011-06-30"), (Object)201106.3);
        ts.put(domain.time("2011-07-01"), (Object)201107.01);
        ts.put(domain.time("2011-07-02"), (Object)201107.02);
        ts.put(domain.time("2011-07-03"), (Object)201107.03);
        return ts;
    }

    private Series<Double> makeSeries(TimeAddressable<Double> ts) throws Exception {
        UpdatableSeries s = db.getUpdatableSeries(SERIES, true);
        s.setValues(ts);
        s.applyUpdates();
        return s;
    }

    private Series<Double> makeSeriesWithGap(String date1, String date2) throws Exception {
        UpdatableSeries s = db.getUpdatableSeries(SERIES, true);
        TimeDomain domain = s.getTimeDomain();
        s.setValue(domain.time(date1), (Object)1.0);
        s.setValue(domain.time(date2), (Object)2.0);
        s.applyUpdates();
        return s;
    }

    static {
        SCHEMA = "t042";
        CHRONICLE = "bt." + SCHEMA;
        SERIES = CHRONICLE + ".test";
        SERIES_DOMAIN = Day.DOMAIN;
    }
}

