/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.junit.AbstractTest;
import ch.agent.crnickl.junit.Util;
import ch.agent.t2.time.DateTime;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.Workday;
import java.util.Collection;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class T017_SchemaTest
extends AbstractTest {
    private static Database db;
    private static Boolean DEBUG;

    @Override
    protected void firstSetUp() throws Exception {
        db = this.getContext().getDatabase();
        UpdatableValueType vt1 = db.createValueType("type1", true, "TEXT");
        vt1.addValue(vt1.getScanner().scan("t1v1"), "type1 value1");
        vt1.addValue(vt1.getScanner().scan("t1v2"), "type1 value2");
        vt1.addValue(vt1.getScanner().scan("t1v3"), "type1 value3");
        vt1.applyUpdates();
        UpdatableValueType vt2 = db.createValueType("type2", true, "TEXT");
        vt2.addValue(vt2.getScanner().scan("t2v2"), "type2 value2");
        vt2.addValue(vt2.getScanner().scan(""), null);
        vt2.applyUpdates();
        UpdatableValueType vt3 = db.createValueType("type3", false, "TEXT");
        vt3.applyUpdates();
        db.createProperty("prop1", (ValueType)vt1, false).applyUpdates();
        db.createProperty("prop2", (ValueType)vt2, false).applyUpdates();
        db.createProperty("prop3", (ValueType)vt3, false).applyUpdates();
        db.commit();
    }

    @Override
    protected void lastTearDown() throws Exception {
        Util.deleteChronicles(db, "bt.schema1achro", "bt.schema1achro2", "bt.schema3chro", "bt.schema4chro");
        Util.deleteSchema(db, "schema1f", "schema5", "schema4", "schema3", "schema2", "schema1a", "schema2a", "schema2b");
        if (DEBUG.booleanValue()) {
            this.listSchemas("schema*");
        }
        Util.deleteProperties(db, "prop1", "prop2", "prop3");
        Util.deleteValueTypes(db, "type1", "type2", "type3");
        db.commit();
    }

    private void listSchemas(String pattern) throws Exception {
        Collection schemas = db.getUpdatableSchemas(pattern);
        for (UpdatableSchema schema : schemas) {
            UpdatableSchema base = schema.getBase();
            if (base == null) {
                System.out.println(schema.getName());
                continue;
            }
            System.out.println(schema.getName() + "--->" + schema.getBase().getName());
        }
    }

    public void test_010_create_schema_failure_series_name_used_twice() {
        try {
            UpdatableSchema schema = db.createSchema("schema1", null);
            schema.addSeries(1);
            schema.setSeriesName(1, "x25");
            schema.addSeries(2);
            schema.setSeriesName(2, "x25");
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30153");
        }
    }

    public void test_020_create_schema_ok_but_not_applied() {
        try {
            UpdatableSchema schema = db.createSchema("schema1", null);
            schema.addSeries(1);
            schema.setSeriesName(1, "x25");
            schema.addAttribute(1);
            schema.setAttributeProperty(1, db.getProperty("prop1", true));
            schema.setAttributeDefault(1, (Object)"t1v1");
            T017_SchemaTest.assertEquals((String)"t1v1", (String)schema.getAttributeDefinition(1, true).getValue().toString());
            T017_SchemaTest.assertEquals((String)"t1v1", (String)schema.getAttributeDefinition("prop1", true).getValue().toString());
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_030_create_schema_failure_illegal_value_on_property_modification() {
        try {
            UpdatableSchema schema = db.createSchema("schema1", null);
            schema.addAttribute(1);
            schema.setAttributeProperty(1, db.getProperty("prop1", true));
            schema.setAttributeDefault(1, (Object)"t1v1");
            schema.setAttributeProperty(1, db.getProperty("prop2", true));
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30133");
        }
    }

    public void test_040_create_schema_failure_incomplete_attribute() {
        try {
            UpdatableSchema schema = db.createSchema("schema1", null);
            schema.addAttribute(1);
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30105", "D30111");
        }
    }

    public void test_050_create_schema_failure_incomplete_attribute_no_value() {
        try {
            UpdatableSchema schema = db.createSchema("schema1", null);
            schema.addAttribute(1);
            schema.setAttributeProperty(1, db.getProperty("prop1", true));
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30105", "D30111");
        }
    }

    public void test_060_create_schema_with_empty_value() {
        try {
            UpdatableSchema schema = db.createSchema("schema2a", null);
            schema.addAttribute(1);
            Property prop = db.getProperty("prop2", true);
            schema.setAttributeProperty(1, prop);
            schema.setAttributeDefault(1, prop.scan(""));
            schema.applyUpdates();
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_070_create_schema_with_null_value() {
        try {
            UpdatableSchema schema = db.createSchema("schema2b", null);
            schema.addAttribute(1);
            schema.setAttributeProperty(1, db.getProperty("prop2", true));
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30105", "D30111");
        }
    }

    public void test_080_create_schema_failure_incomplete_series() {
        try {
            UpdatableSchema schema = db.createSchema("schema1", null);
            schema.addSeries(1);
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30105", "D30112");
        }
    }

    public void test_090_create_schema_schema1f() {
        try {
            UpdatableSchema schema = db.createSchema("schema1f", null);
            schema.addSeries(1);
            schema.setSeriesName(1, "x");
            schema.setSeriesType(1, "numeric");
            schema.setSeriesTimeDomain(1, Day.DOMAIN);
            schema.applyUpdates();
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_100_create_existing_schema_fails() {
        try {
            UpdatableSchema schema = db.createSchema("schema1f", null);
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30108");
        }
    }

    public void test_110_add_incomplete_series_attribute() {
        try {
            UpdatableSchema schema = (UpdatableSchema)db.getUpdatableSchemas("schema1f").iterator().next();
            schema.addAttribute(1, 4);
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30105", "D30113");
        }
    }

    public void test_120_add_incomplete_series_attribute_value_required() {
        try {
            UpdatableSchema schema = (UpdatableSchema)db.getUpdatableSchemas("schema1f").iterator().next();
            schema.addAttribute(1, 4);
            schema.setAttributeProperty(1, 4, db.getProperty("prop2", true));
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30105", "D30113");
        }
    }

    public void test_130_add_series_attribute() {
        try {
            UpdatableSchema schema = (UpdatableSchema)db.getUpdatableSchemas("schema1f").iterator().next();
            schema.addAttribute(1, 4);
            schema.setAttributeProperty(1, 4, db.getProperty("prop2", true));
            schema.setAttributeDefault(1, 4, (Object)"t2v2");
            schema.applyUpdates();
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_140_create_schema_failure_same_attribute_nr() {
        try {
            UpdatableSchema schema = db.createSchema("schema1", null);
            schema.addAttribute(1);
            schema.setAttributeProperty(1, db.getProperty("prop1", true));
            schema.setAttributeDefault(1, (Object)"t1v1");
            schema.addAttribute(1);
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30127");
        }
    }

    public void test_150_create_schema_failure_attribute_incomplete_after_edit() {
        try {
            UpdatableSchema schema = db.createSchema("schema1", null);
            Collection ss = db.getSchemas("schema1");
            T017_SchemaTest.assertEquals((int)0, (int)ss.size());
            schema.addAttribute(1);
            schema.setAttributeProperty(1, db.getProperty("prop1", true));
            schema.setAttributeDefault(1, (Object)"t1v1");
            schema.deleteAttribute(1);
            schema.addAttribute(1);
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30105", "D30111");
        }
    }

    public void test_160_create_schema_failure_attribute_property_duplicate() {
        try {
            UpdatableSchema schema = db.createSchema("schema1", null);
            schema.addAttribute(1);
            schema.setAttributeProperty(1, db.getProperty("prop1", true));
            schema.setAttributeDefault(1, (Object)"t1v1");
            schema.addAttribute(2);
            schema.setAttributeProperty(2, db.getProperty("prop1", true));
            schema.setAttributeDefault(2, (Object)"t1v1");
            schema.applyUpdates();
            schema.resolve();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30151", "D30130");
        }
    }

    public void test_170_create_empty_schema() {
        try {
            UpdatableSchema schema = db.createSchema("schema5", null);
            schema.applyUpdates();
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_180_create_chronicle_with_updatable_schema_fails() {
        try {
            UpdatableSchema schema = (UpdatableSchema)db.getUpdatableSchemas("schema5").iterator().next();
            UpdatableChronicle chro = db.getTopChronicle().edit().createChronicle("schema5chro", false, "test chronicle", null, (Schema)schema);
            chro.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D40104");
        }
    }

    public void test_190_create_chronicle_with_empty_schema_okay() {
        try {
            Schema schema = (Schema)db.getSchemas("schema5").iterator().next();
            UpdatableChronicle chro = db.getTopChronicle().edit().createChronicle("schema5chro", false, "test chronicle", null, schema);
            chro.applyUpdates();
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_200_create_sub_chronicle_with_schema_inherited() {
        try {
            Schema schema = (Schema)db.getSchemas("schema5").iterator().next();
            UpdatableChronicle chro = db.getChronicle("bt.schema5chro", true).edit();
            T017_SchemaTest.assertEquals((Object)schema, (Object)chro.getSchema(false));
            chro.createChronicle("sub", false, "sub test", null, null).applyUpdates();
            Chronicle sub = db.getChronicle("bt.schema5chro.sub", true);
            T017_SchemaTest.assertEquals((Object)schema, (Object)sub.getSchema(true));
            T017_SchemaTest.assertEquals(null, (Object)sub.getSchema(false));
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_210_delete_chronicle() {
        try {
            Util.deleteChronicles(db, "bt.schema5chro");
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_220_create_schema1_and_schema2() {
        try {
            UpdatableSchema schema1 = db.createSchema("schema1", null);
            schema1.addAttribute(1);
            schema1.setAttributeProperty(1, db.getProperty("prop1", true));
            schema1.setAttributeDefault(1, (Object)"t1v1");
            schema1.applyUpdates();
            UpdatableSchema schema2 = db.createSchema("schema2", "schema1");
            schema2.addAttribute(1);
            schema2.setAttributeProperty(1, db.getProperty("prop1", true));
            schema2.setAttributeDefault(1, (Object)"t1v2");
            schema2.applyUpdates();
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_230_define_series_in_schema1() {
        try {
            UpdatableSchema schema1 = ((Schema)db.getSchemas("schema1").iterator().next()).edit();
            Schema schema2 = (Schema)db.getSchemas("schema2").iterator().next();
            schema1.addSeries(1);
            schema1.setSeriesName(1, "foo");
            schema1.setSeriesDescription(1, "foo series");
            schema1.setSeriesTimeDomain(1, Workday.DOMAIN);
            schema1.setSeriesType(1, db.getValueType("numeric"));
            schema1.addAttribute(1, 6);
            schema1.setAttributeProperty(1, 6, db.getProperty("prop2", true));
            schema1.setAttributeDefault(1, 6, (Object)"t2v2");
            schema1.applyUpdates();
            T017_SchemaTest.assertEquals((String)"foo", (String)schema1.getSeriesDefinition(1, true).getName());
            T017_SchemaTest.assertEquals((String)"foo series", (String)schema1.getSeriesDefinition(1, true).getDescription());
            T017_SchemaTest.assertEquals(null, (Object)schema2.getSeriesDefinition(1, false));
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_240_edit_and_add_series_in_schema1() {
        try {
            UpdatableSchema schema1 = ((Schema)db.getSchemas("schema1").iterator().next()).edit();
            schema1.setSeriesName(1, "fou");
            schema1.setSeriesDescription(1, "fou series");
            schema1.applyUpdates();
            T017_SchemaTest.assertEquals((String)"fou", (String)schema1.getSeriesDefinition(1, true).getName());
            T017_SchemaTest.assertEquals((String)"fou series", (String)schema1.getSeriesDefinition(1, true).getDescription());
            schema1.addSeries(3);
            schema1.setSeriesName(3, "foo");
            schema1.setSeriesDescription(3, "fully foo");
            schema1.setSeriesTimeDomain(3, Workday.DOMAIN);
            schema1.setSeriesType(3, db.getValueType("numeric"));
            schema1.applyUpdates();
            T017_SchemaTest.assertEquals((Object)Workday.DOMAIN, (Object)schema1.getSeriesDefinition(3, true).getTimeDomain());
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_250_rename_schema1_schema1a() {
        try {
            UpdatableSchema schema1 = ((Schema)db.getSchemas("schema1").iterator().next()).edit();
            schema1.setName("schema1a");
            schema1.applyUpdates();
            T017_SchemaTest.assertEquals((int)1, (int)db.getSchemas("schema1a").size());
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_260_create_schema3_for_base_of_schema1a() {
        try {
            UpdatableSchema schema3 = db.createSchema("schema3", null);
            schema3.applyUpdates();
            UpdatableSchema schema1 = ((Schema)db.getSchemas("schema1a").iterator().next()).edit();
            schema1.setBase(schema3);
            schema1.applyUpdates();
            T017_SchemaTest.assertEquals((Object)schema3, (Object)schema1.getBase());
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_270_reset_base_of_schema1a() {
        try {
            UpdatableSchema schema1 = ((Schema)db.getSchemas("schema1a").iterator().next()).edit();
            schema1.setBase(null);
            schema1.applyUpdates();
            T017_SchemaTest.assertEquals(null, (Object)schema1.getBase());
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_280_cannot_set_base_to_schema_in_construction() {
        try {
            UpdatableSchema schema4 = db.createSchema("schema4", null);
            schema4.addAttribute(1);
            schema4.setAttributeProperty(1, db.getProperty("prop1", true));
            schema4.setAttributeDefault(1, (Object)"t1v1");
            UpdatableSchema schema1 = ((Schema)db.getSchemas("schema1a").iterator().next()).edit();
            schema1.setBase(schema4);
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30128");
        }
    }

    public void test_290_create_schema4_based_on_schema1a_and_override_attribute() {
        UpdatableSchema schema1 = null;
        try {
            UpdatableSchema schema4 = db.createSchema("schema4", "schema1a");
            Schema s = schema4.resolve();
            T017_SchemaTest.assertEquals((String)"prop1", (String)s.getAttributeDefinition(1, true).getName());
            schema4.addAttribute(1);
            schema4.eraseAttribute(1);
            T017_SchemaTest.assertEquals((boolean)true, (boolean)schema4.getAttributeDefinition(1, true).isErasing());
            T017_SchemaTest.assertEquals((String)"fou", (String)s.getSeriesDefinition(1, true).getName());
            schema4.setAttributeProperty(1, db.getProperty("prop1", true));
            schema4.setAttributeDefault(1, (Object)"t1v1");
            schema4.applyUpdates();
            schema1 = ((Schema)db.getSchemas("schema1a").iterator().next()).edit();
            schema1.setBase(schema4);
            schema1.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, null, "D30110");
        }
    }

    public void test_300_add_series_to_schema4_but_dont_apply() {
        try {
            UpdatableSchema schema4 = (UpdatableSchema)db.getUpdatableSchemas("schema4").iterator().next();
            Schema s = schema4.resolve();
            T017_SchemaTest.assertEquals((String)"fou", (String)s.getSeriesDefinition(1, true).getName());
            schema4.addSeries(1);
            schema4.eraseSeries(1);
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_310_set_schema2_as_base_of_schema3() {
        try {
            UpdatableSchema schema2 = (UpdatableSchema)db.getUpdatableSchemas("schema2").iterator().next();
            UpdatableSchema schema3 = (UpdatableSchema)db.getUpdatableSchemas("schema3").iterator().next();
            schema3.setBase(schema2);
            schema3.applyUpdates();
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_320_delete_non_existing_series() {
        try {
            UpdatableSchema schema4 = (UpdatableSchema)db.getUpdatableSchemas("schema4").iterator().next();
            schema4.deleteSeries(1);
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30125");
        }
    }

    public void test_330_delete_series_in_actual_use_fails() {
        try {
            Schema schema = (Schema)db.getSchemas("schema1a").iterator().next();
            UpdatableChronicle chro = db.getTopChronicle().edit().createChronicle("schema1achro", false, "test chronicle", null, schema);
            chro.applyUpdates();
            UpdatableSeries ser = db.getUpdatableSeries("bt.schema1achro.fou", true);
            ser.setValue(Workday.DOMAIN.time("2011-06-30"), (Object)42.0);
            ser.applyUpdates();
            UpdatableSchema sch1 = schema.edit();
            sch1.deleteSeries(1);
            sch1.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, null, "D30150");
        }
    }

    public void test_340_rename_series_in_actual_use_okay() {
        try {
            Schema schema = (Schema)db.getSchemas("schema1a").iterator().next();
            Series ser = db.getSeries("bt.schema1achro.fou", true);
            T017_SchemaTest.assertEquals((Object)42.0, (Object)ser.getValue(Workday.DOMAIN.time("2011-06-30")));
            UpdatableSchema sch1 = schema.edit();
            sch1.setAttributeDefault(1, 1, (Object)"fooo");
            sch1.applyUpdates();
            ser = db.getSeries("bt.schema1achro.fooo", true);
            T017_SchemaTest.assertEquals((Object)42.0, (Object)ser.getValue(Workday.DOMAIN.time("2011-06-30")));
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_350_modify_time_domain_of_series_fails() {
        try {
            Schema schema = (Schema)db.getSchemas("schema1a").iterator().next();
            Series ser = db.getSeries("bt.schema1achro.fooo", true);
            T017_SchemaTest.assertEquals((Object)42.0, (Object)ser.getValue(Workday.DOMAIN.time("2011-06-30")));
            UpdatableSchema sch1 = schema.edit();
            sch1.setSeriesTimeDomain(1, DateTime.DOMAIN);
            sch1.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30105", "D30149");
        }
    }

    public void test_360_update_attribute_value_okay() {
        try {
            Schema schema = (Schema)db.getSchemas("schema1a").iterator().next();
            Series ser = db.getSeries("bt.schema1achro.fooo", true);
            UpdatableSchema sch1 = schema.edit();
            sch1.addAttribute(7);
            sch1.setAttributeDefault(7, (Object)"foo");
            sch1.setAttributeProperty(7, db.getProperty("prop3", true));
            sch1.applyUpdates();
            ser = db.getSeries("bt.schema1achro.fooo", true);
            Attribute sa = ser.getAttribute("prop3", false);
            T017_SchemaTest.assertEquals((String)"foo", (String)sa.get().toString());
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_370_series_attribute_overrides_chronicle_attribute() {
        try {
            Schema schema = (Schema)db.getSchemas("schema1a").iterator().next();
            UpdatableSchema sch1 = schema.edit();
            sch1.addAttribute(1, 5);
            sch1.setAttributeDefault(1, 5, (Object)"bar");
            sch1.setAttributeProperty(1, 5, db.getProperty("prop3", true));
            sch1.applyUpdates();
            Series ser = db.getSeries("bt.schema1achro.fooo", true);
            Attribute sa = ser.getAttribute("prop3", false);
            T017_SchemaTest.assertEquals((String)"bar", (String)sa.get().toString());
            Attribute ca = ser.getChronicle().getAttribute("prop3", false);
            T017_SchemaTest.assertEquals((String)"foo", (String)ca.get().toString());
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_380_delete_series_in_use_via_base_schema() {
        try {
            Schema schema = (Schema)db.getSchemas("schema4").iterator().next();
            UpdatableChronicle chro = db.getTopChronicle().edit().createChronicle("schema4chro", false, "test chronicle", null, schema);
            chro.applyUpdates();
            UpdatableSeries ser = db.getUpdatableSeries("bt.schema4chro.fooo", true);
            ser.applyUpdates();
            UpdatableSchema sch1 = (UpdatableSchema)db.getUpdatableSchemas("schema1a").iterator().next();
            sch1.deleteSeries(1);
            sch1.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, null, "D30150");
        }
    }

    public void test_390_delete_and_add_attribute() {
        try {
            UpdatableSchema schema = (UpdatableSchema)db.getUpdatableSchemas("schema1a").iterator().next();
            schema.deleteAttribute(1);
            schema.applyUpdates();
            T017_SchemaTest.assertEquals((int)1, (int)schema.getAttributeDefinitions().size());
            schema.addAttribute(1);
            schema.setAttributeProperty(1, db.getProperty("prop1", true));
            schema.setAttributeDefault(1, (Object)"t1v1");
            schema.applyUpdates();
            T017_SchemaTest.assertEquals((int)2, (int)schema.getAttributeDefinitions().size());
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_400_delete_chronicle_attribute_with_actual_values() {
        try {
            UpdatableSchema schema = (UpdatableSchema)db.getUpdatableSchemas("schema1a").iterator().next();
            UpdatableChronicle chro = db.getChronicle("bt.schema1achro", true).edit();
            T017_SchemaTest.assertEquals((String)"t1v1", (String)chro.getAttribute("prop1", true).get().toString());
            Attribute a = chro.getAttribute("prop1", true);
            a.scan((Object)"t1v2");
            T017_SchemaTest.assertEquals((String)"t1v2", (String)a.get().toString());
            chro.setAttribute(a);
            chro.applyUpdates();
            T017_SchemaTest.assertEquals((String)"t1v2", (String)chro.getAttribute("prop1", true).get().toString());
            schema.deleteAttribute(1);
            schema.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, null, "D30146");
        }
    }

    public void test_410_delete_chronicle_attribute_via_base_with_actual_values() {
        try {
            Schema schema3 = (Schema)db.getSchemas("schema3").iterator().next();
            UpdatableChronicle chro = db.getTopChronicle().edit().createChronicle("schema3chro", false, "test chronicle", null, schema3);
            chro.applyUpdates();
            Attribute a = chro.getAttribute("prop1", true);
            a.scan((Object)"t1v3");
            T017_SchemaTest.assertEquals((String)"t1v3", (String)a.get().toString());
            chro.setAttribute(a);
            chro.applyUpdates();
            T017_SchemaTest.assertEquals((String)"t1v3", (String)chro.getAttribute("prop1", true).get().toString());
            UpdatableSchema schema1 = (UpdatableSchema)db.getUpdatableSchemas("schema1a").iterator().next();
            schema1.deleteAttribute(1);
            schema1.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, null, "D30146");
        }
    }

    public void test_420_erase_attribute_in_use() {
        try {
            Chronicle chro = db.getChronicle("bt.schema3chro", true);
            T017_SchemaTest.assertEquals((String)"t1v3", (String)chro.getAttribute("prop1", true).get().toString());
            UpdatableSchema schema3 = (UpdatableSchema)db.getUpdatableSchemas("schema3").iterator().next();
            schema3.addAttribute(1);
            schema3.eraseAttribute(1);
            schema3.applyUpdates();
            T017_SchemaTest.assertEquals(null, (Object)schema3.getAttributeDefinition("prop1", false));
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30105", "D30146");
        }
    }

    public void test_430_erase_attribute_still_in_use() {
        try {
            UpdatableChronicle chro = db.getChronicle("bt.schema3chro", true).edit();
            T017_SchemaTest.assertEquals((String)"t1v3", (String)chro.getAttribute("prop1", true).get().toString());
            Attribute a = chro.getAttribute("prop1", true);
            a.reset();
            chro.setAttribute(a);
            chro.applyUpdates();
            T017_SchemaTest.assertEquals((String)"t1v2", (String)chro.getAttribute("prop1", true).get().toString());
            UpdatableSchema schema3 = (UpdatableSchema)db.getUpdatableSchemas("schema3").iterator().next();
            schema3.addAttribute(1);
            schema3.eraseAttribute(1);
            schema3.applyUpdates();
            T017_SchemaTest.assertEquals(null, (Object)schema3.getAttributeDefinition("prop1", false));
            T017_SchemaTest.assertEquals((String)"t1v2", (String)chro.getAttribute("prop1", true).get().toString());
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    public void test_440_delete_schema_in_use() {
        try {
            UpdatableSchema schema1 = ((Schema)db.getSchemas("schema1a").iterator().next()).edit();
            schema1.destroy();
            schema1.applyUpdates();
            T017_SchemaTest.expectException();
        }
        catch (Exception e) {
            T017_SchemaTest.assertException(e, "D30140");
        }
    }

    public void test_450_set_chronicle_attribute_with_value_same_as_default() {
        try {
            Schema schema1 = (Schema)db.getSchemas("schema1a").iterator().next();
            UpdatableChronicle chro = db.getTopChronicle().edit().createChronicle("schema1achro2", false, "test chronicle", null, schema1);
            chro.applyUpdates();
            Attribute a = chro.getAttribute("prop1", true);
            T017_SchemaTest.assertEquals((String)"t1v1", (String)schema1.getAttributeDefinition("prop1", false).getValue().toString());
            a.scan((Object)"t1v1");
            chro.setAttribute(a);
            chro.applyUpdates();
            T017_SchemaTest.assertEquals((String)"t1v1", (String)chro.getAttribute("prop1", true).get().toString());
            UpdatableSchema uschema1 = schema1.edit();
            uschema1.setAttributeDefault(1, (Object)"t1v2");
            uschema1.applyUpdates();
            Chronicle c = db.getChronicle("bt.schema1achro2", true);
            T017_SchemaTest.assertEquals((String)"t1v1", (String)c.getAttribute("prop1", true).get().toString());
        }
        catch (Exception e) {
            T017_SchemaTest.fail((String)e.getMessage());
        }
    }

    static {
        DEBUG = false;
    }
}

