/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.api.Attribute;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableProperty;
import ch.agent.crnickl.api.UpdatableSchema;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.junit.AbstractTest;
import ch.agent.crnickl.junit.Util;
import ch.agent.t2.time.Day;
import java.util.Collection;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class T015_SchemaChronicleSeriesValueTest
extends AbstractTest {
    private static Database db;

    @Override
    protected void firstSetUp() throws Exception {
        db = this.getContext().getDatabase();
    }

    @Override
    protected void lastTearDown() throws Exception {
        Util.deleteChronicles(db, "bt.fooent");
        Util.deleteSchema(db, "foo schema");
        Util.deleteProperties(db, "foo property");
        Util.deleteValueTypes(db, "foo type");
    }

    public void test012_create_type() {
        try {
            UpdatableValueType vt = db.createValueType("foo type", true, "TEXT");
            vt.addValue(vt.getScanner().scan("bar"), "it's bar");
            vt.applyUpdates();
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"foo type", (String)db.getValueType(vt.getSurrogate()).getName());
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"it's bar", (String)((String)db.getValueType(vt.getSurrogate()).getValueDescriptions().get("bar")));
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.getMessage());
        }
    }

    public void test013_value_type() {
        try {
            ValueType vt = db.getValueType("foo type");
            Collection values = vt.getValues(null);
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"bar - it's bar", (String)((String)values.iterator().next()));
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.getMessage());
        }
    }

    public void test016_add_value_but_should_not() {
        try {
            UpdatableValueType vt = db.getValueType("foo type").typeCheck(String.class).edit();
            vt.updateValue(vt.getScanner().scan("baz"), "BAZ");
            vt.applyUpdates();
            T015_SchemaChronicleSeriesValueTest.expectException();
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.assertException(e, "D10123");
        }
    }

    public void test020_add_value_and_delete_it() {
        try {
            UpdatableValueType vt = db.getValueType("foo type").typeCheck(String.class).edit();
            vt.addValue(vt.getScanner().scan("baz"), "BAZ");
            vt.addValue(vt.getScanner().scan("barf"), "BARF");
            vt.applyUpdates();
            vt.deleteValue(vt.getScanner().scan("baz"));
            vt.applyUpdates();
            T015_SchemaChronicleSeriesValueTest.assertTrue((vt.getValueDescriptions().get("baz") == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.toString());
        }
    }

    public void test024_create_property() {
        try {
            ValueType type = db.getValueType("foo type");
            UpdatableProperty p = db.createProperty("foo property", type, true);
            p.applyUpdates();
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"foo type", (String)db.getProperty(p.getSurrogate()).getValueType().getName());
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.getMessage());
        }
    }

    public void test026_delete_value_type_in_use() {
        try {
            UpdatableValueType type = db.getValueType("foo type").typeCheck(String.class).edit();
            type.destroy();
            type.applyUpdates();
            T015_SchemaChronicleSeriesValueTest.expectException();
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.assertException(e, "E10145", "E10149");
        }
    }

    public void test028_create_schema() {
        try {
            UpdatableSchema schema = db.createSchema("foo schema", null);
            schema.addAttribute(2);
            schema.setAttributeProperty(2, db.getProperty("foo property", true));
            schema.setAttributeDefault(2, (Object)"bar");
            schema.addSeries(1);
            schema.setSeriesName(1, "fooser");
            schema.setSeriesType(1, "numeric");
            schema.setSeriesTimeDomain(1, Day.DOMAIN);
            schema.applyUpdates();
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"foo property", (String)((Schema)db.getSchemas("foo schema").iterator().next()).getAttributeDefinition(2, true).getName());
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.getMessage());
        }
    }

    public void test032_create_entity() {
        try {
            Schema schema = (Schema)db.getSchemas("foo schema").iterator().next();
            UpdatableChronicle ent = db.getTopChronicle().edit().createChronicle("fooent", false, "foo entity", null, schema);
            ent.getAttribute("foo property", true);
            ent.applyUpdates();
            T015_SchemaChronicleSeriesValueTest.assertNotNull((Object)ent.getAttribute("foo property", false));
            T015_SchemaChronicleSeriesValueTest.assertNull((Object)ent.getAttribute("bar property", false));
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.getMessage());
        }
    }

    public void test036_create_series_and_add_value() {
        try {
            UpdatableChronicle ent = db.getChronicle("bt.fooent", true).edit();
            UpdatableSeries s = ent.updateSeries("fooser");
            T015_SchemaChronicleSeriesValueTest.assertNull((Object)s);
            s = db.getUpdatableSeries("bt.fooent.fooser", true);
            T015_SchemaChronicleSeriesValueTest.assertNotNull((Object)s);
            s.setValue(Day.DOMAIN.time("2011-06-30"), (Object)42.0);
            s.applyUpdates();
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.getMessage());
        }
    }

    public void test040_create_series_and_delete_value() {
        try {
            UpdatableChronicle ent = db.getChronicle("bt.fooent", true).edit();
            UpdatableSeries s = ent.updateSeries("fooser");
            T015_SchemaChronicleSeriesValueTest.assertNotNull((Object)s);
            s.setValue(Day.DOMAIN.time("2011-06-30"), (Object)Double.NaN);
            s.applyUpdates();
            s.setValue(Day.DOMAIN.time("2011-06-30"), (Object)Double.NaN);
            s.applyUpdates();
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.getMessage());
        }
    }

    public void test044_update_attribute() {
        try {
            UpdatableChronicle ent = db.getChronicle("bt.fooent", true).edit();
            Attribute attr = ent.getAttribute("foo property", true).typeCheck(String.class);
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"bar", (String)((String)attr.get()));
            attr.set((Object)"baz");
            T015_SchemaChronicleSeriesValueTest.expectException();
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.assertException(e, "D20110", "D10115");
        }
    }

    public void test048_update_attribute() {
        try {
            UpdatableProperty prop = db.getProperty("foo property", true).typeCheck(String.class).edit();
            UpdatableValueType vt = prop.getValueType().edit();
            vt.addValue((Object)"baz", "this is baz");
            vt.applyUpdates();
            UpdatableChronicle ent = db.getChronicle("bt.fooent", true).edit();
            Attribute attr = ent.getAttribute("foo property", true).typeCheck(String.class);
            attr.set((Object)"baz");
            ent.setAttribute(attr);
            ent.applyUpdates();
            Attribute a = ent.getAttribute("foo property", true).typeCheck(String.class);
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"baz", (String)((String)a.get()));
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.getMessage());
        }
    }

    public void test049_update_attribute() {
        try {
            UpdatableChronicle ent = db.getChronicle("bt.fooent", true).edit();
            Attribute attr = ent.getAttribute("foo property", true).typeCheck(String.class);
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"baz", (String)((String)attr.get()));
            attr.set((Object)"barf");
            ent.setAttribute(attr);
            ent.applyUpdates();
            attr.set((Object)"baz");
            ent.setAttribute(attr);
            ent.applyUpdates();
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.getMessage());
        }
    }

    public void test050_delete_value_type_value_in_use() {
        try {
            UpdatableValueType type = db.getValueType("foo type").typeCheck(String.class).edit();
            type.deleteValue((Object)"baz");
            type.applyUpdates();
            T015_SchemaChronicleSeriesValueTest.expectException();
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.assertException(e, "E10146", "E10158");
        }
    }

    public void test051_delete_value_type_value_used_as_default() {
        try {
            UpdatableValueType type = db.getValueType("foo type").typeCheck(String.class).edit();
            type.deleteValue((Object)"bar");
            type.applyUpdates();
            T015_SchemaChronicleSeriesValueTest.expectException();
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.assertException(e, "E10146", "E10157");
        }
    }

    public void test052_get_attribute() {
        try {
            Chronicle ent = db.getChronicle("bt.fooent", true);
            Attribute attr = ent.getAttribute("foo property", true).typeCheck(String.class);
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"baz", (String)((String)attr.get()));
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"this is baz", (String)attr.getDescription(true));
            T015_SchemaChronicleSeriesValueTest.assertEquals(null, (String)attr.getDescription(false));
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"this is baz", (String)((String)attr.getProperty().getValueType().getValueDescriptions().get("baz")));
            AttributeDefinition def = ent.getSchema(true).getAttributeDefinition("foo property", true).typeCheck(String.class);
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"bar", (String)((String)def.getAttribute().get()));
            T015_SchemaChronicleSeriesValueTest.assertEquals((String)"it's bar", (String)def.getAttribute().getDescription(true));
            T015_SchemaChronicleSeriesValueTest.assertEquals(null, (String)def.getAttribute().getDescription(false));
        }
        catch (Exception e) {
            T015_SchemaChronicleSeriesValueTest.fail((String)e.getMessage());
        }
    }
}

