/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.UpdatableProperty;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.junit.AbstractTest;
import java.util.Collection;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class T013_PropertyTest
extends AbstractTest {
    private Database db;
    private static boolean DUMP = false;

    @Override
    protected void setUp() throws Exception {
        this.db = this.getContext().getDatabase();
    }

    public void test_010_create_type() {
        try {
            UpdatableValueType vt = this.db.createValueType("foo type", true, "TEXT");
            vt.addValue(vt.getScanner().scan("bar"), "it's bar");
            vt.addValue(vt.getScanner().scan("baf"), "it's baf");
            vt.applyUpdates();
            T013_PropertyTest.assertEquals((String)"foo type", (String)this.db.getValueType(vt.getSurrogate()).getName());
            T013_PropertyTest.assertEquals((String)"it's bar", (String)((String)this.db.getValueType(vt.getSurrogate()).getValueDescriptions().get("bar")));
        }
        catch (Exception e) {
            T013_PropertyTest.fail((String)e.getMessage());
        }
    }

    public void test_020_create_another_type() {
        try {
            UpdatableValueType vt = this.db.createValueType("bar type", true, "TEXT");
            vt.addValue(vt.getScanner().scan("foo"), "it's foo");
            vt.addValue(vt.getScanner().scan("baf"), "it's baf");
            vt.applyUpdates();
            T013_PropertyTest.assertEquals((String)"bar type", (String)this.db.getValueType(vt.getSurrogate()).getName());
            T013_PropertyTest.assertEquals((String)"it's foo", (String)((String)this.db.getValueType(vt.getSurrogate()).getValueDescriptions().get("foo")));
        }
        catch (Exception e) {
            T013_PropertyTest.fail((String)e.getMessage());
        }
    }

    public void test_030_create_property() {
        try {
            ValueType type = this.db.getValueType("foo type");
            UpdatableProperty p = this.db.createProperty("foo property", type, true);
            p.applyUpdates();
            T013_PropertyTest.assertEquals((String)"foo type", (String)this.db.getProperty(p.getSurrogate()).getValueType().getName());
        }
        catch (Exception e) {
            T013_PropertyTest.fail((String)e.getMessage());
        }
    }

    public void test_040_create_another_property() {
        try {
            ValueType type = this.db.getValueType("bar type");
            UpdatableProperty p = this.db.createProperty("bar property", type, true);
            p.applyUpdates();
            T013_PropertyTest.assertEquals((String)"bar type", (String)this.db.getProperty(p.getSurrogate()).getValueType().getName());
        }
        catch (Exception e) {
            T013_PropertyTest.fail((String)e.getMessage());
        }
    }

    public void test_050_cannot_create_existing_property() {
        try {
            ValueType type = this.db.getValueType("bar type");
            UpdatableProperty p = this.db.createProperty("bar property", type, true);
            p.applyUpdates();
            T013_PropertyTest.expectException();
        }
        catch (Exception e) {
            T013_PropertyTest.assertException(e, "E20114");
        }
    }

    public void test_060_property_detects_bad_value() {
        try {
            UpdatableProperty p = this.db.getProperty("foo property", true).typeCheck(String.class).edit();
            p.scan("baz");
            T013_PropertyTest.expectException();
        }
        catch (Exception e) {
            T013_PropertyTest.assertException(e, "D20110");
        }
    }

    public void test_070_property_accepts_good_value() {
        try {
            UpdatableProperty p = this.db.getProperty("foo property", true).typeCheck(String.class).edit();
            p.scan("baf");
        }
        catch (Exception e) {
            T013_PropertyTest.fail((String)e.getMessage());
        }
    }

    public void test_080_get_properties_by_pattern() {
        try {
            Collection props = this.db.getProperties("*prop*");
            if (DUMP) {
                for (Property prop : props) {
                    System.err.println(prop.toString());
                    ValueType vt = prop.getValueType();
                    System.err.println("  " + vt.toString());
                    if (!vt.isRestricted()) continue;
                    for (String v : vt.getValues(null)) {
                        System.err.println("    " + v);
                    }
                }
            }
            T013_PropertyTest.assertEquals((int)2, (int)props.size());
        }
        catch (Exception e) {
            T013_PropertyTest.fail((String)e.getMessage());
        }
    }

    public void test_090_get_all_properties() {
        try {
            Collection props = this.db.getProperties(null);
            if (DUMP) {
                for (Property prop : props) {
                    System.err.println(prop.toString());
                    ValueType vt = prop.getValueType();
                    System.err.println("  " + vt.toString());
                    if (!vt.isRestricted()) continue;
                    for (String v : vt.getValues(null)) {
                        System.err.println("    " + v);
                    }
                }
            }
            T013_PropertyTest.assertEquals((int)6, (int)props.size());
        }
        catch (Exception e) {
            T013_PropertyTest.fail((String)e.getMessage());
        }
    }

    public void test_100_rename_property() {
        try {
            UpdatableProperty p = this.db.getProperty("foo property", true).typeCheck(String.class).edit();
            p.setName("moo property");
            p.applyUpdates();
            T013_PropertyTest.assertEquals((String)"moo property", (String)this.db.getProperty("moo property", true).getName());
            this.db.getProperty("foo property", true);
            T013_PropertyTest.expectException();
        }
        catch (Exception e) {
            T013_PropertyTest.assertException(e, "D20109");
        }
    }

    public void test_110_cannot_delete_value_type_in_use() {
        try {
            UpdatableValueType type = this.db.getValueType("foo type").typeCheck(String.class).edit();
            type.destroy();
            type.applyUpdates();
            T013_PropertyTest.expectException();
        }
        catch (Exception e) {
            T013_PropertyTest.assertException(e, "E10145", "E10149");
        }
    }

    public void test_120_delete_property_and_type() {
        try {
            UpdatableProperty p = this.db.getProperty("moo property", true).typeCheck(String.class).edit();
            UpdatableValueType vt = p.getValueType().edit();
            p.destroy();
            p.applyUpdates();
            if (this.db.getProperty("moo property", false) != null) {
                T013_PropertyTest.fail((String)"foo property found");
            }
            vt.destroy();
            vt.applyUpdates();
        }
        catch (Exception e) {
            T013_PropertyTest.fail((String)e.getMessage());
        }
    }

    public void test_130_delete_other_property_and_type() {
        try {
            UpdatableProperty p = this.db.getProperty("bar property", true).typeCheck(String.class).edit();
            UpdatableValueType vt = p.getValueType().edit();
            p.destroy();
            p.applyUpdates();
            vt.destroy();
            vt.applyUpdates();
            if (this.db.getProperty("bar property", false) != null) {
                T013_PropertyTest.fail((String)"bar property found");
            }
        }
        catch (Exception e) {
            T013_PropertyTest.fail((String)e.getMessage());
        }
    }
}

