/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.junit;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObjectId;
import ch.agent.crnickl.api.DBObjectType;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.impl.DatabaseBackend;
import ch.agent.crnickl.impl.SurrogateImpl;
import ch.agent.crnickl.junit.AbstractTest;
import ch.agent.crnickl.junit.Util;
import ch.agent.t2.time.TimeDomain;

public abstract class T005_BasicTest
extends AbstractTest {
    private static Database db;
    private static final String BASE = "bt.basictest";
    private static final String ENTITY = "bt.basictest.test";

    protected abstract DBObjectId id(int var1);

    @Override
    protected void firstSetUp() throws Exception {
        db = this.getContext().getDatabase();
        Chronicle basic = db.getChronicle(BASE, false);
        if (basic == null) {
            String[] split = db.getNamingPolicy().split(BASE);
            Chronicle base = db.getChronicle(split[0], true);
            base.edit().createChronicle(split[1], false, "Unit tests", null, null).applyUpdates();
        } else {
            Util.deleteChronicleCollection(basic);
        }
    }

    @Override
    protected void lastTearDown() throws Exception {
        Util.deleteChronicles(db, BASE);
    }

    public void test1() {
        try {
            Chronicle e = db.getChronicle(BASE, true);
            T005_BasicTest.assertEquals((String)BASE, (String)e.getName(true));
        }
        catch (Exception e) {
            T005_BasicTest.fail((String)e.getMessage());
        }
    }

    public void test2() {
        try {
            db.getChronicle("foo.bar", true);
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D40103");
        }
    }

    public void test3() {
        try {
            Chronicle e1 = db.getChronicle(BASE, true);
            Chronicle e2 = db.getChronicle(e1.getSurrogate());
            T005_BasicTest.assertEquals((Object)e1, (Object)e2);
        }
        catch (Exception e) {
            T005_BasicTest.fail((String)e.getMessage());
        }
    }

    public void test4() {
        try {
            Chronicle e1 = db.getChronicle(BASE, true);
            Chronicle e2 = db.getChronicle(e1.getSurrogate());
            T005_BasicTest.assertEquals((Object)e1.getSchema(true), (Object)e2.getSchema(true));
        }
        catch (Exception e) {
            T005_BasicTest.fail((String)e.getMessage());
        }
    }

    public void test5() {
        try {
            Chronicle e1 = db.getChronicle(BASE, true);
            Chronicle e2 = db.getChronicle(e1.getSurrogate());
            T005_BasicTest.assertEquals((Object)e1.getCollection(), (Object)e2.getCollection());
        }
        catch (Exception e) {
            T005_BasicTest.fail((String)e.getMessage());
        }
    }

    public void test6() {
        try {
            Chronicle e = db.getChronicle(db.getTopChronicle().getName(true), true);
            e.getAttribute("Currency", true);
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D40101");
        }
    }

    public void test7() {
        try {
            Chronicle e = db.getChronicle(db.getTopChronicle().getName(true), true);
            T005_BasicTest.assertNull((Object)e.getSurrogate().getObject());
        }
        catch (Exception e) {
            T005_BasicTest.fail((String)e.toString());
        }
    }

    public void test8() {
        try {
            Chronicle e1 = db.getChronicle(db.getTopChronicle().getName(true), true);
            db.getChronicle(e1.getSurrogate());
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D02102");
        }
    }

    public void test9() {
        try {
            Chronicle e = db.getChronicle(BASE, true);
            e.getAttribute("Currency", true);
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D40114");
        }
    }

    public void test10() {
        try {
            String[] split = db.getNamingPolicy().split(ENTITY);
            Chronicle base = db.getChronicle(split[0], true);
            base.edit().createChronicle(split[1], false, "test entity", null, null).applyUpdates();
            T005_BasicTest.assertEquals((String)ENTITY, (String)db.getChronicle(ENTITY, true).getName(true));
        }
        catch (T2DBException e) {
            T005_BasicTest.fail((String)e.getMessage());
        }
    }

    public void test11() {
        try {
            Chronicle e1 = db.getChronicle(ENTITY, true);
            Chronicle e2 = db.getChronicle(e1.getSurrogate());
            T005_BasicTest.assertEquals((Object)e1, (Object)e2);
        }
        catch (Exception e) {
            T005_BasicTest.fail((String)e.getMessage());
        }
    }

    public void test12() {
        try {
            Chronicle e1 = db.getChronicle(ENTITY, true);
            Chronicle e2 = db.getChronicle(e1.getSurrogate());
            T005_BasicTest.assertEquals((Object)e1.getSchema(true), (Object)e2.getSchema(true));
        }
        catch (Exception e) {
            T005_BasicTest.fail((String)e.getMessage());
        }
    }

    public void test13() {
        try {
            Chronicle e1 = db.getChronicle(ENTITY, true);
            Chronicle e2 = db.getChronicle(e1.getSurrogate());
            T005_BasicTest.assertEquals((Object)e1.getCollection(), (Object)e2.getCollection());
        }
        catch (Exception e) {
            T005_BasicTest.fail((String)e.getMessage());
        }
    }

    public void test14() {
        try {
            SurrogateImpl k = new SurrogateImpl((DatabaseBackend)db, DBObjectType.CHRONICLE, this.id(42));
            db.getSeries((Surrogate)k);
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D02102");
        }
    }

    public void test15() {
        try {
            SurrogateImpl k = new SurrogateImpl((DatabaseBackend)db, DBObjectType.CHRONICLE, this.id(42));
            db.getSchema((Surrogate)k);
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D02102");
        }
    }

    public void test16() {
        try {
            SurrogateImpl k = new SurrogateImpl((DatabaseBackend)db, DBObjectType.CHRONICLE, this.id(42));
            db.getProperty((Surrogate)k);
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D02102");
        }
    }

    public void test17() {
        try {
            SurrogateImpl k = new SurrogateImpl((DatabaseBackend)db, DBObjectType.CHRONICLE, this.id(42));
            db.getValueType((Surrogate)k);
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D02102");
        }
    }

    public void test18() {
        try {
            SurrogateImpl k = new SurrogateImpl((DatabaseBackend)db, DBObjectType.SCHEMA, this.id(42));
            db.getChronicle((Surrogate)k);
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D02102");
        }
    }

    public void test19() {
        try {
            Property nameProp = db.getProperty("Symbol", true);
            T005_BasicTest.assertEquals((String)"NAME", (String)nameProp.getValueType().getExternalRepresentation());
            Property typeProp = db.getProperty("Type", true);
            T005_BasicTest.assertEquals((String)"TYPE", (String)typeProp.getValueType().getExternalRepresentation());
            Property tdProp = db.getProperty("Calendar", true);
            T005_BasicTest.assertEquals((String)"TIMEDOMAIN", (String)tdProp.getValueType().getExternalRepresentation());
            T005_BasicTest.assertFalse((boolean)nameProp.getValueType().isRestricted());
            T005_BasicTest.assertTrue((tdProp.getValueType().getValues().size() >= 5 ? 1 : 0) != 0);
            T005_BasicTest.assertEquals((int)1, (int)typeProp.getValueType().getValues().size());
        }
        catch (Exception e) {
            T005_BasicTest.fail((String)e.toString());
        }
    }

    public <S> void test20() {
        try {
            UpdatableValueType vt = db.getValueType("type").edit();
            vt.addValue(vt.scan("foo"), null);
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D10107");
        }
    }

    public void test21() {
        try {
            UpdatableValueType vt = db.getValueType("timedomain").typeCheck(TimeDomain.class).edit();
            vt.updateValue(vt.scan("daily"), "new daily");
        }
        catch (Exception e) {
            T005_BasicTest.fail((String)e.toString());
        }
    }

    public void test22() {
        try {
            UpdatableValueType vt = db.getValueType("type").typeCheck(TimeDomain.class).edit();
            vt.updateValue(vt.scan("daily"), "new daily");
            T005_BasicTest.expectException();
        }
        catch (Exception e) {
            T005_BasicTest.assertException(e, "D10101");
        }
    }
}

