/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectId;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.ValueScanner;
import ch.agent.crnickl.api.ValueType;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.mongodb.MongoDBObjectId;
import ch.agent.crnickl.mongodb.MongoDatabase;
import ch.agent.crnickl.mongodb.MongoDatabaseMethods;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.WriteConcern;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;

public class WriteMethodsForValueType
extends MongoDatabaseMethods {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createValueType(ValueType<T> vt) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            this.check(Permission.CREATE, (DBObject)vt);
            DBObjectId ox = this.insert(vt);
            surrogate = this.makeSurrogate((DBObject)vt, ox);
        }
        catch (Exception e) {
            cause = e;
        }
        if (surrogate == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E10114", (Object[])new Object[]{vt.getName()});
        }
        vt.getSurrogate().upgrade(surrogate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void deleteValueType(ValueType<T> vt, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        Surrogate s = vt.getSurrogate();
        MongoDatabase database = (MongoDatabase)s.getDatabase();
        try {
            this.check(Permission.MODIFY, (DBObject)vt);
            policy.willDelete(vt);
            ValueType original = database.getReadMethodsForValueType().getValueType(s);
            DBCollection coll = this.getMongoDB(s).getValueTypes();
            coll.remove(this.asQuery(s.getId()), WriteConcern.SAFE);
            database.sleep();
            try {
                policy.willDelete(original);
            }
            catch (T2DBException e) {
                this.createValueType(original);
                throw e;
            }
            done = true;
        }
        catch (Exception e) {
            cause = e;
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E10145", (Object[])new Object[]{vt.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void updateValueType(ValueType<T> vt, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        Surrogate s = vt.getSurrogate();
        MongoDatabase database = (MongoDatabase)s.getDatabase();
        try {
            this.check(Permission.MODIFY, (DBObject)vt);
            DBCollection coll = this.getMongoDB(s).getValueTypes();
            if (vt.isRestricted() && vt.getValues().size() > 0) {
                ValueType original = database.getReadMethodsForValueType().getValueType(s);
                Set deleted = this.deletedValues(original, vt);
                com.mongodb.DBObject operation = this.operation(MongoDatabaseMethods.Operator.SET, "name", vt.getName(), "values", this.valueDescriptionsAsMap(vt));
                if (deleted.size() > 0) {
                    Iterator it = deleted.iterator();
                    while (it.hasNext()) {
                        policy.willDelete(vt, it.next());
                    }
                    coll.update(this.asQuery(s.getId()), operation, false, false, WriteConcern.SAFE);
                    database.sleep();
                    try {
                        it = deleted.iterator();
                        while (it.hasNext()) {
                            policy.willDelete(vt, it.next());
                        }
                    }
                    catch (T2DBException e) {
                        operation = this.operation(MongoDatabaseMethods.Operator.SET, "name", original.getName(), "values", this.valueDescriptionsAsMap(original));
                        coll.update(this.asQuery(s.getId()), operation);
                        throw e;
                    }
                } else {
                    coll.update(this.asQuery(s.getId()), operation);
                }
            } else {
                coll.update(this.asQuery(s.getId()), this.operation(MongoDatabaseMethods.Operator.SET, "name", vt.getName()));
            }
            done = true;
        }
        catch (Exception e) {
            cause = e;
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E10146", (Object[])new Object[]{vt.getName()});
        }
    }

    private <T> Set<T> deletedValues(ValueType<T> original, ValueType<T> vt) throws T2DBException {
        HashSet deleted = new HashSet(original.getValues());
        deleted.removeAll(vt.getValues());
        return deleted;
    }

    private <T> DBObjectId insert(ValueType<T> vt) throws T2DBException {
        Surrogate s = vt.getSurrogate();
        BasicDBObject bo = new BasicDBObject();
        if (!s.inConstruction()) {
            bo.put("_id", (Object)this.getId((DBObject)vt));
        }
        bo.put("name", (Object)vt.getName());
        bo.put("type", (Object)vt.getExternalRepresentation());
        if (vt.isRestricted()) {
            bo.put("values", this.valueDescriptionsAsMap(vt));
        }
        this.getMongoDB(s).getValueTypes().insert(new com.mongodb.DBObject[]{bo});
        ObjectId ox = this.getObjectId(bo);
        return new MongoDBObjectId(ox);
    }

    private <T> Map<String, String> valueDescriptionsAsMap(ValueType<T> vt) throws T2DBException {
        Map vd = vt.getValueDescriptions();
        ValueScanner scanner = vt.getScanner();
        HashMap<String, String> map = new HashMap<String, String>(vd.size());
        for (Map.Entry entry : vd.entrySet()) {
            map.put(scanner.toString(entry.getKey()), (String)entry.getValue());
        }
        return map;
    }
}

