/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Property;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.impl.SchemaUpdatePolicy;
import ch.agent.crnickl.mongodb.MongoDBObjectId;
import ch.agent.crnickl.mongodb.MongoDatabase;
import ch.agent.crnickl.mongodb.MongoDatabaseMethods;
import ch.agent.crnickl.mongodb.ReadMethodsForProperty;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import org.bson.types.ObjectId;

public class WriteMethodsForProperty
extends ReadMethodsForProperty {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createProperty(Property<T> prop) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            this.check(Permission.CREATE, (ch.agent.crnickl.api.DBObject)prop);
            BasicDBObject dob = this.pack(prop);
            this.getMongoDB((ch.agent.crnickl.api.DBObject)prop).getProperties().insert(new DBObject[]{dob});
            ObjectId ox = this.getObjectId(dob);
            surrogate = this.makeSurrogate((ch.agent.crnickl.api.DBObject)prop, new MongoDBObjectId(ox));
        }
        catch (Exception e) {
            cause = e;
        }
        if (surrogate == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E20114", (Object[])new Object[]{prop.getName()});
        }
        prop.getSurrogate().upgrade(surrogate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void deleteProperty(Property<T> prop, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        Surrogate s = prop.getSurrogate();
        MongoDatabase database = (MongoDatabase)s.getDatabase();
        try {
            this.check(Permission.MODIFY, (ch.agent.crnickl.api.DBObject)prop);
            policy.willDelete(prop);
            Property original = database.getReadMethodsForProperty().getProperty(s);
            DBCollection coll = this.getMongoDB(s).getProperties();
            coll.remove(this.asQuery(s.getId()), WriteConcern.SAFE);
            database.sleep();
            try {
                policy.willDelete(original);
            }
            catch (T2DBException e) {
                this.createProperty(original);
                throw e;
            }
            done = true;
        }
        catch (Exception e) {
            cause = e;
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E20115", (Object[])new Object[]{prop.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(Property<?> prop, SchemaUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        Surrogate s = prop.getSurrogate();
        try {
            this.check(Permission.MODIFY, (ch.agent.crnickl.api.DBObject)prop);
            DBCollection coll = this.getMongoDB(s).getProperties();
            coll.update(this.asQuery(s.getId()), this.operation(MongoDatabaseMethods.Operator.SET, "name", prop.getName()));
            done = true;
        }
        catch (Exception e) {
            cause = e;
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E20116", (Object[])new Object[]{prop.getName()});
        }
    }

    private <T> BasicDBObject pack(Property<T> prop) {
        BasicDBObject bo = new BasicDBObject();
        if (!prop.getSurrogate().inConstruction()) {
            bo.put("_id", (Object)this.getId((ch.agent.crnickl.api.DBObject)prop));
        }
        bo.put("name", (Object)prop.getName());
        bo.put("type", (Object)this.getId((ch.agent.crnickl.api.DBObject)prop.getValueType()));
        bo.put("indexed", (Object)prop.isIndexed());
        return bo;
    }
}

