/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.mongodb;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.AttributeDefinition;
import ch.agent.crnickl.api.Chronicle;
import ch.agent.crnickl.api.DBObject;
import ch.agent.crnickl.api.DBObjectId;
import ch.agent.crnickl.api.Database;
import ch.agent.crnickl.api.Schema;
import ch.agent.crnickl.api.Series;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableChronicle;
import ch.agent.crnickl.api.UpdatableSeries;
import ch.agent.crnickl.impl.ChronicleUpdatePolicy;
import ch.agent.crnickl.impl.Permission;
import ch.agent.crnickl.mongodb.MongoDBObjectId;
import ch.agent.crnickl.mongodb.MongoDatabase;
import ch.agent.crnickl.mongodb.ReadMethodsForChroniclesAndSeries;
import com.mongodb.BasicDBObject;
import com.mongodb.WriteConcern;
import java.util.HashMap;
import org.bson.types.ObjectId;

public class WriteMethodsForChroniclesAndSeries
extends ReadMethodsForChroniclesAndSeries {
    public void createChronicle(Chronicle chronicle) throws T2DBException {
        this.createChronicle(chronicle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createChronicle(Chronicle chronicle, boolean undoDelete) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            String name = chronicle.getName(false);
            chronicle.getSurrogate().getDatabase().getNamingPolicy().checkSimpleName(name, false);
            String description = chronicle.getDescription(false);
            if (description == null) {
                description = "";
            }
            Chronicle collection = chronicle.getCollection();
            Schema schema = chronicle.getSchema(false);
            if (collection != null) {
                this.check(Permission.MODIFY, (DBObject)collection);
                if (schema != null && schema.equals(collection.getSchema(true))) {
                    schema = null;
                }
            }
            if (schema != null) {
                this.check(Permission.READ, (DBObject)schema);
            }
            DBObjectId ox = this.insert(chronicle);
            surrogate = this.makeSurrogate((DBObject)chronicle, ox);
        }
        catch (Exception e) {
            cause = e;
        }
        if (surrogate == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E40109", (Object[])new Object[]{chronicle.getName(true)});
        }
        if (!undoDelete) {
            chronicle.getSurrogate().upgrade(surrogate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChronicle(UpdatableChronicle chronicle, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        Surrogate s = chronicle.getSurrogate();
        MongoDatabase db = (MongoDatabase)s.getDatabase();
        try {
            this.check(Permission.MODIFY, (DBObject)chronicle);
            policy.willDelete(chronicle);
            Chronicle original = this.getChronicle(s);
            this.getMongoDB(s).getChronicles().remove(this.asQuery(s.getId()), WriteConcern.SAFE);
            db.sleep();
            try {
                policy.willDelete(chronicle);
            }
            catch (T2DBException e) {
                this.createChronicle(original, true);
                throw e;
            }
            this.deleteAttributes((Chronicle)chronicle);
            done = true;
        }
        catch (Exception e) {
            cause = e;
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E40110", (Object[])new Object[]{chronicle.getName(true)});
        }
    }

    public void updateChronicle(UpdatableChronicle chronicle, ChronicleUpdatePolicy policy) throws T2DBException {
        String name = chronicle.getName(false);
        String description = chronicle.getDescription(false);
        if (description == null) {
            description = "";
        }
        try {
            this.check(Permission.MODIFY, (DBObject)chronicle);
            policy.willUpdate(chronicle);
            this.getMongoDB(chronicle.getSurrogate()).getChronicles().update(this.mongoObject("_id", this.getId((DBObject)chronicle)), this.mongoObject("name", name, "desc", description), true, false);
        }
        catch (Exception e) {
            throw T2DBMsg.exception((String)"E40111", (Object[])new Object[]{chronicle.getName(true)});
        }
    }

    public void updateAttribute(UpdatableChronicle chronicle, AttributeDefinition<?> def, String value, String description) throws T2DBException {
        try {
            this.check(Permission.MODIFY, (DBObject)chronicle);
            this.getMongoDB(chronicle.getSurrogate()).getAttributes().update(this.mongoObject("chron", this.getId((DBObject)chronicle), "prop", this.getId((DBObject)def.getProperty())), this.mongoObject("chron", this.getId((DBObject)chronicle), "prop", this.getId((DBObject)def.getProperty()), "val", value, "descr", description), true, false);
        }
        catch (Exception e) {
            throw T2DBMsg.exception((String)"E40112", (Object[])new Object[]{chronicle.getName(true), def.getNumber()});
        }
    }

    public void deleteAttribute(Chronicle chronicle, AttributeDefinition<?> def) throws T2DBException {
        try {
            this.check(Permission.MODIFY, (DBObject)chronicle);
            this.getMongoDB(chronicle.getSurrogate()).getAttributes().remove(this.mongoObject("chron", this.getId((DBObject)chronicle), "prop", this.getId((DBObject)def.getProperty())), WriteConcern.SAFE);
        }
        catch (Exception e) {
            throw T2DBMsg.exception((String)"E40114", (Object[])new Object[]{chronicle.getName(true), def.getNumber()});
        }
    }

    private void deleteAttributes(Chronicle chronicle) throws T2DBException {
        Surrogate s = chronicle.getSurrogate();
        Database db = s.getDatabase();
        try {
            this.getMongoDB(db).getAttributes().remove(this.mongoObject("chron", this.getId(s)));
        }
        catch (Exception e) {
            throw T2DBMsg.exception((Throwable)e, (String)"E40124", (Object[])new Object[]{chronicle.getName(true)});
        }
    }

    public void createSeries(Series<?> series) throws T2DBException {
        this.createSeries(series, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSeries(Series<?> series, boolean undoDelete) throws T2DBException {
        Surrogate surrogate = null;
        Exception cause = null;
        try {
            this.check(Permission.MODIFY, (DBObject)series.getChronicle());
            DBObjectId ox = this.insert(series);
            surrogate = this.makeSurrogate((DBObject)series, ox);
        }
        catch (Exception e) {
            cause = e;
        }
        if (surrogate == null || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E50111", (Object[])new Object[]{series.getName(true)});
        }
        if (!undoDelete) {
            series.getSurrogate().upgrade(surrogate);
        }
    }

    public void deleteSeries(UpdatableSeries<?> series, ChronicleUpdatePolicy policy) throws T2DBException {
        boolean done = false;
        Exception cause = null;
        Surrogate s = series.getSurrogate();
        MongoDatabase db = (MongoDatabase)s.getDatabase();
        try {
            this.check(Permission.MODIFY, (DBObject)series);
            policy.willDelete(series);
            done = policy.deleteSeries(series);
            Series original = db.getReadMethodsForChronicleAndSeries().getSeries(s);
            this.getMongoDB((Database)db).getSeries().remove(this.asQuery(s.getId()), WriteConcern.SAFE);
            db.sleep();
            try {
                policy.willDelete(series);
            }
            catch (T2DBException e) {
                this.createSeries(original, true);
                throw e;
            }
            done = true;
        }
        catch (Exception e) {
            cause = e;
        }
        if (!done || cause != null) {
            throw T2DBMsg.exception((Throwable)cause, (String)"E50112", (Object[])new Object[]{series.getName(true)});
        }
    }

    private DBObjectId insert(Chronicle chronicle) throws T2DBException {
        BasicDBObject bo = new BasicDBObject();
        Surrogate s = chronicle.getSurrogate();
        if (!s.inConstruction()) {
            bo.put("_id", (Object)this.getId((DBObject)chronicle));
        }
        bo.put("name", (Object)chronicle.getName(false));
        bo.put("desc", (Object)chronicle.getDescription(false));
        bo.put("parent", (Object)this.getIdOrZero((DBObject)chronicle.getCollection()));
        bo.put("schema", (Object)this.getIdOrZero((DBObject)chronicle.getSchema(false)));
        this.getMongoDB(s).getChronicles().insert(new com.mongodb.DBObject[]{bo});
        ObjectId ox = this.getObjectId(bo);
        return new MongoDBObjectId(ox);
    }

    private <T> DBObjectId insert(Series<T> series) throws T2DBException {
        BasicDBObject bo = new BasicDBObject();
        Surrogate s = series.getSurrogate();
        if (!s.inConstruction()) {
            bo.put("_id", (Object)this.getId((DBObject)series));
        }
        bo.put("chron", (Object)this.getIdOrZero((DBObject)series.getChronicle()));
        bo.put("number", (Object)series.getNumber());
        bo.put("first", (Object)1);
        bo.put("last", (Object)0);
        bo.put("values", new HashMap());
        this.getMongoDB(s).getSeries().insert(new com.mongodb.DBObject[]{bo});
        ObjectId ox = this.getObjectId(bo);
        return new MongoDBObjectId(ox);
    }
}

